/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeJobResponse extends DataBrewResponse implements
        ToCopyableBuilder<DescribeJobResponse.Builder, DescribeJobResponse> {
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(DescribeJobResponse::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(DescribeJobResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(DescribeJobResponse::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyArn").getter(getter(DescribeJobResponse::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()).build();

    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionMode").getter(getter(DescribeJobResponse::encryptionModeAsString))
            .setter(setter(Builder::encryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionMode").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeJobResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DescribeJobResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedBy").getter(getter(DescribeJobResponse::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate").getter(getter(DescribeJobResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> LOG_SUBSCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogSubscription").getter(getter(DescribeJobResponse::logSubscriptionAsString))
            .setter(setter(Builder::logSubscription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogSubscription").build()).build();

    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxCapacity").getter(getter(DescribeJobResponse::maxCapacity)).setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final SdkField<Integer> MAX_RETRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRetries").getter(getter(DescribeJobResponse::maxRetries)).setter(setter(Builder::maxRetries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetries").build()).build();

    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField
            .<List<Output>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(DescribeJobResponse::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Output> builder(MarshallingType.SDK_POJO)
                                            .constructor(Output::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(DescribeJobResponse::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()).build();

    private static final SdkField<RecipeReference> RECIPE_REFERENCE_FIELD = SdkField
            .<RecipeReference> builder(MarshallingType.SDK_POJO).memberName("RecipeReference")
            .getter(getter(DescribeJobResponse::recipeReference)).setter(setter(Builder::recipeReference))
            .constructor(RecipeReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeReference").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(DescribeJobResponse::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeJobResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DescribeJobResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(DescribeJobResponse::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<JobSample> JOB_SAMPLE_FIELD = SdkField.<JobSample> builder(MarshallingType.SDK_POJO)
            .memberName("JobSample").getter(getter(DescribeJobResponse::jobSample)).setter(setter(Builder::jobSample))
            .constructor(JobSample::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobSample").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_DATE_FIELD,
            CREATED_BY_FIELD, DATASET_NAME_FIELD, ENCRYPTION_KEY_ARN_FIELD, ENCRYPTION_MODE_FIELD, NAME_FIELD, TYPE_FIELD,
            LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_DATE_FIELD, LOG_SUBSCRIPTION_FIELD, MAX_CAPACITY_FIELD, MAX_RETRIES_FIELD,
            OUTPUTS_FIELD, PROJECT_NAME_FIELD, RECIPE_REFERENCE_FIELD, RESOURCE_ARN_FIELD, ROLE_ARN_FIELD, TAGS_FIELD,
            TIMEOUT_FIELD, JOB_SAMPLE_FIELD));

    private final Instant createDate;

    private final String createdBy;

    private final String datasetName;

    private final String encryptionKeyArn;

    private final String encryptionMode;

    private final String name;

    private final String type;

    private final String lastModifiedBy;

    private final Instant lastModifiedDate;

    private final String logSubscription;

    private final Integer maxCapacity;

    private final Integer maxRetries;

    private final List<Output> outputs;

    private final String projectName;

    private final RecipeReference recipeReference;

    private final String resourceArn;

    private final String roleArn;

    private final Map<String, String> tags;

    private final Integer timeout;

    private final JobSample jobSample;

    private DescribeJobResponse(BuilderImpl builder) {
        super(builder);
        this.createDate = builder.createDate;
        this.createdBy = builder.createdBy;
        this.datasetName = builder.datasetName;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.encryptionMode = builder.encryptionMode;
        this.name = builder.name;
        this.type = builder.type;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.logSubscription = builder.logSubscription;
        this.maxCapacity = builder.maxCapacity;
        this.maxRetries = builder.maxRetries;
        this.outputs = builder.outputs;
        this.projectName = builder.projectName;
        this.recipeReference = builder.recipeReference;
        this.resourceArn = builder.resourceArn;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.timeout = builder.timeout;
        this.jobSample = builder.jobSample;
    }

    /**
     * <p>
     * The date and time that the job was created.
     * </p>
     * 
     * @return The date and time that the job was created.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The identifier (user name) of the user associated with the creation of the job.
     * </p>
     * 
     * @return The identifier (user name) of the user associated with the creation of the job.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The dataset that the job acts upon.
     * </p>
     * 
     * @return The dataset that the job acts upon.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    /**
     * <p>
     * The encryption mode for the job, which can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SSE-KMS</code> - Server-side encryption with keys managed by AWS KMS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMode}
     * will return {@link EncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionModeAsString}.
     * </p>
     * 
     * @return The encryption mode for the job, which can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SSE-KMS</code> - Server-side encryption with keys managed by AWS KMS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
     *         </p>
     *         </li>
     * @see EncryptionMode
     */
    public final EncryptionMode encryptionMode() {
        return EncryptionMode.fromValue(encryptionMode);
    }

    /**
     * <p>
     * The encryption mode for the job, which can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SSE-KMS</code> - Server-side encryption with keys managed by AWS KMS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMode}
     * will return {@link EncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionModeAsString}.
     * </p>
     * 
     * @return The encryption mode for the job, which can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SSE-KMS</code> - Server-side encryption with keys managed by AWS KMS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
     *         </p>
     *         </li>
     * @see EncryptionMode
     */
    public final String encryptionModeAsString() {
        return encryptionMode;
    }

    /**
     * <p>
     * The name of the job.
     * </p>
     * 
     * @return The name of the job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The job type, which must be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PROFILE</code> - The job analyzes the dataset to determine its size, data types, data distribution, and
     * more.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RECIPE</code> - The job applies one or more transformations to a dataset.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The job type, which must be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PROFILE</code> - The job analyzes the dataset to determine its size, data types, data distribution,
     *         and more.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RECIPE</code> - The job applies one or more transformations to a dataset.
     *         </p>
     *         </li>
     * @see JobType
     */
    public final JobType type() {
        return JobType.fromValue(type);
    }

    /**
     * <p>
     * The job type, which must be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PROFILE</code> - The job analyzes the dataset to determine its size, data types, data distribution, and
     * more.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RECIPE</code> - The job applies one or more transformations to a dataset.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The job type, which must be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PROFILE</code> - The job analyzes the dataset to determine its size, data types, data distribution,
     *         and more.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RECIPE</code> - The job applies one or more transformations to a dataset.
     *         </p>
     *         </li>
     * @see JobType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The identifier (user name) of the user who last modified the job.
     * </p>
     * 
     * @return The identifier (user name) of the user who last modified the job.
     */
    public final String lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * The date and time that the job was last modified.
     * </p>
     * 
     * @return The date and time that the job was last modified.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * Indicates whether Amazon CloudWatch logging is enabled for this job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logSubscription}
     * will return {@link LogSubscription#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logSubscriptionAsString}.
     * </p>
     * 
     * @return Indicates whether Amazon CloudWatch logging is enabled for this job.
     * @see LogSubscription
     */
    public final LogSubscription logSubscription() {
        return LogSubscription.fromValue(logSubscription);
    }

    /**
     * <p>
     * Indicates whether Amazon CloudWatch logging is enabled for this job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logSubscription}
     * will return {@link LogSubscription#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logSubscriptionAsString}.
     * </p>
     * 
     * @return Indicates whether Amazon CloudWatch logging is enabled for this job.
     * @see LogSubscription
     */
    public final String logSubscriptionAsString() {
        return logSubscription;
    }

    /**
     * <p>
     * The maximum number of compute nodes that DataBrew can consume when the job processes data.
     * </p>
     * 
     * @return The maximum number of compute nodes that DataBrew can consume when the job processes data.
     */
    public final Integer maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * The maximum number of times to retry the job after a job run fails.
     * </p>
     * 
     * @return The maximum number of times to retry the job after a job run fails.
     */
    public final Integer maxRetries() {
        return maxRetries;
    }

    /**
     * Returns true if the Outputs property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more artifacts that represent the output from running the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOutputs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more artifacts that represent the output from running the job.
     */
    public final List<Output> outputs() {
        return outputs;
    }

    /**
     * <p>
     * The DataBrew project associated with this job.
     * </p>
     * 
     * @return The DataBrew project associated with this job.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * Returns the value of the RecipeReference property for this object.
     * 
     * @return The value of the RecipeReference property for this object.
     */
    public final RecipeReference recipeReference() {
        return recipeReference;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The ARN of the AWS Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.
     * </p>
     * 
     * @return The ARN of the AWS Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata tags associated with this job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata tags associated with this job.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of
     * <code>TIMEOUT</code>.
     * </p>
     * 
     * @return The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a
     *         status of <code>TIMEOUT</code>.
     */
    public final Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * Sample configuration for profile jobs only. Determines the number of rows on which the profile job will be
     * executed.
     * </p>
     * 
     * @return Sample configuration for profile jobs only. Determines the number of rows on which the profile job will
     *         be executed.
     */
    public final JobSample jobSample() {
        return jobSample;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(logSubscriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(recipeReference());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(jobSample());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobResponse)) {
            return false;
        }
        DescribeJobResponse other = (DescribeJobResponse) obj;
        return Objects.equals(createDate(), other.createDate()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(datasetName(), other.datasetName())
                && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn())
                && Objects.equals(encryptionModeAsString(), other.encryptionModeAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(logSubscriptionAsString(), other.logSubscriptionAsString())
                && Objects.equals(maxCapacity(), other.maxCapacity()) && Objects.equals(maxRetries(), other.maxRetries())
                && hasOutputs() == other.hasOutputs() && Objects.equals(outputs(), other.outputs())
                && Objects.equals(projectName(), other.projectName())
                && Objects.equals(recipeReference(), other.recipeReference())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(roleArn(), other.roleArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(timeout(), other.timeout()) && Objects.equals(jobSample(), other.jobSample());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeJobResponse").add("CreateDate", createDate()).add("CreatedBy", createdBy())
                .add("DatasetName", datasetName()).add("EncryptionKeyArn", encryptionKeyArn())
                .add("EncryptionMode", encryptionModeAsString()).add("Name", name()).add("Type", typeAsString())
                .add("LastModifiedBy", lastModifiedBy()).add("LastModifiedDate", lastModifiedDate())
                .add("LogSubscription", logSubscriptionAsString()).add("MaxCapacity", maxCapacity())
                .add("MaxRetries", maxRetries()).add("Outputs", hasOutputs() ? outputs() : null)
                .add("ProjectName", projectName()).add("RecipeReference", recipeReference()).add("ResourceArn", resourceArn())
                .add("RoleArn", roleArn()).add("Tags", hasTags() ? tags() : null).add("Timeout", timeout())
                .add("JobSample", jobSample()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "EncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        case "EncryptionMode":
            return Optional.ofNullable(clazz.cast(encryptionModeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "LogSubscription":
            return Optional.ofNullable(clazz.cast(logSubscriptionAsString()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "MaxRetries":
            return Optional.ofNullable(clazz.cast(maxRetries()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "RecipeReference":
            return Optional.ofNullable(clazz.cast(recipeReference()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "JobSample":
            return Optional.ofNullable(clazz.cast(jobSample()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobResponse, T> g) {
        return obj -> g.apply((DescribeJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataBrewResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeJobResponse> {
        /**
         * <p>
         * The date and time that the job was created.
         * </p>
         * 
         * @param createDate
         *        The date and time that the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The identifier (user name) of the user associated with the creation of the job.
         * </p>
         * 
         * @param createdBy
         *        The identifier (user name) of the user associated with the creation of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The dataset that the job acts upon.
         * </p>
         * 
         * @param datasetName
         *        The dataset that the job acts upon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        /**
         * <p>
         * The encryption mode for the job, which can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SSE-KMS</code> - Server-side encryption with keys managed by AWS KMS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionMode
         *        The encryption mode for the job, which can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SSE-KMS</code> - Server-side encryption with keys managed by AWS KMS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
         *        </p>
         *        </li>
         * @see EncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionMode
         */
        Builder encryptionMode(String encryptionMode);

        /**
         * <p>
         * The encryption mode for the job, which can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SSE-KMS</code> - Server-side encryption with keys managed by AWS KMS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionMode
         *        The encryption mode for the job, which can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SSE-KMS</code> - Server-side encryption with keys managed by AWS KMS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
         *        </p>
         *        </li>
         * @see EncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionMode
         */
        Builder encryptionMode(EncryptionMode encryptionMode);

        /**
         * <p>
         * The name of the job.
         * </p>
         * 
         * @param name
         *        The name of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The job type, which must be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PROFILE</code> - The job analyzes the dataset to determine its size, data types, data distribution, and
         * more.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RECIPE</code> - The job applies one or more transformations to a dataset.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The job type, which must be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PROFILE</code> - The job analyzes the dataset to determine its size, data types, data
         *        distribution, and more.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RECIPE</code> - The job applies one or more transformations to a dataset.
         *        </p>
         *        </li>
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder type(String type);

        /**
         * <p>
         * The job type, which must be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PROFILE</code> - The job analyzes the dataset to determine its size, data types, data distribution, and
         * more.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RECIPE</code> - The job applies one or more transformations to a dataset.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The job type, which must be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PROFILE</code> - The job analyzes the dataset to determine its size, data types, data
         *        distribution, and more.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RECIPE</code> - The job applies one or more transformations to a dataset.
         *        </p>
         *        </li>
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder type(JobType type);

        /**
         * <p>
         * The identifier (user name) of the user who last modified the job.
         * </p>
         * 
         * @param lastModifiedBy
         *        The identifier (user name) of the user who last modified the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(String lastModifiedBy);

        /**
         * <p>
         * The date and time that the job was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time that the job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * Indicates whether Amazon CloudWatch logging is enabled for this job.
         * </p>
         * 
         * @param logSubscription
         *        Indicates whether Amazon CloudWatch logging is enabled for this job.
         * @see LogSubscription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogSubscription
         */
        Builder logSubscription(String logSubscription);

        /**
         * <p>
         * Indicates whether Amazon CloudWatch logging is enabled for this job.
         * </p>
         * 
         * @param logSubscription
         *        Indicates whether Amazon CloudWatch logging is enabled for this job.
         * @see LogSubscription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogSubscription
         */
        Builder logSubscription(LogSubscription logSubscription);

        /**
         * <p>
         * The maximum number of compute nodes that DataBrew can consume when the job processes data.
         * </p>
         * 
         * @param maxCapacity
         *        The maximum number of compute nodes that DataBrew can consume when the job processes data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Integer maxCapacity);

        /**
         * <p>
         * The maximum number of times to retry the job after a job run fails.
         * </p>
         * 
         * @param maxRetries
         *        The maximum number of times to retry the job after a job run fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRetries(Integer maxRetries);

        /**
         * <p>
         * One or more artifacts that represent the output from running the job.
         * </p>
         * 
         * @param outputs
         *        One or more artifacts that represent the output from running the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<Output> outputs);

        /**
         * <p>
         * One or more artifacts that represent the output from running the job.
         * </p>
         * 
         * @param outputs
         *        One or more artifacts that represent the output from running the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Output... outputs);

        /**
         * <p>
         * One or more artifacts that represent the output from running the job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Output>.Builder} avoiding the need to
         * create one manually via {@link List<Output>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Output>.Builder#build()} is called immediately and its
         * result is passed to {@link #outputs(List<Output>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on {@link List<Output>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(List<Output>)
         */
        Builder outputs(Consumer<Output.Builder>... outputs);

        /**
         * <p>
         * The DataBrew project associated with this job.
         * </p>
         * 
         * @param projectName
         *        The DataBrew project associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * Sets the value of the RecipeReference property for this object.
         *
         * @param recipeReference
         *        The new value for the RecipeReference property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeReference(RecipeReference recipeReference);

        /**
         * Sets the value of the RecipeReference property for this object.
         *
         * This is a convenience that creates an instance of the {@link RecipeReference.Builder} avoiding the need to
         * create one manually via {@link RecipeReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecipeReference.Builder#build()} is called immediately and its
         * result is passed to {@link #recipeReference(RecipeReference)}.
         * 
         * @param recipeReference
         *        a consumer that will call methods on {@link RecipeReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recipeReference(RecipeReference)
         */
        default Builder recipeReference(Consumer<RecipeReference.Builder> recipeReference) {
            return recipeReference(RecipeReference.builder().applyMutation(recipeReference).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the job.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The ARN of the AWS Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the AWS Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Metadata tags associated with this job.
         * </p>
         * 
         * @param tags
         *        Metadata tags associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status
         * of <code>TIMEOUT</code>.
         * </p>
         * 
         * @param timeout
         *        The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a
         *        status of <code>TIMEOUT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * Sample configuration for profile jobs only. Determines the number of rows on which the profile job will be
         * executed.
         * </p>
         * 
         * @param jobSample
         *        Sample configuration for profile jobs only. Determines the number of rows on which the profile job
         *        will be executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobSample(JobSample jobSample);

        /**
         * <p>
         * Sample configuration for profile jobs only. Determines the number of rows on which the profile job will be
         * executed.
         * </p>
         * This is a convenience that creates an instance of the {@link JobSample.Builder} avoiding the need to create
         * one manually via {@link JobSample#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobSample.Builder#build()} is called immediately and its result
         * is passed to {@link #jobSample(JobSample)}.
         * 
         * @param jobSample
         *        a consumer that will call methods on {@link JobSample.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobSample(JobSample)
         */
        default Builder jobSample(Consumer<JobSample.Builder> jobSample) {
            return jobSample(JobSample.builder().applyMutation(jobSample).build());
        }
    }

    static final class BuilderImpl extends DataBrewResponse.BuilderImpl implements Builder {
        private Instant createDate;

        private String createdBy;

        private String datasetName;

        private String encryptionKeyArn;

        private String encryptionMode;

        private String name;

        private String type;

        private String lastModifiedBy;

        private Instant lastModifiedDate;

        private String logSubscription;

        private Integer maxCapacity;

        private Integer maxRetries;

        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();

        private String projectName;

        private RecipeReference recipeReference;

        private String resourceArn;

        private String roleArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Integer timeout;

        private JobSample jobSample;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobResponse model) {
            super(model);
            createDate(model.createDate);
            createdBy(model.createdBy);
            datasetName(model.datasetName);
            encryptionKeyArn(model.encryptionKeyArn);
            encryptionMode(model.encryptionMode);
            name(model.name);
            type(model.type);
            lastModifiedBy(model.lastModifiedBy);
            lastModifiedDate(model.lastModifiedDate);
            logSubscription(model.logSubscription);
            maxCapacity(model.maxCapacity);
            maxRetries(model.maxRetries);
            outputs(model.outputs);
            projectName(model.projectName);
            recipeReference(model.recipeReference);
            resourceArn(model.resourceArn);
            roleArn(model.roleArn);
            tags(model.tags);
            timeout(model.timeout);
            jobSample(model.jobSample);
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final String getDatasetName() {
            return datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        public final String getEncryptionMode() {
            return encryptionMode;
        }

        @Override
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        @Override
        public final Builder encryptionMode(EncryptionMode encryptionMode) {
            this.encryptionMode(encryptionMode == null ? null : encryptionMode.toString());
            return this;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(JobType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getLastModifiedBy() {
            return lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getLogSubscription() {
            return logSubscription;
        }

        @Override
        public final Builder logSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
            return this;
        }

        @Override
        public final Builder logSubscription(LogSubscription logSubscription) {
            this.logSubscription(logSubscription == null ? null : logSubscription.toString());
            return this;
        }

        public final void setLogSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
        }

        public final Integer getMaxCapacity() {
            return maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public final Integer getMaxRetries() {
            return maxRetries;
        }

        @Override
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        public final List<Output.Builder> getOutputs() {
            List<Output.Builder> result = OutputListCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputListCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> Output.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = OutputListCopier.copyFromBuilder(outputs);
        }

        public final String getProjectName() {
            return projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final RecipeReference.Builder getRecipeReference() {
            return recipeReference != null ? recipeReference.toBuilder() : null;
        }

        @Override
        public final Builder recipeReference(RecipeReference recipeReference) {
            this.recipeReference = recipeReference;
            return this;
        }

        public final void setRecipeReference(RecipeReference.BuilderImpl recipeReference) {
            this.recipeReference = recipeReference != null ? recipeReference.build() : null;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final Integer getTimeout() {
            return timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final JobSample.Builder getJobSample() {
            return jobSample != null ? jobSample.toBuilder() : null;
        }

        @Override
        public final Builder jobSample(JobSample jobSample) {
            this.jobSample = jobSample;
            return this;
        }

        public final void setJobSample(JobSample.BuilderImpl jobSample) {
            this.jobSample = jobSample != null ? jobSample.build() : null;
        }

        @Override
        public DescribeJobResponse build() {
            return new DescribeJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
