/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeJobRunResponse extends DataBrewResponse implements
        ToCopyableBuilder<DescribeJobRunResponse.Builder, DescribeJobRunResponse> {
    private static final SdkField<Integer> ATTEMPT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Attempt").getter(getter(DescribeJobRunResponse::attempt)).setter(setter(Builder::attempt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attempt").build()).build();

    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletedOn").getter(getter(DescribeJobRunResponse::completedOn)).setter(setter(Builder::completedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()).build();

    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(DescribeJobRunResponse::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(DescribeJobRunResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<Integer> EXECUTION_TIME_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExecutionTime").getter(getter(DescribeJobRunResponse::executionTime))
            .setter(setter(Builder::executionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTime").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(DescribeJobRunResponse::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RunId")
            .getter(getter(DescribeJobRunResponse::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DescribeJobRunResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> LOG_SUBSCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogSubscription").getter(getter(DescribeJobRunResponse::logSubscriptionAsString))
            .setter(setter(Builder::logSubscription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogSubscription").build()).build();

    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogGroupName").getter(getter(DescribeJobRunResponse::logGroupName))
            .setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName").build()).build();

    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField
            .<List<Output>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(DescribeJobRunResponse::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Output> builder(MarshallingType.SDK_POJO)
                                            .constructor(Output::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RecipeReference> RECIPE_REFERENCE_FIELD = SdkField
            .<RecipeReference> builder(MarshallingType.SDK_POJO).memberName("RecipeReference")
            .getter(getter(DescribeJobRunResponse::recipeReference)).setter(setter(Builder::recipeReference))
            .constructor(RecipeReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeReference").build()).build();

    private static final SdkField<String> STARTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartedBy").getter(getter(DescribeJobRunResponse::startedBy)).setter(setter(Builder::startedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedBy").build()).build();

    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedOn").getter(getter(DescribeJobRunResponse::startedOn)).setter(setter(Builder::startedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()).build();

    private static final SdkField<JobSample> JOB_SAMPLE_FIELD = SdkField.<JobSample> builder(MarshallingType.SDK_POJO)
            .memberName("JobSample").getter(getter(DescribeJobRunResponse::jobSample)).setter(setter(Builder::jobSample))
            .constructor(JobSample::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobSample").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTEMPT_FIELD,
            COMPLETED_ON_FIELD, DATASET_NAME_FIELD, ERROR_MESSAGE_FIELD, EXECUTION_TIME_FIELD, JOB_NAME_FIELD, RUN_ID_FIELD,
            STATE_FIELD, LOG_SUBSCRIPTION_FIELD, LOG_GROUP_NAME_FIELD, OUTPUTS_FIELD, RECIPE_REFERENCE_FIELD, STARTED_BY_FIELD,
            STARTED_ON_FIELD, JOB_SAMPLE_FIELD));

    private final Integer attempt;

    private final Instant completedOn;

    private final String datasetName;

    private final String errorMessage;

    private final Integer executionTime;

    private final String jobName;

    private final String runId;

    private final String state;

    private final String logSubscription;

    private final String logGroupName;

    private final List<Output> outputs;

    private final RecipeReference recipeReference;

    private final String startedBy;

    private final Instant startedOn;

    private final JobSample jobSample;

    private DescribeJobRunResponse(BuilderImpl builder) {
        super(builder);
        this.attempt = builder.attempt;
        this.completedOn = builder.completedOn;
        this.datasetName = builder.datasetName;
        this.errorMessage = builder.errorMessage;
        this.executionTime = builder.executionTime;
        this.jobName = builder.jobName;
        this.runId = builder.runId;
        this.state = builder.state;
        this.logSubscription = builder.logSubscription;
        this.logGroupName = builder.logGroupName;
        this.outputs = builder.outputs;
        this.recipeReference = builder.recipeReference;
        this.startedBy = builder.startedBy;
        this.startedOn = builder.startedOn;
        this.jobSample = builder.jobSample;
    }

    /**
     * <p>
     * The number of times that DataBrew has attempted to run the job.
     * </p>
     * 
     * @return The number of times that DataBrew has attempted to run the job.
     */
    public final Integer attempt() {
        return attempt;
    }

    /**
     * <p>
     * The date and time when the job completed processing.
     * </p>
     * 
     * @return The date and time when the job completed processing.
     */
    public final Instant completedOn() {
        return completedOn;
    }

    /**
     * <p>
     * The name of the dataset for the job to process.
     * </p>
     * 
     * @return The name of the dataset for the job to process.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * A message indicating an error (if any) that was encountered when the job ran.
     * </p>
     * 
     * @return A message indicating an error (if any) that was encountered when the job ran.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The amount of time, in seconds, during which the job run consumed resources.
     * </p>
     * 
     * @return The amount of time, in seconds, during which the job run consumed resources.
     */
    public final Integer executionTime() {
        return executionTime;
    }

    /**
     * <p>
     * The name of the job being processed during this run.
     * </p>
     * 
     * @return The name of the job being processed during this run.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The unique identifier of the job run.
     * </p>
     * 
     * @return The unique identifier of the job run.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * The current state of the job run entity itself.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JobRunState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the job run entity itself.
     * @see JobRunState
     */
    public final JobRunState state() {
        return JobRunState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the job run entity itself.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JobRunState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the job run entity itself.
     * @see JobRunState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The current status of Amazon CloudWatch logging for the job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logSubscription}
     * will return {@link LogSubscription#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logSubscriptionAsString}.
     * </p>
     * 
     * @return The current status of Amazon CloudWatch logging for the job run.
     * @see LogSubscription
     */
    public final LogSubscription logSubscription() {
        return LogSubscription.fromValue(logSubscription);
    }

    /**
     * <p>
     * The current status of Amazon CloudWatch logging for the job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logSubscription}
     * will return {@link LogSubscription#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logSubscriptionAsString}.
     * </p>
     * 
     * @return The current status of Amazon CloudWatch logging for the job run.
     * @see LogSubscription
     */
    public final String logSubscriptionAsString() {
        return logSubscription;
    }

    /**
     * <p>
     * The name of an Amazon CloudWatch log group, where the job writes diagnostic messages when it runs.
     * </p>
     * 
     * @return The name of an Amazon CloudWatch log group, where the job writes diagnostic messages when it runs.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * Returns true if the Outputs property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more output artifacts from a job run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOutputs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more output artifacts from a job run.
     */
    public final List<Output> outputs() {
        return outputs;
    }

    /**
     * Returns the value of the RecipeReference property for this object.
     * 
     * @return The value of the RecipeReference property for this object.
     */
    public final RecipeReference recipeReference() {
        return recipeReference;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who started the job run.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who started the job run.
     */
    public final String startedBy() {
        return startedBy;
    }

    /**
     * <p>
     * The date and time when the job run began.
     * </p>
     * 
     * @return The date and time when the job run began.
     */
    public final Instant startedOn() {
        return startedOn;
    }

    /**
     * <p>
     * Sample configuration for profile jobs only. Determines the number of rows on which the profile job will be
     * executed. If a JobSample value is not provided, the default value will be used. The default value is CUSTOM_ROWS
     * for the mode parameter and 20000 for the size parameter.
     * </p>
     * 
     * @return Sample configuration for profile jobs only. Determines the number of rows on which the profile job will
     *         be executed. If a JobSample value is not provided, the default value will be used. The default value is
     *         CUSTOM_ROWS for the mode parameter and 20000 for the size parameter.
     */
    public final JobSample jobSample() {
        return jobSample;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attempt());
        hashCode = 31 * hashCode + Objects.hashCode(completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(executionTime());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logSubscriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recipeReference());
        hashCode = 31 * hashCode + Objects.hashCode(startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(jobSample());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobRunResponse)) {
            return false;
        }
        DescribeJobRunResponse other = (DescribeJobRunResponse) obj;
        return Objects.equals(attempt(), other.attempt()) && Objects.equals(completedOn(), other.completedOn())
                && Objects.equals(datasetName(), other.datasetName()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(executionTime(), other.executionTime()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(runId(), other.runId()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(logSubscriptionAsString(), other.logSubscriptionAsString())
                && Objects.equals(logGroupName(), other.logGroupName()) && hasOutputs() == other.hasOutputs()
                && Objects.equals(outputs(), other.outputs()) && Objects.equals(recipeReference(), other.recipeReference())
                && Objects.equals(startedBy(), other.startedBy()) && Objects.equals(startedOn(), other.startedOn())
                && Objects.equals(jobSample(), other.jobSample());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeJobRunResponse").add("Attempt", attempt()).add("CompletedOn", completedOn())
                .add("DatasetName", datasetName()).add("ErrorMessage", errorMessage()).add("ExecutionTime", executionTime())
                .add("JobName", jobName()).add("RunId", runId()).add("State", stateAsString())
                .add("LogSubscription", logSubscriptionAsString()).add("LogGroupName", logGroupName())
                .add("Outputs", hasOutputs() ? outputs() : null).add("RecipeReference", recipeReference())
                .add("StartedBy", startedBy()).add("StartedOn", startedOn()).add("JobSample", jobSample()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attempt":
            return Optional.ofNullable(clazz.cast(attempt()));
        case "CompletedOn":
            return Optional.ofNullable(clazz.cast(completedOn()));
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "ExecutionTime":
            return Optional.ofNullable(clazz.cast(executionTime()));
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "RunId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "LogSubscription":
            return Optional.ofNullable(clazz.cast(logSubscriptionAsString()));
        case "LogGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "RecipeReference":
            return Optional.ofNullable(clazz.cast(recipeReference()));
        case "StartedBy":
            return Optional.ofNullable(clazz.cast(startedBy()));
        case "StartedOn":
            return Optional.ofNullable(clazz.cast(startedOn()));
        case "JobSample":
            return Optional.ofNullable(clazz.cast(jobSample()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobRunResponse, T> g) {
        return obj -> g.apply((DescribeJobRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataBrewResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeJobRunResponse> {
        /**
         * <p>
         * The number of times that DataBrew has attempted to run the job.
         * </p>
         * 
         * @param attempt
         *        The number of times that DataBrew has attempted to run the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attempt(Integer attempt);

        /**
         * <p>
         * The date and time when the job completed processing.
         * </p>
         * 
         * @param completedOn
         *        The date and time when the job completed processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedOn(Instant completedOn);

        /**
         * <p>
         * The name of the dataset for the job to process.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset for the job to process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * A message indicating an error (if any) that was encountered when the job ran.
         * </p>
         * 
         * @param errorMessage
         *        A message indicating an error (if any) that was encountered when the job ran.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The amount of time, in seconds, during which the job run consumed resources.
         * </p>
         * 
         * @param executionTime
         *        The amount of time, in seconds, during which the job run consumed resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTime(Integer executionTime);

        /**
         * <p>
         * The name of the job being processed during this run.
         * </p>
         * 
         * @param jobName
         *        The name of the job being processed during this run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The unique identifier of the job run.
         * </p>
         * 
         * @param runId
         *        The unique identifier of the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The current state of the job run entity itself.
         * </p>
         * 
         * @param state
         *        The current state of the job run entity itself.
         * @see JobRunState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobRunState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the job run entity itself.
         * </p>
         * 
         * @param state
         *        The current state of the job run entity itself.
         * @see JobRunState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobRunState
         */
        Builder state(JobRunState state);

        /**
         * <p>
         * The current status of Amazon CloudWatch logging for the job run.
         * </p>
         * 
         * @param logSubscription
         *        The current status of Amazon CloudWatch logging for the job run.
         * @see LogSubscription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogSubscription
         */
        Builder logSubscription(String logSubscription);

        /**
         * <p>
         * The current status of Amazon CloudWatch logging for the job run.
         * </p>
         * 
         * @param logSubscription
         *        The current status of Amazon CloudWatch logging for the job run.
         * @see LogSubscription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogSubscription
         */
        Builder logSubscription(LogSubscription logSubscription);

        /**
         * <p>
         * The name of an Amazon CloudWatch log group, where the job writes diagnostic messages when it runs.
         * </p>
         * 
         * @param logGroupName
         *        The name of an Amazon CloudWatch log group, where the job writes diagnostic messages when it runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * One or more output artifacts from a job run.
         * </p>
         * 
         * @param outputs
         *        One or more output artifacts from a job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<Output> outputs);

        /**
         * <p>
         * One or more output artifacts from a job run.
         * </p>
         * 
         * @param outputs
         *        One or more output artifacts from a job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Output... outputs);

        /**
         * <p>
         * One or more output artifacts from a job run.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Output>.Builder} avoiding the need to
         * create one manually via {@link List<Output>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Output>.Builder#build()} is called immediately and its
         * result is passed to {@link #outputs(List<Output>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on {@link List<Output>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(List<Output>)
         */
        Builder outputs(Consumer<Output.Builder>... outputs);

        /**
         * Sets the value of the RecipeReference property for this object.
         *
         * @param recipeReference
         *        The new value for the RecipeReference property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeReference(RecipeReference recipeReference);

        /**
         * Sets the value of the RecipeReference property for this object.
         *
         * This is a convenience that creates an instance of the {@link RecipeReference.Builder} avoiding the need to
         * create one manually via {@link RecipeReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecipeReference.Builder#build()} is called immediately and its
         * result is passed to {@link #recipeReference(RecipeReference)}.
         * 
         * @param recipeReference
         *        a consumer that will call methods on {@link RecipeReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recipeReference(RecipeReference)
         */
        default Builder recipeReference(Consumer<RecipeReference.Builder> recipeReference) {
            return recipeReference(RecipeReference.builder().applyMutation(recipeReference).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who started the job run.
         * </p>
         * 
         * @param startedBy
         *        The Amazon Resource Name (ARN) of the user who started the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedBy(String startedBy);

        /**
         * <p>
         * The date and time when the job run began.
         * </p>
         * 
         * @param startedOn
         *        The date and time when the job run began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedOn(Instant startedOn);

        /**
         * <p>
         * Sample configuration for profile jobs only. Determines the number of rows on which the profile job will be
         * executed. If a JobSample value is not provided, the default value will be used. The default value is
         * CUSTOM_ROWS for the mode parameter and 20000 for the size parameter.
         * </p>
         * 
         * @param jobSample
         *        Sample configuration for profile jobs only. Determines the number of rows on which the profile job
         *        will be executed. If a JobSample value is not provided, the default value will be used. The default
         *        value is CUSTOM_ROWS for the mode parameter and 20000 for the size parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobSample(JobSample jobSample);

        /**
         * <p>
         * Sample configuration for profile jobs only. Determines the number of rows on which the profile job will be
         * executed. If a JobSample value is not provided, the default value will be used. The default value is
         * CUSTOM_ROWS for the mode parameter and 20000 for the size parameter.
         * </p>
         * This is a convenience that creates an instance of the {@link JobSample.Builder} avoiding the need to create
         * one manually via {@link JobSample#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobSample.Builder#build()} is called immediately and its result
         * is passed to {@link #jobSample(JobSample)}.
         * 
         * @param jobSample
         *        a consumer that will call methods on {@link JobSample.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobSample(JobSample)
         */
        default Builder jobSample(Consumer<JobSample.Builder> jobSample) {
            return jobSample(JobSample.builder().applyMutation(jobSample).build());
        }
    }

    static final class BuilderImpl extends DataBrewResponse.BuilderImpl implements Builder {
        private Integer attempt;

        private Instant completedOn;

        private String datasetName;

        private String errorMessage;

        private Integer executionTime;

        private String jobName;

        private String runId;

        private String state;

        private String logSubscription;

        private String logGroupName;

        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();

        private RecipeReference recipeReference;

        private String startedBy;

        private Instant startedOn;

        private JobSample jobSample;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobRunResponse model) {
            super(model);
            attempt(model.attempt);
            completedOn(model.completedOn);
            datasetName(model.datasetName);
            errorMessage(model.errorMessage);
            executionTime(model.executionTime);
            jobName(model.jobName);
            runId(model.runId);
            state(model.state);
            logSubscription(model.logSubscription);
            logGroupName(model.logGroupName);
            outputs(model.outputs);
            recipeReference(model.recipeReference);
            startedBy(model.startedBy);
            startedOn(model.startedOn);
            jobSample(model.jobSample);
        }

        public final Integer getAttempt() {
            return attempt;
        }

        @Override
        public final Builder attempt(Integer attempt) {
            this.attempt = attempt;
            return this;
        }

        public final void setAttempt(Integer attempt) {
            this.attempt = attempt;
        }

        public final Instant getCompletedOn() {
            return completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        public final String getDatasetName() {
            return datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Integer getExecutionTime() {
            return executionTime;
        }

        @Override
        public final Builder executionTime(Integer executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public final void setExecutionTime(Integer executionTime) {
            this.executionTime = executionTime;
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getRunId() {
            return runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JobRunState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getLogSubscription() {
            return logSubscription;
        }

        @Override
        public final Builder logSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
            return this;
        }

        @Override
        public final Builder logSubscription(LogSubscription logSubscription) {
            this.logSubscription(logSubscription == null ? null : logSubscription.toString());
            return this;
        }

        public final void setLogSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final List<Output.Builder> getOutputs() {
            List<Output.Builder> result = OutputListCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputListCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> Output.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = OutputListCopier.copyFromBuilder(outputs);
        }

        public final RecipeReference.Builder getRecipeReference() {
            return recipeReference != null ? recipeReference.toBuilder() : null;
        }

        @Override
        public final Builder recipeReference(RecipeReference recipeReference) {
            this.recipeReference = recipeReference;
            return this;
        }

        public final void setRecipeReference(RecipeReference.BuilderImpl recipeReference) {
            this.recipeReference = recipeReference != null ? recipeReference.build() : null;
        }

        public final String getStartedBy() {
            return startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        public final Instant getStartedOn() {
            return startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        public final JobSample.Builder getJobSample() {
            return jobSample != null ? jobSample.toBuilder() : null;
        }

        @Override
        public final Builder jobSample(JobSample jobSample) {
            this.jobSample = jobSample;
            return this;
        }

        public final void setJobSample(JobSample.BuilderImpl jobSample) {
            this.jobSample = jobSample != null ? jobSample.build() : null;
        }

        @Override
        public DescribeJobRunResponse build() {
            return new DescribeJobRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
