/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a limit imposed on number of S3 files that should be selected for a dataset from a connected S3 path.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilesLimit implements SdkPojo, Serializable, ToCopyableBuilder<FilesLimit.Builder, FilesLimit> {
    private static final SdkField<Integer> MAX_FILES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxFiles").getter(getter(FilesLimit::maxFiles)).setter(setter(Builder::maxFiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFiles").build()).build();

    private static final SdkField<String> ORDERED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrderedBy").getter(getter(FilesLimit::orderedByAsString)).setter(setter(Builder::orderedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderedBy").build()).build();

    private static final SdkField<String> ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Order")
            .getter(getter(FilesLimit::orderAsString)).setter(setter(Builder::order))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Order").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_FILES_FIELD,
            ORDERED_BY_FIELD, ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxFiles;

    private final String orderedBy;

    private final String order;

    private FilesLimit(BuilderImpl builder) {
        this.maxFiles = builder.maxFiles;
        this.orderedBy = builder.orderedBy;
        this.order = builder.order;
    }

    /**
     * <p>
     * The number of S3 files to select.
     * </p>
     * 
     * @return The number of S3 files to select.
     */
    public final Integer maxFiles() {
        return maxFiles;
    }

    /**
     * <p>
     * A criteria to use for S3 files sorting before their selection. By default uses LAST_MODIFIED_DATE as a sorting
     * criteria. Currently it's the only allowed value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderedBy} will
     * return {@link OrderedBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderedByAsString}.
     * </p>
     * 
     * @return A criteria to use for S3 files sorting before their selection. By default uses LAST_MODIFIED_DATE as a
     *         sorting criteria. Currently it's the only allowed value.
     * @see OrderedBy
     */
    public final OrderedBy orderedBy() {
        return OrderedBy.fromValue(orderedBy);
    }

    /**
     * <p>
     * A criteria to use for S3 files sorting before their selection. By default uses LAST_MODIFIED_DATE as a sorting
     * criteria. Currently it's the only allowed value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderedBy} will
     * return {@link OrderedBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderedByAsString}.
     * </p>
     * 
     * @return A criteria to use for S3 files sorting before their selection. By default uses LAST_MODIFIED_DATE as a
     *         sorting criteria. Currently it's the only allowed value.
     * @see OrderedBy
     */
    public final String orderedByAsString() {
        return orderedBy;
    }

    /**
     * <p>
     * A criteria to use for S3 files sorting before their selection. By default uses DESCENDING order, i.e. most recent
     * files are selected first. Anotherpossible value is ASCENDING.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link Order#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return A criteria to use for S3 files sorting before their selection. By default uses DESCENDING order, i.e.
     *         most recent files are selected first. Anotherpossible value is ASCENDING.
     * @see Order
     */
    public final Order order() {
        return Order.fromValue(order);
    }

    /**
     * <p>
     * A criteria to use for S3 files sorting before their selection. By default uses DESCENDING order, i.e. most recent
     * files are selected first. Anotherpossible value is ASCENDING.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link Order#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return A criteria to use for S3 files sorting before their selection. By default uses DESCENDING order, i.e.
     *         most recent files are selected first. Anotherpossible value is ASCENDING.
     * @see Order
     */
    public final String orderAsString() {
        return order;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxFiles());
        hashCode = 31 * hashCode + Objects.hashCode(orderedByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(orderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilesLimit)) {
            return false;
        }
        FilesLimit other = (FilesLimit) obj;
        return Objects.equals(maxFiles(), other.maxFiles()) && Objects.equals(orderedByAsString(), other.orderedByAsString())
                && Objects.equals(orderAsString(), other.orderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilesLimit").add("MaxFiles", maxFiles()).add("OrderedBy", orderedByAsString())
                .add("Order", orderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxFiles":
            return Optional.ofNullable(clazz.cast(maxFiles()));
        case "OrderedBy":
            return Optional.ofNullable(clazz.cast(orderedByAsString()));
        case "Order":
            return Optional.ofNullable(clazz.cast(orderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilesLimit, T> g) {
        return obj -> g.apply((FilesLimit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilesLimit> {
        /**
         * <p>
         * The number of S3 files to select.
         * </p>
         * 
         * @param maxFiles
         *        The number of S3 files to select.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFiles(Integer maxFiles);

        /**
         * <p>
         * A criteria to use for S3 files sorting before their selection. By default uses LAST_MODIFIED_DATE as a
         * sorting criteria. Currently it's the only allowed value.
         * </p>
         * 
         * @param orderedBy
         *        A criteria to use for S3 files sorting before their selection. By default uses LAST_MODIFIED_DATE as a
         *        sorting criteria. Currently it's the only allowed value.
         * @see OrderedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderedBy
         */
        Builder orderedBy(String orderedBy);

        /**
         * <p>
         * A criteria to use for S3 files sorting before their selection. By default uses LAST_MODIFIED_DATE as a
         * sorting criteria. Currently it's the only allowed value.
         * </p>
         * 
         * @param orderedBy
         *        A criteria to use for S3 files sorting before their selection. By default uses LAST_MODIFIED_DATE as a
         *        sorting criteria. Currently it's the only allowed value.
         * @see OrderedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderedBy
         */
        Builder orderedBy(OrderedBy orderedBy);

        /**
         * <p>
         * A criteria to use for S3 files sorting before their selection. By default uses DESCENDING order, i.e. most
         * recent files are selected first. Anotherpossible value is ASCENDING.
         * </p>
         * 
         * @param order
         *        A criteria to use for S3 files sorting before their selection. By default uses DESCENDING order, i.e.
         *        most recent files are selected first. Anotherpossible value is ASCENDING.
         * @see Order
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Order
         */
        Builder order(String order);

        /**
         * <p>
         * A criteria to use for S3 files sorting before their selection. By default uses DESCENDING order, i.e. most
         * recent files are selected first. Anotherpossible value is ASCENDING.
         * </p>
         * 
         * @param order
         *        A criteria to use for S3 files sorting before their selection. By default uses DESCENDING order, i.e.
         *        most recent files are selected first. Anotherpossible value is ASCENDING.
         * @see Order
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Order
         */
        Builder order(Order order);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxFiles;

        private String orderedBy;

        private String order;

        private BuilderImpl() {
        }

        private BuilderImpl(FilesLimit model) {
            maxFiles(model.maxFiles);
            orderedBy(model.orderedBy);
            order(model.order);
        }

        public final Integer getMaxFiles() {
            return maxFiles;
        }

        @Override
        public final Builder maxFiles(Integer maxFiles) {
            this.maxFiles = maxFiles;
            return this;
        }

        public final void setMaxFiles(Integer maxFiles) {
            this.maxFiles = maxFiles;
        }

        public final String getOrderedBy() {
            return orderedBy;
        }

        @Override
        public final Builder orderedBy(String orderedBy) {
            this.orderedBy = orderedBy;
            return this;
        }

        @Override
        public final Builder orderedBy(OrderedBy orderedBy) {
            this.orderedBy(orderedBy == null ? null : orderedBy.toString());
            return this;
        }

        public final void setOrderedBy(String orderedBy) {
            this.orderedBy = orderedBy;
        }

        public final String getOrder() {
            return order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(Order order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public FilesLimit build() {
            return new FilesLimit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
