/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a set of options that define how DataBrew selects files for a given S3 path in a dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PathOptions implements SdkPojo, Serializable, ToCopyableBuilder<PathOptions.Builder, PathOptions> {
    private static final SdkField<FilterExpression> LAST_MODIFIED_DATE_CONDITION_FIELD = SdkField
            .<FilterExpression> builder(MarshallingType.SDK_POJO).memberName("LastModifiedDateCondition")
            .getter(getter(PathOptions::lastModifiedDateCondition)).setter(setter(Builder::lastModifiedDateCondition))
            .constructor(FilterExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDateCondition").build())
            .build();

    private static final SdkField<FilesLimit> FILES_LIMIT_FIELD = SdkField.<FilesLimit> builder(MarshallingType.SDK_POJO)
            .memberName("FilesLimit").getter(getter(PathOptions::filesLimit)).setter(setter(Builder::filesLimit))
            .constructor(FilesLimit::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesLimit").build()).build();

    private static final SdkField<Map<String, DatasetParameter>> PARAMETERS_FIELD = SdkField
            .<Map<String, DatasetParameter>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(PathOptions::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<DatasetParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAST_MODIFIED_DATE_CONDITION_FIELD, FILES_LIMIT_FIELD, PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final FilterExpression lastModifiedDateCondition;

    private final FilesLimit filesLimit;

    private final Map<String, DatasetParameter> parameters;

    private PathOptions(BuilderImpl builder) {
        this.lastModifiedDateCondition = builder.lastModifiedDateCondition;
        this.filesLimit = builder.filesLimit;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * If provided, this structure defines a date range for matching S3 objects based on their LastModifiedDate
     * attribute in S3.
     * </p>
     * 
     * @return If provided, this structure defines a date range for matching S3 objects based on their LastModifiedDate
     *         attribute in S3.
     */
    public final FilterExpression lastModifiedDateCondition() {
        return lastModifiedDateCondition;
    }

    /**
     * <p>
     * If provided, this structure imposes a limit on a number of files that should be selected.
     * </p>
     * 
     * @return If provided, this structure imposes a limit on a number of files that should be selected.
     */
    public final FilesLimit filesLimit() {
        return filesLimit;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A structure that maps names of parameters used in the S3 path of a dataset to their definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A structure that maps names of parameters used in the S3 path of a dataset to their definitions.
     */
    public final Map<String, DatasetParameter> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDateCondition());
        hashCode = 31 * hashCode + Objects.hashCode(filesLimit());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathOptions)) {
            return false;
        }
        PathOptions other = (PathOptions) obj;
        return Objects.equals(lastModifiedDateCondition(), other.lastModifiedDateCondition())
                && Objects.equals(filesLimit(), other.filesLimit()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PathOptions").add("LastModifiedDateCondition", lastModifiedDateCondition())
                .add("FilesLimit", filesLimit()).add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LastModifiedDateCondition":
            return Optional.ofNullable(clazz.cast(lastModifiedDateCondition()));
        case "FilesLimit":
            return Optional.ofNullable(clazz.cast(filesLimit()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PathOptions, T> g) {
        return obj -> g.apply((PathOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PathOptions> {
        /**
         * <p>
         * If provided, this structure defines a date range for matching S3 objects based on their LastModifiedDate
         * attribute in S3.
         * </p>
         * 
         * @param lastModifiedDateCondition
         *        If provided, this structure defines a date range for matching S3 objects based on their
         *        LastModifiedDate attribute in S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDateCondition(FilterExpression lastModifiedDateCondition);

        /**
         * <p>
         * If provided, this structure defines a date range for matching S3 objects based on their LastModifiedDate
         * attribute in S3.
         * </p>
         * This is a convenience that creates an instance of the {@link FilterExpression.Builder} avoiding the need to
         * create one manually via {@link FilterExpression#builder()}.
         *
         * When the {@link Consumer} completes, {@link FilterExpression.Builder#build()} is called immediately and its
         * result is passed to {@link #lastModifiedDateCondition(FilterExpression)}.
         * 
         * @param lastModifiedDateCondition
         *        a consumer that will call methods on {@link FilterExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedDateCondition(FilterExpression)
         */
        default Builder lastModifiedDateCondition(Consumer<FilterExpression.Builder> lastModifiedDateCondition) {
            return lastModifiedDateCondition(FilterExpression.builder().applyMutation(lastModifiedDateCondition).build());
        }

        /**
         * <p>
         * If provided, this structure imposes a limit on a number of files that should be selected.
         * </p>
         * 
         * @param filesLimit
         *        If provided, this structure imposes a limit on a number of files that should be selected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filesLimit(FilesLimit filesLimit);

        /**
         * <p>
         * If provided, this structure imposes a limit on a number of files that should be selected.
         * </p>
         * This is a convenience that creates an instance of the {@link FilesLimit.Builder} avoiding the need to create
         * one manually via {@link FilesLimit#builder()}.
         *
         * When the {@link Consumer} completes, {@link FilesLimit.Builder#build()} is called immediately and its result
         * is passed to {@link #filesLimit(FilesLimit)}.
         * 
         * @param filesLimit
         *        a consumer that will call methods on {@link FilesLimit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filesLimit(FilesLimit)
         */
        default Builder filesLimit(Consumer<FilesLimit.Builder> filesLimit) {
            return filesLimit(FilesLimit.builder().applyMutation(filesLimit).build());
        }

        /**
         * <p>
         * A structure that maps names of parameters used in the S3 path of a dataset to their definitions.
         * </p>
         * 
         * @param parameters
         *        A structure that maps names of parameters used in the S3 path of a dataset to their definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, DatasetParameter> parameters);
    }

    static final class BuilderImpl implements Builder {
        private FilterExpression lastModifiedDateCondition;

        private FilesLimit filesLimit;

        private Map<String, DatasetParameter> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PathOptions model) {
            lastModifiedDateCondition(model.lastModifiedDateCondition);
            filesLimit(model.filesLimit);
            parameters(model.parameters);
        }

        public final FilterExpression.Builder getLastModifiedDateCondition() {
            return lastModifiedDateCondition != null ? lastModifiedDateCondition.toBuilder() : null;
        }

        @Override
        public final Builder lastModifiedDateCondition(FilterExpression lastModifiedDateCondition) {
            this.lastModifiedDateCondition = lastModifiedDateCondition;
            return this;
        }

        public final void setLastModifiedDateCondition(FilterExpression.BuilderImpl lastModifiedDateCondition) {
            this.lastModifiedDateCondition = lastModifiedDateCondition != null ? lastModifiedDateCondition.build() : null;
        }

        public final FilesLimit.Builder getFilesLimit() {
            return filesLimit != null ? filesLimit.toBuilder() : null;
        }

        @Override
        public final Builder filesLimit(FilesLimit filesLimit) {
            this.filesLimit = filesLimit;
            return this;
        }

        public final void setFilesLimit(FilesLimit.BuilderImpl filesLimit) {
            this.filesLimit = filesLimit != null ? filesLimit.build() : null;
        }

        public final Map<String, DatasetParameter.Builder> getParameters() {
            Map<String, DatasetParameter.Builder> result = PathParametersMapCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder parameters(Map<String, DatasetParameter> parameters) {
            this.parameters = PathParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, DatasetParameter.BuilderImpl> parameters) {
            this.parameters = PathParametersMapCopier.copyFromBuilder(parameters);
        }

        @Override
        public PathOptions build() {
            return new PathOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
