/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the data being transformed during an action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ViewFrame implements SdkPojo, Serializable, ToCopyableBuilder<ViewFrame.Builder, ViewFrame> {
    private static final SdkField<Integer> START_COLUMN_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartColumnIndex").getter(getter(ViewFrame::startColumnIndex)).setter(setter(Builder::startColumnIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartColumnIndex").build()).build();

    private static final SdkField<Integer> COLUMN_RANGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ColumnRange").getter(getter(ViewFrame::columnRange)).setter(setter(Builder::columnRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnRange").build()).build();

    private static final SdkField<List<String>> HIDDEN_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HiddenColumns")
            .getter(getter(ViewFrame::hiddenColumns))
            .setter(setter(Builder::hiddenColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_COLUMN_INDEX_FIELD,
            COLUMN_RANGE_FIELD, HIDDEN_COLUMNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer startColumnIndex;

    private final Integer columnRange;

    private final List<String> hiddenColumns;

    private ViewFrame(BuilderImpl builder) {
        this.startColumnIndex = builder.startColumnIndex;
        this.columnRange = builder.columnRange;
        this.hiddenColumns = builder.hiddenColumns;
    }

    /**
     * <p>
     * The starting index for the range of columns to return in the view frame.
     * </p>
     * 
     * @return The starting index for the range of columns to return in the view frame.
     */
    public final Integer startColumnIndex() {
        return startColumnIndex;
    }

    /**
     * <p>
     * The number of columns to include in the view frame, beginning with the <code>StartColumnIndex</code> value and
     * ignoring any columns in the <code>HiddenColumns</code> list.
     * </p>
     * 
     * @return The number of columns to include in the view frame, beginning with the <code>StartColumnIndex</code>
     *         value and ignoring any columns in the <code>HiddenColumns</code> list.
     */
    public final Integer columnRange() {
        return columnRange;
    }

    /**
     * Returns true if the HiddenColumns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasHiddenColumns() {
        return hiddenColumns != null && !(hiddenColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of columns to hide in the view frame.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHiddenColumns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of columns to hide in the view frame.
     */
    public final List<String> hiddenColumns() {
        return hiddenColumns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startColumnIndex());
        hashCode = 31 * hashCode + Objects.hashCode(columnRange());
        hashCode = 31 * hashCode + Objects.hashCode(hasHiddenColumns() ? hiddenColumns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewFrame)) {
            return false;
        }
        ViewFrame other = (ViewFrame) obj;
        return Objects.equals(startColumnIndex(), other.startColumnIndex()) && Objects.equals(columnRange(), other.columnRange())
                && hasHiddenColumns() == other.hasHiddenColumns() && Objects.equals(hiddenColumns(), other.hiddenColumns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ViewFrame").add("StartColumnIndex", startColumnIndex()).add("ColumnRange", columnRange())
                .add("HiddenColumns", hasHiddenColumns() ? hiddenColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartColumnIndex":
            return Optional.ofNullable(clazz.cast(startColumnIndex()));
        case "ColumnRange":
            return Optional.ofNullable(clazz.cast(columnRange()));
        case "HiddenColumns":
            return Optional.ofNullable(clazz.cast(hiddenColumns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ViewFrame, T> g) {
        return obj -> g.apply((ViewFrame) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ViewFrame> {
        /**
         * <p>
         * The starting index for the range of columns to return in the view frame.
         * </p>
         * 
         * @param startColumnIndex
         *        The starting index for the range of columns to return in the view frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startColumnIndex(Integer startColumnIndex);

        /**
         * <p>
         * The number of columns to include in the view frame, beginning with the <code>StartColumnIndex</code> value
         * and ignoring any columns in the <code>HiddenColumns</code> list.
         * </p>
         * 
         * @param columnRange
         *        The number of columns to include in the view frame, beginning with the <code>StartColumnIndex</code>
         *        value and ignoring any columns in the <code>HiddenColumns</code> list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnRange(Integer columnRange);

        /**
         * <p>
         * A list of columns to hide in the view frame.
         * </p>
         * 
         * @param hiddenColumns
         *        A list of columns to hide in the view frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenColumns(Collection<String> hiddenColumns);

        /**
         * <p>
         * A list of columns to hide in the view frame.
         * </p>
         * 
         * @param hiddenColumns
         *        A list of columns to hide in the view frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenColumns(String... hiddenColumns);
    }

    static final class BuilderImpl implements Builder {
        private Integer startColumnIndex;

        private Integer columnRange;

        private List<String> hiddenColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ViewFrame model) {
            startColumnIndex(model.startColumnIndex);
            columnRange(model.columnRange);
            hiddenColumns(model.hiddenColumns);
        }

        public final Integer getStartColumnIndex() {
            return startColumnIndex;
        }

        @Override
        public final Builder startColumnIndex(Integer startColumnIndex) {
            this.startColumnIndex = startColumnIndex;
            return this;
        }

        public final void setStartColumnIndex(Integer startColumnIndex) {
            this.startColumnIndex = startColumnIndex;
        }

        public final Integer getColumnRange() {
            return columnRange;
        }

        @Override
        public final Builder columnRange(Integer columnRange) {
            this.columnRange = columnRange;
            return this;
        }

        public final void setColumnRange(Integer columnRange) {
            this.columnRange = columnRange;
        }

        public final Collection<String> getHiddenColumns() {
            if (hiddenColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return hiddenColumns;
        }

        @Override
        public final Builder hiddenColumns(Collection<String> hiddenColumns) {
            this.hiddenColumns = HiddenColumnListCopier.copy(hiddenColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenColumns(String... hiddenColumns) {
            hiddenColumns(Arrays.asList(hiddenColumns));
            return this;
        }

        public final void setHiddenColumns(Collection<String> hiddenColumns) {
            this.hiddenColumns = HiddenColumnListCopier.copy(hiddenColumns);
        }

        @Override
        public ViewFrame build() {
            return new ViewFrame(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
