/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.databrew.model.EncryptionMode;
import software.amazon.awssdk.services.databrew.model.JobSample;
import software.amazon.awssdk.services.databrew.model.JobType;
import software.amazon.awssdk.services.databrew.model.LogSubscription;
import software.amazon.awssdk.services.databrew.model.Output;
import software.amazon.awssdk.services.databrew.model.OutputListCopier;
import software.amazon.awssdk.services.databrew.model.RecipeReference;
import software.amazon.awssdk.services.databrew.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Job
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Job> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(Job.getter(Job::accountId)).setter(Job.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(Job.getter(Job::createdBy)).setter(Job.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(Job.getter(Job::createDate)).setter(Job.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetName").getter(Job.getter(Job::datasetName)).setter(Job.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyArn").getter(Job.getter(Job::encryptionKeyArn)).setter(Job.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()}).build();
    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionMode").getter(Job.getter(Job::encryptionModeAsString)).setter(Job.setter(Builder::encryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionMode").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Job.getter(Job::name)).setter(Job.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Job.getter(Job::typeAsString)).setter(Job.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedBy").getter(Job.getter(Job::lastModifiedBy)).setter(Job.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(Job.getter(Job::lastModifiedDate)).setter(Job.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> LOG_SUBSCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogSubscription").getter(Job.getter(Job::logSubscriptionAsString)).setter(Job.setter(Builder::logSubscription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogSubscription").build()}).build();
    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxCapacity").getter(Job.getter(Job::maxCapacity)).setter(Job.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<Integer> MAX_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRetries").getter(Job.getter(Job::maxRetries)).setter(Job.setter(Builder::maxRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetries").build()}).build();
    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Outputs").getter(Job.getter(Job::outputs)).setter(Job.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Output::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectName").getter(Job.getter(Job::projectName)).setter(Job.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()}).build();
    private static final SdkField<RecipeReference> RECIPE_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecipeReference").getter(Job.getter(Job::recipeReference)).setter(Job.setter(Builder::recipeReference)).constructor(RecipeReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeReference").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(Job.getter(Job::resourceArn)).setter(Job.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(Job.getter(Job::roleArn)).setter(Job.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(Job.getter(Job::timeout)).setter(Job.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Job.getter(Job::tags)).setter(Job.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<JobSample> JOB_SAMPLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobSample").getter(Job.getter(Job::jobSample)).setter(Job.setter(Builder::jobSample)).constructor(JobSample::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobSample").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, CREATED_BY_FIELD, CREATE_DATE_FIELD, DATASET_NAME_FIELD, ENCRYPTION_KEY_ARN_FIELD, ENCRYPTION_MODE_FIELD, NAME_FIELD, TYPE_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_DATE_FIELD, LOG_SUBSCRIPTION_FIELD, MAX_CAPACITY_FIELD, MAX_RETRIES_FIELD, OUTPUTS_FIELD, PROJECT_NAME_FIELD, RECIPE_REFERENCE_FIELD, RESOURCE_ARN_FIELD, ROLE_ARN_FIELD, TIMEOUT_FIELD, TAGS_FIELD, JOB_SAMPLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String createdBy;
    private final Instant createDate;
    private final String datasetName;
    private final String encryptionKeyArn;
    private final String encryptionMode;
    private final String name;
    private final String type;
    private final String lastModifiedBy;
    private final Instant lastModifiedDate;
    private final String logSubscription;
    private final Integer maxCapacity;
    private final Integer maxRetries;
    private final List<Output> outputs;
    private final String projectName;
    private final RecipeReference recipeReference;
    private final String resourceArn;
    private final String roleArn;
    private final Integer timeout;
    private final Map<String, String> tags;
    private final JobSample jobSample;

    private Job(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.createdBy = builder.createdBy;
        this.createDate = builder.createDate;
        this.datasetName = builder.datasetName;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.encryptionMode = builder.encryptionMode;
        this.name = builder.name;
        this.type = builder.type;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.logSubscription = builder.logSubscription;
        this.maxCapacity = builder.maxCapacity;
        this.maxRetries = builder.maxRetries;
        this.outputs = builder.outputs;
        this.projectName = builder.projectName;
        this.recipeReference = builder.recipeReference;
        this.resourceArn = builder.resourceArn;
        this.roleArn = builder.roleArn;
        this.timeout = builder.timeout;
        this.tags = builder.tags;
        this.jobSample = builder.jobSample;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public final EncryptionMode encryptionMode() {
        return EncryptionMode.fromValue(this.encryptionMode);
    }

    public final String encryptionModeAsString() {
        return this.encryptionMode;
    }

    public final String name() {
        return this.name;
    }

    public final JobType type() {
        return JobType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final LogSubscription logSubscription() {
        return LogSubscription.fromValue(this.logSubscription);
    }

    public final String logSubscriptionAsString() {
        return this.logSubscription;
    }

    public final Integer maxCapacity() {
        return this.maxCapacity;
    }

    public final Integer maxRetries() {
        return this.maxRetries;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<Output> outputs() {
        return this.outputs;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final RecipeReference recipeReference() {
        return this.recipeReference;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final JobSample jobSample() {
        return this.jobSample;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.logSubscriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jobSample());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(this.encryptionModeAsString(), other.encryptionModeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.logSubscriptionAsString(), other.logSubscriptionAsString()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.maxRetries(), other.maxRetries()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.recipeReference(), other.recipeReference()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.timeout(), other.timeout()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.jobSample(), other.jobSample());
    }

    public final String toString() {
        return ToString.builder((String)"Job").add("AccountId", (Object)this.accountId()).add("CreatedBy", (Object)this.createdBy()).add("CreateDate", (Object)this.createDate()).add("DatasetName", (Object)this.datasetName()).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("EncryptionMode", (Object)this.encryptionModeAsString()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("LogSubscription", (Object)this.logSubscriptionAsString()).add("MaxCapacity", (Object)this.maxCapacity()).add("MaxRetries", (Object)this.maxRetries()).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("ProjectName", (Object)this.projectName()).add("RecipeReference", (Object)this.recipeReference()).add("ResourceArn", (Object)this.resourceArn()).add("RoleArn", (Object)this.roleArn()).add("Timeout", (Object)this.timeout()).add("Tags", this.hasTags() ? this.tags() : null).add("JobSample", (Object)this.jobSample()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "EncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "EncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.encryptionModeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "LogSubscription": {
                return Optional.ofNullable(clazz.cast(this.logSubscriptionAsString()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "MaxRetries": {
                return Optional.ofNullable(clazz.cast(this.maxRetries()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "ProjectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "RecipeReference": {
                return Optional.ofNullable(clazz.cast(this.recipeReference()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "JobSample": {
                return Optional.ofNullable(clazz.cast(this.jobSample()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Job, T> g) {
        return obj -> g.apply((Job)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String createdBy;
        private Instant createDate;
        private String datasetName;
        private String encryptionKeyArn;
        private String encryptionMode;
        private String name;
        private String type;
        private String lastModifiedBy;
        private Instant lastModifiedDate;
        private String logSubscription;
        private Integer maxCapacity;
        private Integer maxRetries;
        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();
        private String projectName;
        private RecipeReference recipeReference;
        private String resourceArn;
        private String roleArn;
        private Integer timeout;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private JobSample jobSample;

        private BuilderImpl() {
        }

        private BuilderImpl(Job model) {
            this.accountId(model.accountId);
            this.createdBy(model.createdBy);
            this.createDate(model.createDate);
            this.datasetName(model.datasetName);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.encryptionMode(model.encryptionMode);
            this.name(model.name);
            this.type(model.type);
            this.lastModifiedBy(model.lastModifiedBy);
            this.lastModifiedDate(model.lastModifiedDate);
            this.logSubscription(model.logSubscription);
            this.maxCapacity(model.maxCapacity);
            this.maxRetries(model.maxRetries);
            this.outputs(model.outputs);
            this.projectName(model.projectName);
            this.recipeReference(model.recipeReference);
            this.resourceArn(model.resourceArn);
            this.roleArn(model.roleArn);
            this.timeout(model.timeout);
            this.tags(model.tags);
            this.jobSample(model.jobSample);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        public final String getEncryptionMode() {
            return this.encryptionMode;
        }

        @Override
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        @Override
        public final Builder encryptionMode(EncryptionMode encryptionMode) {
            this.encryptionMode(encryptionMode == null ? null : encryptionMode.toString());
            return this;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(JobType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getLogSubscription() {
            return this.logSubscription;
        }

        @Override
        public final Builder logSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
            return this;
        }

        @Override
        public final Builder logSubscription(LogSubscription logSubscription) {
            this.logSubscription(logSubscription == null ? null : logSubscription.toString());
            return this;
        }

        public final void setLogSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
        }

        public final Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public final Integer getMaxRetries() {
            return this.maxRetries;
        }

        @Override
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        public final List<Output.Builder> getOutputs() {
            List<Output.Builder> result = OutputListCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputListCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (Output)((Output.Builder)Output.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = OutputListCopier.copyFromBuilder(outputs);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final RecipeReference.Builder getRecipeReference() {
            return this.recipeReference != null ? this.recipeReference.toBuilder() : null;
        }

        @Override
        public final Builder recipeReference(RecipeReference recipeReference) {
            this.recipeReference = recipeReference;
            return this;
        }

        public final void setRecipeReference(RecipeReference.BuilderImpl recipeReference) {
            this.recipeReference = recipeReference != null ? recipeReference.build() : null;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final JobSample.Builder getJobSample() {
            return this.jobSample != null ? this.jobSample.toBuilder() : null;
        }

        @Override
        public final Builder jobSample(JobSample jobSample) {
            this.jobSample = jobSample;
            return this;
        }

        public final void setJobSample(JobSample.BuilderImpl jobSample) {
            this.jobSample = jobSample != null ? jobSample.build() : null;
        }

        public Job build() {
            return new Job(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Job> {
        public Builder accountId(String var1);

        public Builder createdBy(String var1);

        public Builder createDate(Instant var1);

        public Builder datasetName(String var1);

        public Builder encryptionKeyArn(String var1);

        public Builder encryptionMode(String var1);

        public Builder encryptionMode(EncryptionMode var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(JobType var1);

        public Builder lastModifiedBy(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder logSubscription(String var1);

        public Builder logSubscription(LogSubscription var1);

        public Builder maxCapacity(Integer var1);

        public Builder maxRetries(Integer var1);

        public Builder outputs(Collection<Output> var1);

        public Builder outputs(Output ... var1);

        public Builder outputs(Consumer<Output.Builder> ... var1);

        public Builder projectName(String var1);

        public Builder recipeReference(RecipeReference var1);

        default public Builder recipeReference(Consumer<RecipeReference.Builder> recipeReference) {
            return this.recipeReference((RecipeReference)((RecipeReference.Builder)RecipeReference.builder().applyMutation(recipeReference)).build());
        }

        public Builder resourceArn(String var1);

        public Builder roleArn(String var1);

        public Builder timeout(Integer var1);

        public Builder tags(Map<String, String> var1);

        public Builder jobSample(JobSample var1);

        default public Builder jobSample(Consumer<JobSample.Builder> jobSample) {
            return this.jobSample((JobSample)((JobSample.Builder)JobSample.builder().applyMutation(jobSample)).build());
        }
    }
}

