/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProfileJobRequest extends DataBrewRequest implements
        ToCopyableBuilder<CreateProfileJobRequest.Builder, CreateProfileJobRequest> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(CreateProfileJobRequest::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyArn").getter(getter(CreateProfileJobRequest::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()).build();

    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionMode").getter(getter(CreateProfileJobRequest::encryptionModeAsString))
            .setter(setter(Builder::encryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionMode").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateProfileJobRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> LOG_SUBSCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogSubscription").getter(getter(CreateProfileJobRequest::logSubscriptionAsString))
            .setter(setter(Builder::logSubscription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogSubscription").build()).build();

    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxCapacity").getter(getter(CreateProfileJobRequest::maxCapacity)).setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final SdkField<Integer> MAX_RETRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRetries").getter(getter(CreateProfileJobRequest::maxRetries)).setter(setter(Builder::maxRetries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetries").build()).build();

    private static final SdkField<S3Location> OUTPUT_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("OutputLocation").getter(getter(CreateProfileJobRequest::outputLocation))
            .setter(setter(Builder::outputLocation)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateProfileJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateProfileJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(CreateProfileJobRequest::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<JobSample> JOB_SAMPLE_FIELD = SdkField.<JobSample> builder(MarshallingType.SDK_POJO)
            .memberName("JobSample").getter(getter(CreateProfileJobRequest::jobSample)).setter(setter(Builder::jobSample))
            .constructor(JobSample::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobSample").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD,
            ENCRYPTION_KEY_ARN_FIELD, ENCRYPTION_MODE_FIELD, NAME_FIELD, LOG_SUBSCRIPTION_FIELD, MAX_CAPACITY_FIELD,
            MAX_RETRIES_FIELD, OUTPUT_LOCATION_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, TIMEOUT_FIELD, JOB_SAMPLE_FIELD));

    private final String datasetName;

    private final String encryptionKeyArn;

    private final String encryptionMode;

    private final String name;

    private final String logSubscription;

    private final Integer maxCapacity;

    private final Integer maxRetries;

    private final S3Location outputLocation;

    private final String roleArn;

    private final Map<String, String> tags;

    private final Integer timeout;

    private final JobSample jobSample;

    private CreateProfileJobRequest(BuilderImpl builder) {
        super(builder);
        this.datasetName = builder.datasetName;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.encryptionMode = builder.encryptionMode;
        this.name = builder.name;
        this.logSubscription = builder.logSubscription;
        this.maxCapacity = builder.maxCapacity;
        this.maxRetries = builder.maxRetries;
        this.outputLocation = builder.outputLocation;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.timeout = builder.timeout;
        this.jobSample = builder.jobSample;
    }

    /**
     * <p>
     * The name of the dataset that this job is to act upon.
     * </p>
     * 
     * @return The name of the dataset that this job is to act upon.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    /**
     * <p>
     * The encryption mode for the job, which can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SSE-KMS</code> - <code>SSE-KMS</code> - Server-side encryption with KMS-managed keys.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMode}
     * will return {@link EncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionModeAsString}.
     * </p>
     * 
     * @return The encryption mode for the job, which can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SSE-KMS</code> - <code>SSE-KMS</code> - Server-side encryption with KMS-managed keys.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
     *         </p>
     *         </li>
     * @see EncryptionMode
     */
    public final EncryptionMode encryptionMode() {
        return EncryptionMode.fromValue(encryptionMode);
    }

    /**
     * <p>
     * The encryption mode for the job, which can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SSE-KMS</code> - <code>SSE-KMS</code> - Server-side encryption with KMS-managed keys.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMode}
     * will return {@link EncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionModeAsString}.
     * </p>
     * 
     * @return The encryption mode for the job, which can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SSE-KMS</code> - <code>SSE-KMS</code> - Server-side encryption with KMS-managed keys.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
     *         </p>
     *         </li>
     * @see EncryptionMode
     */
    public final String encryptionModeAsString() {
        return encryptionMode;
    }

    /**
     * <p>
     * The name of the job to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and
     * space.
     * </p>
     * 
     * @return The name of the job to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period
     *         (.), and space.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log
     * stream for each job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logSubscription}
     * will return {@link LogSubscription#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logSubscriptionAsString}.
     * </p>
     * 
     * @return Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one
     *         log stream for each job run.
     * @see LogSubscription
     */
    public final LogSubscription logSubscription() {
        return LogSubscription.fromValue(logSubscription);
    }

    /**
     * <p>
     * Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log
     * stream for each job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logSubscription}
     * will return {@link LogSubscription#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logSubscriptionAsString}.
     * </p>
     * 
     * @return Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one
     *         log stream for each job run.
     * @see LogSubscription
     */
    public final String logSubscriptionAsString() {
        return logSubscription;
    }

    /**
     * <p>
     * The maximum number of nodes that DataBrew can use when the job processes data.
     * </p>
     * 
     * @return The maximum number of nodes that DataBrew can use when the job processes data.
     */
    public final Integer maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * The maximum number of times to retry the job after a job run fails.
     * </p>
     * 
     * @return The maximum number of times to retry the job after a job run fails.
     */
    public final Integer maxRetries() {
        return maxRetries;
    }

    /**
     * Returns the value of the OutputLocation property for this object.
     * 
     * @return The value of the OutputLocation property for this object.
     */
    public final S3Location outputLocation() {
        return outputLocation;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew runs
     * the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when
     *         DataBrew runs the job.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata tags to apply to this job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata tags to apply to this job.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of
     * <code>TIMEOUT</code>.
     * </p>
     * 
     * @return The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a
     *         status of <code>TIMEOUT</code>.
     */
    public final Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * Sample configuration for profile jobs only. Determines the number of rows on which the profile job will be
     * executed. If a JobSample value is not provided, the default value will be used. The default value is CUSTOM_ROWS
     * for the mode parameter and 20000 for the size parameter.
     * </p>
     * 
     * @return Sample configuration for profile jobs only. Determines the number of rows on which the profile job will
     *         be executed. If a JobSample value is not provided, the default value will be used. The default value is
     *         CUSTOM_ROWS for the mode parameter and 20000 for the size parameter.
     */
    public final JobSample jobSample() {
        return jobSample;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(logSubscriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(jobSample());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProfileJobRequest)) {
            return false;
        }
        CreateProfileJobRequest other = (CreateProfileJobRequest) obj;
        return Objects.equals(datasetName(), other.datasetName()) && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn())
                && Objects.equals(encryptionModeAsString(), other.encryptionModeAsString())
                && Objects.equals(name(), other.name())
                && Objects.equals(logSubscriptionAsString(), other.logSubscriptionAsString())
                && Objects.equals(maxCapacity(), other.maxCapacity()) && Objects.equals(maxRetries(), other.maxRetries())
                && Objects.equals(outputLocation(), other.outputLocation()) && Objects.equals(roleArn(), other.roleArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(timeout(), other.timeout()) && Objects.equals(jobSample(), other.jobSample());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProfileJobRequest").add("DatasetName", datasetName())
                .add("EncryptionKeyArn", encryptionKeyArn()).add("EncryptionMode", encryptionModeAsString()).add("Name", name())
                .add("LogSubscription", logSubscriptionAsString()).add("MaxCapacity", maxCapacity())
                .add("MaxRetries", maxRetries()).add("OutputLocation", outputLocation()).add("RoleArn", roleArn())
                .add("Tags", hasTags() ? tags() : null).add("Timeout", timeout()).add("JobSample", jobSample()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "EncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        case "EncryptionMode":
            return Optional.ofNullable(clazz.cast(encryptionModeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "LogSubscription":
            return Optional.ofNullable(clazz.cast(logSubscriptionAsString()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "MaxRetries":
            return Optional.ofNullable(clazz.cast(maxRetries()));
        case "OutputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "JobSample":
            return Optional.ofNullable(clazz.cast(jobSample()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProfileJobRequest, T> g) {
        return obj -> g.apply((CreateProfileJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataBrewRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProfileJobRequest> {
        /**
         * <p>
         * The name of the dataset that this job is to act upon.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset that this job is to act upon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        /**
         * <p>
         * The encryption mode for the job, which can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SSE-KMS</code> - <code>SSE-KMS</code> - Server-side encryption with KMS-managed keys.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionMode
         *        The encryption mode for the job, which can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SSE-KMS</code> - <code>SSE-KMS</code> - Server-side encryption with KMS-managed keys.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
         *        </p>
         *        </li>
         * @see EncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionMode
         */
        Builder encryptionMode(String encryptionMode);

        /**
         * <p>
         * The encryption mode for the job, which can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SSE-KMS</code> - <code>SSE-KMS</code> - Server-side encryption with KMS-managed keys.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionMode
         *        The encryption mode for the job, which can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SSE-KMS</code> - <code>SSE-KMS</code> - Server-side encryption with KMS-managed keys.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
         *        </p>
         *        </li>
         * @see EncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionMode
         */
        Builder encryptionMode(EncryptionMode encryptionMode);

        /**
         * <p>
         * The name of the job to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.),
         * and space.
         * </p>
         * 
         * @param name
         *        The name of the job to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-),
         *        period (.), and space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log
         * stream for each job run.
         * </p>
         * 
         * @param logSubscription
         *        Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes
         *        one log stream for each job run.
         * @see LogSubscription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogSubscription
         */
        Builder logSubscription(String logSubscription);

        /**
         * <p>
         * Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log
         * stream for each job run.
         * </p>
         * 
         * @param logSubscription
         *        Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes
         *        one log stream for each job run.
         * @see LogSubscription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogSubscription
         */
        Builder logSubscription(LogSubscription logSubscription);

        /**
         * <p>
         * The maximum number of nodes that DataBrew can use when the job processes data.
         * </p>
         * 
         * @param maxCapacity
         *        The maximum number of nodes that DataBrew can use when the job processes data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Integer maxCapacity);

        /**
         * <p>
         * The maximum number of times to retry the job after a job run fails.
         * </p>
         * 
         * @param maxRetries
         *        The maximum number of times to retry the job after a job run fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRetries(Integer maxRetries);

        /**
         * Sets the value of the OutputLocation property for this object.
         *
         * @param outputLocation
         *        The new value for the OutputLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(S3Location outputLocation);

        /**
         * Sets the value of the OutputLocation property for this object.
         *
         * This is a convenience that creates an instance of the {@link S3Location.Builder} avoiding the need to create
         * one manually via {@link S3Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #outputLocation(S3Location)}.
         * 
         * @param outputLocation
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputLocation(S3Location)
         */
        default Builder outputLocation(Consumer<S3Location.Builder> outputLocation) {
            return outputLocation(S3Location.builder().applyMutation(outputLocation).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew
         * runs the job.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when
         *        DataBrew runs the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Metadata tags to apply to this job.
         * </p>
         * 
         * @param tags
         *        Metadata tags to apply to this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status
         * of <code>TIMEOUT</code>.
         * </p>
         * 
         * @param timeout
         *        The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a
         *        status of <code>TIMEOUT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * Sample configuration for profile jobs only. Determines the number of rows on which the profile job will be
         * executed. If a JobSample value is not provided, the default value will be used. The default value is
         * CUSTOM_ROWS for the mode parameter and 20000 for the size parameter.
         * </p>
         * 
         * @param jobSample
         *        Sample configuration for profile jobs only. Determines the number of rows on which the profile job
         *        will be executed. If a JobSample value is not provided, the default value will be used. The default
         *        value is CUSTOM_ROWS for the mode parameter and 20000 for the size parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobSample(JobSample jobSample);

        /**
         * <p>
         * Sample configuration for profile jobs only. Determines the number of rows on which the profile job will be
         * executed. If a JobSample value is not provided, the default value will be used. The default value is
         * CUSTOM_ROWS for the mode parameter and 20000 for the size parameter.
         * </p>
         * This is a convenience that creates an instance of the {@link JobSample.Builder} avoiding the need to create
         * one manually via {@link JobSample#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobSample.Builder#build()} is called immediately and its result
         * is passed to {@link #jobSample(JobSample)}.
         * 
         * @param jobSample
         *        a consumer that will call methods on {@link JobSample.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobSample(JobSample)
         */
        default Builder jobSample(Consumer<JobSample.Builder> jobSample) {
            return jobSample(JobSample.builder().applyMutation(jobSample).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataBrewRequest.BuilderImpl implements Builder {
        private String datasetName;

        private String encryptionKeyArn;

        private String encryptionMode;

        private String name;

        private String logSubscription;

        private Integer maxCapacity;

        private Integer maxRetries;

        private S3Location outputLocation;

        private String roleArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Integer timeout;

        private JobSample jobSample;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProfileJobRequest model) {
            super(model);
            datasetName(model.datasetName);
            encryptionKeyArn(model.encryptionKeyArn);
            encryptionMode(model.encryptionMode);
            name(model.name);
            logSubscription(model.logSubscription);
            maxCapacity(model.maxCapacity);
            maxRetries(model.maxRetries);
            outputLocation(model.outputLocation);
            roleArn(model.roleArn);
            tags(model.tags);
            timeout(model.timeout);
            jobSample(model.jobSample);
        }

        public final String getDatasetName() {
            return datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        public final String getEncryptionMode() {
            return encryptionMode;
        }

        @Override
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        @Override
        public final Builder encryptionMode(EncryptionMode encryptionMode) {
            this.encryptionMode(encryptionMode == null ? null : encryptionMode.toString());
            return this;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLogSubscription() {
            return logSubscription;
        }

        @Override
        public final Builder logSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
            return this;
        }

        @Override
        public final Builder logSubscription(LogSubscription logSubscription) {
            this.logSubscription(logSubscription == null ? null : logSubscription.toString());
            return this;
        }

        public final void setLogSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
        }

        public final Integer getMaxCapacity() {
            return maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public final Integer getMaxRetries() {
            return maxRetries;
        }

        @Override
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        public final S3Location.Builder getOutputLocation() {
            return outputLocation != null ? outputLocation.toBuilder() : null;
        }

        @Override
        public final Builder outputLocation(S3Location outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(S3Location.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final Integer getTimeout() {
            return timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final JobSample.Builder getJobSample() {
            return jobSample != null ? jobSample.toBuilder() : null;
        }

        @Override
        public final Builder jobSample(JobSample jobSample) {
            this.jobSample = jobSample;
            return this;
        }

        public final void setJobSample(JobSample.BuilderImpl jobSample) {
            this.jobSample = jobSample != null ? jobSample.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProfileJobRequest build() {
            return new CreateProfileJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
