/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScheduleResponse extends DataBrewResponse implements
        ToCopyableBuilder<DescribeScheduleResponse.Builder, DescribeScheduleResponse> {
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(DescribeScheduleResponse::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(DescribeScheduleResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<List<String>> JOB_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("JobNames")
            .getter(getter(DescribeScheduleResponse::jobNames))
            .setter(setter(Builder::jobNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedBy").getter(getter(DescribeScheduleResponse::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate").getter(getter(DescribeScheduleResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(DescribeScheduleResponse::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> CRON_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CronExpression").getter(getter(DescribeScheduleResponse::cronExpression))
            .setter(setter(Builder::cronExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CronExpression").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DescribeScheduleResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeScheduleResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_DATE_FIELD,
            CREATED_BY_FIELD, JOB_NAMES_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_DATE_FIELD, RESOURCE_ARN_FIELD,
            CRON_EXPRESSION_FIELD, TAGS_FIELD, NAME_FIELD));

    private final Instant createDate;

    private final String createdBy;

    private final List<String> jobNames;

    private final String lastModifiedBy;

    private final Instant lastModifiedDate;

    private final String resourceArn;

    private final String cronExpression;

    private final Map<String, String> tags;

    private final String name;

    private DescribeScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.createDate = builder.createDate;
        this.createdBy = builder.createdBy;
        this.jobNames = builder.jobNames;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.resourceArn = builder.resourceArn;
        this.cronExpression = builder.cronExpression;
        this.tags = builder.tags;
        this.name = builder.name;
    }

    /**
     * <p>
     * The date and time that the schedule was created.
     * </p>
     * 
     * @return The date and time that the schedule was created.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The identifier (user name) of the user who created the schedule.
     * </p>
     * 
     * @return The identifier (user name) of the user who created the schedule.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * Returns true if the JobNames property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasJobNames() {
        return jobNames != null && !(jobNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name or names of one or more jobs to be run by using the schedule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasJobNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name or names of one or more jobs to be run by using the schedule.
     */
    public final List<String> jobNames() {
        return jobNames;
    }

    /**
     * <p>
     * The identifier (user name) of the user who last modified the schedule.
     * </p>
     * 
     * @return The identifier (user name) of the user who last modified the schedule.
     */
    public final String lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * The date and time that the schedule was last modified.
     * </p>
     * 
     * @return The date and time that the schedule was last modified.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the schedule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the schedule.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The date or dates and time or times when the jobs are to be run for the schedule. For more information, see <a
     * href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the <i>Glue DataBrew
     * Developer Guide</i>.
     * </p>
     * 
     * @return The date or dates and time or times when the jobs are to be run for the schedule. For more information,
     *         see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the
     *         <i>Glue DataBrew Developer Guide</i>.
     */
    public final String cronExpression() {
        return cronExpression;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata tags associated with this schedule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata tags associated with this schedule.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The name of the schedule.
     * </p>
     * 
     * @return The name of the schedule.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasJobNames() ? jobNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(cronExpression());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduleResponse)) {
            return false;
        }
        DescribeScheduleResponse other = (DescribeScheduleResponse) obj;
        return Objects.equals(createDate(), other.createDate()) && Objects.equals(createdBy(), other.createdBy())
                && hasJobNames() == other.hasJobNames() && Objects.equals(jobNames(), other.jobNames())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(cronExpression(), other.cronExpression())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeScheduleResponse").add("CreateDate", createDate()).add("CreatedBy", createdBy())
                .add("JobNames", hasJobNames() ? jobNames() : null).add("LastModifiedBy", lastModifiedBy())
                .add("LastModifiedDate", lastModifiedDate()).add("ResourceArn", resourceArn())
                .add("CronExpression", cronExpression()).add("Tags", hasTags() ? tags() : null).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "JobNames":
            return Optional.ofNullable(clazz.cast(jobNames()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "CronExpression":
            return Optional.ofNullable(clazz.cast(cronExpression()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduleResponse, T> g) {
        return obj -> g.apply((DescribeScheduleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataBrewResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeScheduleResponse> {
        /**
         * <p>
         * The date and time that the schedule was created.
         * </p>
         * 
         * @param createDate
         *        The date and time that the schedule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The identifier (user name) of the user who created the schedule.
         * </p>
         * 
         * @param createdBy
         *        The identifier (user name) of the user who created the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The name or names of one or more jobs to be run by using the schedule.
         * </p>
         * 
         * @param jobNames
         *        The name or names of one or more jobs to be run by using the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobNames(Collection<String> jobNames);

        /**
         * <p>
         * The name or names of one or more jobs to be run by using the schedule.
         * </p>
         * 
         * @param jobNames
         *        The name or names of one or more jobs to be run by using the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobNames(String... jobNames);

        /**
         * <p>
         * The identifier (user name) of the user who last modified the schedule.
         * </p>
         * 
         * @param lastModifiedBy
         *        The identifier (user name) of the user who last modified the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(String lastModifiedBy);

        /**
         * <p>
         * The date and time that the schedule was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time that the schedule was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the schedule.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The date or dates and time or times when the jobs are to be run for the schedule. For more information, see
         * <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the <i>Glue
         * DataBrew Developer Guide</i>.
         * </p>
         * 
         * @param cronExpression
         *        The date or dates and time or times when the jobs are to be run for the schedule. For more
         *        information, see <a href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron
         *        expressions</a> in the <i>Glue DataBrew Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cronExpression(String cronExpression);

        /**
         * <p>
         * Metadata tags associated with this schedule.
         * </p>
         * 
         * @param tags
         *        Metadata tags associated with this schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The name of the schedule.
         * </p>
         * 
         * @param name
         *        The name of the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl extends DataBrewResponse.BuilderImpl implements Builder {
        private Instant createDate;

        private String createdBy;

        private List<String> jobNames = DefaultSdkAutoConstructList.getInstance();

        private String lastModifiedBy;

        private Instant lastModifiedDate;

        private String resourceArn;

        private String cronExpression;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduleResponse model) {
            super(model);
            createDate(model.createDate);
            createdBy(model.createdBy);
            jobNames(model.jobNames);
            lastModifiedBy(model.lastModifiedBy);
            lastModifiedDate(model.lastModifiedDate);
            resourceArn(model.resourceArn);
            cronExpression(model.cronExpression);
            tags(model.tags);
            name(model.name);
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final Collection<String> getJobNames() {
            if (jobNames instanceof SdkAutoConstructList) {
                return null;
            }
            return jobNames;
        }

        @Override
        public final Builder jobNames(Collection<String> jobNames) {
            this.jobNames = JobNameListCopier.copy(jobNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobNames(String... jobNames) {
            jobNames(Arrays.asList(jobNames));
            return this;
        }

        public final void setJobNames(Collection<String> jobNames) {
            this.jobNames = JobNameListCopier.copy(jobNames);
        }

        public final String getLastModifiedBy() {
            return lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getCronExpression() {
            return cronExpression;
        }

        @Override
        public final Builder cronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        public final void setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public DescribeScheduleResponse build() {
            return new DescribeScheduleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
