/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a set of options that define the structure of comma-separated (CSV) job output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputFormatOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputFormatOptions.Builder, OutputFormatOptions> {
    private static final SdkField<CsvOutputOptions> CSV_FIELD = SdkField.<CsvOutputOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Csv").getter(getter(OutputFormatOptions::csv)).setter(setter(Builder::csv))
            .constructor(CsvOutputOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Csv").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CSV_FIELD));

    private static final long serialVersionUID = 1L;

    private final CsvOutputOptions csv;

    private OutputFormatOptions(BuilderImpl builder) {
        this.csv = builder.csv;
    }

    /**
     * <p>
     * Represents a set of options that define the structure of comma-separated value (CSV) job output.
     * </p>
     * 
     * @return Represents a set of options that define the structure of comma-separated value (CSV) job output.
     */
    public final CsvOutputOptions csv() {
        return csv;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(csv());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputFormatOptions)) {
            return false;
        }
        OutputFormatOptions other = (OutputFormatOptions) obj;
        return Objects.equals(csv(), other.csv());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputFormatOptions").add("Csv", csv()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Csv":
            return Optional.ofNullable(clazz.cast(csv()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputFormatOptions, T> g) {
        return obj -> g.apply((OutputFormatOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputFormatOptions> {
        /**
         * <p>
         * Represents a set of options that define the structure of comma-separated value (CSV) job output.
         * </p>
         * 
         * @param csv
         *        Represents a set of options that define the structure of comma-separated value (CSV) job output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csv(CsvOutputOptions csv);

        /**
         * <p>
         * Represents a set of options that define the structure of comma-separated value (CSV) job output.
         * </p>
         * This is a convenience that creates an instance of the {@link CsvOutputOptions.Builder} avoiding the need to
         * create one manually via {@link CsvOutputOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link CsvOutputOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #csv(CsvOutputOptions)}.
         * 
         * @param csv
         *        a consumer that will call methods on {@link CsvOutputOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #csv(CsvOutputOptions)
         */
        default Builder csv(Consumer<CsvOutputOptions.Builder> csv) {
            return csv(CsvOutputOptions.builder().applyMutation(csv).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CsvOutputOptions csv;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputFormatOptions model) {
            csv(model.csv);
        }

        public final CsvOutputOptions.Builder getCsv() {
            return csv != null ? csv.toBuilder() : null;
        }

        @Override
        public final Builder csv(CsvOutputOptions csv) {
            this.csv = csv;
            return this;
        }

        public final void setCsv(CsvOutputOptions.BuilderImpl csv) {
            this.csv = csv != null ? csv.build() : null;
        }

        @Override
        public OutputFormatOptions build() {
            return new OutputFormatOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
