/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the name and version of a DataBrew recipe.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecipeReference implements SdkPojo, Serializable, ToCopyableBuilder<RecipeReference.Builder, RecipeReference> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RecipeReference::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RECIPE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecipeVersion").getter(getter(RecipeReference::recipeVersion)).setter(setter(Builder::recipeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            RECIPE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String recipeVersion;

    private RecipeReference(BuilderImpl builder) {
        this.name = builder.name;
        this.recipeVersion = builder.recipeVersion;
    }

    /**
     * <p>
     * The name of the recipe.
     * </p>
     * 
     * @return The name of the recipe.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier for the version for the recipe.
     * </p>
     * 
     * @return The identifier for the version for the recipe.
     */
    public final String recipeVersion() {
        return recipeVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(recipeVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecipeReference)) {
            return false;
        }
        RecipeReference other = (RecipeReference) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(recipeVersion(), other.recipeVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecipeReference").add("Name", name()).add("RecipeVersion", recipeVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RecipeVersion":
            return Optional.ofNullable(clazz.cast(recipeVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecipeReference, T> g) {
        return obj -> g.apply((RecipeReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecipeReference> {
        /**
         * <p>
         * The name of the recipe.
         * </p>
         * 
         * @param name
         *        The name of the recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier for the version for the recipe.
         * </p>
         * 
         * @param recipeVersion
         *        The identifier for the version for the recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeVersion(String recipeVersion);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String recipeVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(RecipeReference model) {
            name(model.name);
            recipeVersion(model.recipeVersion);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRecipeVersion() {
            return recipeVersion;
        }

        @Override
        public final Builder recipeVersion(String recipeVersion) {
            this.recipeVersion = recipeVersion;
            return this;
        }

        public final void setRecipeVersion(String recipeVersion) {
            this.recipeVersion = recipeVersion;
        }

        @Override
        public RecipeReference build() {
            return new RecipeReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
