/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a JDBC database output object which defines the output destination for a DataBrew recipe job to write
 * into.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatabaseOutput implements SdkPojo, Serializable, ToCopyableBuilder<DatabaseOutput.Builder, DatabaseOutput> {
    private static final SdkField<String> GLUE_CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlueConnectionName").getter(getter(DatabaseOutput::glueConnectionName))
            .setter(setter(Builder::glueConnectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueConnectionName").build())
            .build();

    private static final SdkField<DatabaseTableOutputOptions> DATABASE_OPTIONS_FIELD = SdkField
            .<DatabaseTableOutputOptions> builder(MarshallingType.SDK_POJO).memberName("DatabaseOptions")
            .getter(getter(DatabaseOutput::databaseOptions)).setter(setter(Builder::databaseOptions))
            .constructor(DatabaseTableOutputOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseOptions").build()).build();

    private static final SdkField<String> DATABASE_OUTPUT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseOutputMode").getter(getter(DatabaseOutput::databaseOutputModeAsString))
            .setter(setter(Builder::databaseOutputMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseOutputMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLUE_CONNECTION_NAME_FIELD,
            DATABASE_OPTIONS_FIELD, DATABASE_OUTPUT_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String glueConnectionName;

    private final DatabaseTableOutputOptions databaseOptions;

    private final String databaseOutputMode;

    private DatabaseOutput(BuilderImpl builder) {
        this.glueConnectionName = builder.glueConnectionName;
        this.databaseOptions = builder.databaseOptions;
        this.databaseOutputMode = builder.databaseOutputMode;
    }

    /**
     * <p>
     * The Glue connection that stores the connection information for the target database.
     * </p>
     * 
     * @return The Glue connection that stores the connection information for the target database.
     */
    public final String glueConnectionName() {
        return glueConnectionName;
    }

    /**
     * <p>
     * Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
     * </p>
     * 
     * @return Represents options that specify how and where DataBrew writes the database output generated by recipe
     *         jobs.
     */
    public final DatabaseTableOutputOptions databaseOptions() {
        return databaseOptions;
    }

    /**
     * <p>
     * The output mode to write into the database. Currently supported option: NEW_TABLE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #databaseOutputMode} will return {@link DatabaseOutputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #databaseOutputModeAsString}.
     * </p>
     * 
     * @return The output mode to write into the database. Currently supported option: NEW_TABLE.
     * @see DatabaseOutputMode
     */
    public final DatabaseOutputMode databaseOutputMode() {
        return DatabaseOutputMode.fromValue(databaseOutputMode);
    }

    /**
     * <p>
     * The output mode to write into the database. Currently supported option: NEW_TABLE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #databaseOutputMode} will return {@link DatabaseOutputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #databaseOutputModeAsString}.
     * </p>
     * 
     * @return The output mode to write into the database. Currently supported option: NEW_TABLE.
     * @see DatabaseOutputMode
     */
    public final String databaseOutputModeAsString() {
        return databaseOutputMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(glueConnectionName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseOptions());
        hashCode = 31 * hashCode + Objects.hashCode(databaseOutputModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseOutput)) {
            return false;
        }
        DatabaseOutput other = (DatabaseOutput) obj;
        return Objects.equals(glueConnectionName(), other.glueConnectionName())
                && Objects.equals(databaseOptions(), other.databaseOptions())
                && Objects.equals(databaseOutputModeAsString(), other.databaseOutputModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatabaseOutput").add("GlueConnectionName", glueConnectionName())
                .add("DatabaseOptions", databaseOptions()).add("DatabaseOutputMode", databaseOutputModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlueConnectionName":
            return Optional.ofNullable(clazz.cast(glueConnectionName()));
        case "DatabaseOptions":
            return Optional.ofNullable(clazz.cast(databaseOptions()));
        case "DatabaseOutputMode":
            return Optional.ofNullable(clazz.cast(databaseOutputModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatabaseOutput, T> g) {
        return obj -> g.apply((DatabaseOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatabaseOutput> {
        /**
         * <p>
         * The Glue connection that stores the connection information for the target database.
         * </p>
         * 
         * @param glueConnectionName
         *        The Glue connection that stores the connection information for the target database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueConnectionName(String glueConnectionName);

        /**
         * <p>
         * Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
         * </p>
         * 
         * @param databaseOptions
         *        Represents options that specify how and where DataBrew writes the database output generated by recipe
         *        jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseOptions(DatabaseTableOutputOptions databaseOptions);

        /**
         * <p>
         * Represents options that specify how and where DataBrew writes the database output generated by recipe jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link DatabaseTableOutputOptions.Builder} avoiding the
         * need to create one manually via {@link DatabaseTableOutputOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatabaseTableOutputOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #databaseOptions(DatabaseTableOutputOptions)}.
         * 
         * @param databaseOptions
         *        a consumer that will call methods on {@link DatabaseTableOutputOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #databaseOptions(DatabaseTableOutputOptions)
         */
        default Builder databaseOptions(Consumer<DatabaseTableOutputOptions.Builder> databaseOptions) {
            return databaseOptions(DatabaseTableOutputOptions.builder().applyMutation(databaseOptions).build());
        }

        /**
         * <p>
         * The output mode to write into the database. Currently supported option: NEW_TABLE.
         * </p>
         * 
         * @param databaseOutputMode
         *        The output mode to write into the database. Currently supported option: NEW_TABLE.
         * @see DatabaseOutputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseOutputMode
         */
        Builder databaseOutputMode(String databaseOutputMode);

        /**
         * <p>
         * The output mode to write into the database. Currently supported option: NEW_TABLE.
         * </p>
         * 
         * @param databaseOutputMode
         *        The output mode to write into the database. Currently supported option: NEW_TABLE.
         * @see DatabaseOutputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseOutputMode
         */
        Builder databaseOutputMode(DatabaseOutputMode databaseOutputMode);
    }

    static final class BuilderImpl implements Builder {
        private String glueConnectionName;

        private DatabaseTableOutputOptions databaseOptions;

        private String databaseOutputMode;

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseOutput model) {
            glueConnectionName(model.glueConnectionName);
            databaseOptions(model.databaseOptions);
            databaseOutputMode(model.databaseOutputMode);
        }

        public final String getGlueConnectionName() {
            return glueConnectionName;
        }

        public final void setGlueConnectionName(String glueConnectionName) {
            this.glueConnectionName = glueConnectionName;
        }

        @Override
        @Transient
        public final Builder glueConnectionName(String glueConnectionName) {
            this.glueConnectionName = glueConnectionName;
            return this;
        }

        public final DatabaseTableOutputOptions.Builder getDatabaseOptions() {
            return databaseOptions != null ? databaseOptions.toBuilder() : null;
        }

        public final void setDatabaseOptions(DatabaseTableOutputOptions.BuilderImpl databaseOptions) {
            this.databaseOptions = databaseOptions != null ? databaseOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder databaseOptions(DatabaseTableOutputOptions databaseOptions) {
            this.databaseOptions = databaseOptions;
            return this;
        }

        public final String getDatabaseOutputMode() {
            return databaseOutputMode;
        }

        public final void setDatabaseOutputMode(String databaseOutputMode) {
            this.databaseOutputMode = databaseOutputMode;
        }

        @Override
        @Transient
        public final Builder databaseOutputMode(String databaseOutputMode) {
            this.databaseOutputMode = databaseOutputMode;
            return this;
        }

        @Override
        @Transient
        public final Builder databaseOutputMode(DatabaseOutputMode databaseOutputMode) {
            this.databaseOutputMode(databaseOutputMode == null ? null : databaseOutputMode.toString());
            return this;
        }

        @Override
        public DatabaseOutput build() {
            return new DatabaseOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
