/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a set of options that define the structure of either comma-separated value (CSV), Excel, or JSON input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FormatOptions implements SdkPojo, Serializable, ToCopyableBuilder<FormatOptions.Builder, FormatOptions> {
    private static final SdkField<JsonOptions> JSON_FIELD = SdkField.<JsonOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Json").getter(getter(FormatOptions::json)).setter(setter(Builder::json))
            .constructor(JsonOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Json").build()).build();

    private static final SdkField<ExcelOptions> EXCEL_FIELD = SdkField.<ExcelOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Excel").getter(getter(FormatOptions::excel)).setter(setter(Builder::excel))
            .constructor(ExcelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Excel").build()).build();

    private static final SdkField<CsvOptions> CSV_FIELD = SdkField.<CsvOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Csv").getter(getter(FormatOptions::csv)).setter(setter(Builder::csv)).constructor(CsvOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Csv").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_FIELD, EXCEL_FIELD,
            CSV_FIELD));

    private static final long serialVersionUID = 1L;

    private final JsonOptions json;

    private final ExcelOptions excel;

    private final CsvOptions csv;

    private FormatOptions(BuilderImpl builder) {
        this.json = builder.json;
        this.excel = builder.excel;
        this.csv = builder.csv;
    }

    /**
     * <p>
     * Options that define how JSON input is to be interpreted by DataBrew.
     * </p>
     * 
     * @return Options that define how JSON input is to be interpreted by DataBrew.
     */
    public final JsonOptions json() {
        return json;
    }

    /**
     * <p>
     * Options that define how Excel input is to be interpreted by DataBrew.
     * </p>
     * 
     * @return Options that define how Excel input is to be interpreted by DataBrew.
     */
    public final ExcelOptions excel() {
        return excel;
    }

    /**
     * <p>
     * Options that define how CSV input is to be interpreted by DataBrew.
     * </p>
     * 
     * @return Options that define how CSV input is to be interpreted by DataBrew.
     */
    public final CsvOptions csv() {
        return csv;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(json());
        hashCode = 31 * hashCode + Objects.hashCode(excel());
        hashCode = 31 * hashCode + Objects.hashCode(csv());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormatOptions)) {
            return false;
        }
        FormatOptions other = (FormatOptions) obj;
        return Objects.equals(json(), other.json()) && Objects.equals(excel(), other.excel())
                && Objects.equals(csv(), other.csv());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FormatOptions").add("Json", json()).add("Excel", excel()).add("Csv", csv()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Json":
            return Optional.ofNullable(clazz.cast(json()));
        case "Excel":
            return Optional.ofNullable(clazz.cast(excel()));
        case "Csv":
            return Optional.ofNullable(clazz.cast(csv()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FormatOptions, T> g) {
        return obj -> g.apply((FormatOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FormatOptions> {
        /**
         * <p>
         * Options that define how JSON input is to be interpreted by DataBrew.
         * </p>
         * 
         * @param json
         *        Options that define how JSON input is to be interpreted by DataBrew.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder json(JsonOptions json);

        /**
         * <p>
         * Options that define how JSON input is to be interpreted by DataBrew.
         * </p>
         * This is a convenience that creates an instance of the {@link JsonOptions.Builder} avoiding the need to create
         * one manually via {@link JsonOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link JsonOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #json(JsonOptions)}.
         * 
         * @param json
         *        a consumer that will call methods on {@link JsonOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #json(JsonOptions)
         */
        default Builder json(Consumer<JsonOptions.Builder> json) {
            return json(JsonOptions.builder().applyMutation(json).build());
        }

        /**
         * <p>
         * Options that define how Excel input is to be interpreted by DataBrew.
         * </p>
         * 
         * @param excel
         *        Options that define how Excel input is to be interpreted by DataBrew.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excel(ExcelOptions excel);

        /**
         * <p>
         * Options that define how Excel input is to be interpreted by DataBrew.
         * </p>
         * This is a convenience that creates an instance of the {@link ExcelOptions.Builder} avoiding the need to
         * create one manually via {@link ExcelOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExcelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #excel(ExcelOptions)}.
         * 
         * @param excel
         *        a consumer that will call methods on {@link ExcelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excel(ExcelOptions)
         */
        default Builder excel(Consumer<ExcelOptions.Builder> excel) {
            return excel(ExcelOptions.builder().applyMutation(excel).build());
        }

        /**
         * <p>
         * Options that define how CSV input is to be interpreted by DataBrew.
         * </p>
         * 
         * @param csv
         *        Options that define how CSV input is to be interpreted by DataBrew.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csv(CsvOptions csv);

        /**
         * <p>
         * Options that define how CSV input is to be interpreted by DataBrew.
         * </p>
         * This is a convenience that creates an instance of the {@link CsvOptions.Builder} avoiding the need to create
         * one manually via {@link CsvOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link CsvOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #csv(CsvOptions)}.
         * 
         * @param csv
         *        a consumer that will call methods on {@link CsvOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #csv(CsvOptions)
         */
        default Builder csv(Consumer<CsvOptions.Builder> csv) {
            return csv(CsvOptions.builder().applyMutation(csv).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private JsonOptions json;

        private ExcelOptions excel;

        private CsvOptions csv;

        private BuilderImpl() {
        }

        private BuilderImpl(FormatOptions model) {
            json(model.json);
            excel(model.excel);
            csv(model.csv);
        }

        public final JsonOptions.Builder getJson() {
            return json != null ? json.toBuilder() : null;
        }

        public final void setJson(JsonOptions.BuilderImpl json) {
            this.json = json != null ? json.build() : null;
        }

        @Override
        @Transient
        public final Builder json(JsonOptions json) {
            this.json = json;
            return this;
        }

        public final ExcelOptions.Builder getExcel() {
            return excel != null ? excel.toBuilder() : null;
        }

        public final void setExcel(ExcelOptions.BuilderImpl excel) {
            this.excel = excel != null ? excel.build() : null;
        }

        @Override
        @Transient
        public final Builder excel(ExcelOptions excel) {
            this.excel = excel;
            return this;
        }

        public final CsvOptions.Builder getCsv() {
            return csv != null ? csv.toBuilder() : null;
        }

        public final void setCsv(CsvOptions.BuilderImpl csv) {
            this.csv = csv != null ? csv.build() : null;
        }

        @Override
        @Transient
        public final Builder csv(CsvOptions csv) {
            this.csv = csv;
            return this;
        }

        @Override
        public FormatOptions build() {
            return new FormatOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
