/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information on how DataBrew can find data, in either the Glue Data Catalog or Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Input implements SdkPojo, Serializable, ToCopyableBuilder<Input.Builder, Input> {
    private static final SdkField<S3Location> S3_INPUT_DEFINITION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("S3InputDefinition").getter(getter(Input::s3InputDefinition)).setter(setter(Builder::s3InputDefinition))
            .constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3InputDefinition").build()).build();

    private static final SdkField<DataCatalogInputDefinition> DATA_CATALOG_INPUT_DEFINITION_FIELD = SdkField
            .<DataCatalogInputDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("DataCatalogInputDefinition")
            .getter(getter(Input::dataCatalogInputDefinition))
            .setter(setter(Builder::dataCatalogInputDefinition))
            .constructor(DataCatalogInputDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCatalogInputDefinition").build())
            .build();

    private static final SdkField<DatabaseInputDefinition> DATABASE_INPUT_DEFINITION_FIELD = SdkField
            .<DatabaseInputDefinition> builder(MarshallingType.SDK_POJO).memberName("DatabaseInputDefinition")
            .getter(getter(Input::databaseInputDefinition)).setter(setter(Builder::databaseInputDefinition))
            .constructor(DatabaseInputDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInputDefinition").build())
            .build();

    private static final SdkField<Metadata> METADATA_FIELD = SdkField.<Metadata> builder(MarshallingType.SDK_POJO)
            .memberName("Metadata").getter(getter(Input::metadata)).setter(setter(Builder::metadata))
            .constructor(Metadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_INPUT_DEFINITION_FIELD,
            DATA_CATALOG_INPUT_DEFINITION_FIELD, DATABASE_INPUT_DEFINITION_FIELD, METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3Location s3InputDefinition;

    private final DataCatalogInputDefinition dataCatalogInputDefinition;

    private final DatabaseInputDefinition databaseInputDefinition;

    private final Metadata metadata;

    private Input(BuilderImpl builder) {
        this.s3InputDefinition = builder.s3InputDefinition;
        this.dataCatalogInputDefinition = builder.dataCatalogInputDefinition;
        this.databaseInputDefinition = builder.databaseInputDefinition;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The Amazon S3 location where the data is stored.
     * </p>
     * 
     * @return The Amazon S3 location where the data is stored.
     */
    public final S3Location s3InputDefinition() {
        return s3InputDefinition;
    }

    /**
     * <p>
     * The Glue Data Catalog parameters for the data.
     * </p>
     * 
     * @return The Glue Data Catalog parameters for the data.
     */
    public final DataCatalogInputDefinition dataCatalogInputDefinition() {
        return dataCatalogInputDefinition;
    }

    /**
     * <p>
     * Connection information for dataset input files stored in a database.
     * </p>
     * 
     * @return Connection information for dataset input files stored in a database.
     */
    public final DatabaseInputDefinition databaseInputDefinition() {
        return databaseInputDefinition;
    }

    /**
     * <p>
     * Contains additional resource information needed for specific datasets.
     * </p>
     * 
     * @return Contains additional resource information needed for specific datasets.
     */
    public final Metadata metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3InputDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(dataCatalogInputDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(databaseInputDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Input)) {
            return false;
        }
        Input other = (Input) obj;
        return Objects.equals(s3InputDefinition(), other.s3InputDefinition())
                && Objects.equals(dataCatalogInputDefinition(), other.dataCatalogInputDefinition())
                && Objects.equals(databaseInputDefinition(), other.databaseInputDefinition())
                && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Input").add("S3InputDefinition", s3InputDefinition())
                .add("DataCatalogInputDefinition", dataCatalogInputDefinition())
                .add("DatabaseInputDefinition", databaseInputDefinition()).add("Metadata", metadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3InputDefinition":
            return Optional.ofNullable(clazz.cast(s3InputDefinition()));
        case "DataCatalogInputDefinition":
            return Optional.ofNullable(clazz.cast(dataCatalogInputDefinition()));
        case "DatabaseInputDefinition":
            return Optional.ofNullable(clazz.cast(databaseInputDefinition()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Input, T> g) {
        return obj -> g.apply((Input) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Input> {
        /**
         * <p>
         * The Amazon S3 location where the data is stored.
         * </p>
         * 
         * @param s3InputDefinition
         *        The Amazon S3 location where the data is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3InputDefinition(S3Location s3InputDefinition);

        /**
         * <p>
         * The Amazon S3 location where the data is stored.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Location.Builder} avoiding the need to create
         * one manually via {@link S3Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #s3InputDefinition(S3Location)}.
         * 
         * @param s3InputDefinition
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3InputDefinition(S3Location)
         */
        default Builder s3InputDefinition(Consumer<S3Location.Builder> s3InputDefinition) {
            return s3InputDefinition(S3Location.builder().applyMutation(s3InputDefinition).build());
        }

        /**
         * <p>
         * The Glue Data Catalog parameters for the data.
         * </p>
         * 
         * @param dataCatalogInputDefinition
         *        The Glue Data Catalog parameters for the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCatalogInputDefinition(DataCatalogInputDefinition dataCatalogInputDefinition);

        /**
         * <p>
         * The Glue Data Catalog parameters for the data.
         * </p>
         * This is a convenience that creates an instance of the {@link DataCatalogInputDefinition.Builder} avoiding the
         * need to create one manually via {@link DataCatalogInputDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataCatalogInputDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #dataCatalogInputDefinition(DataCatalogInputDefinition)}.
         * 
         * @param dataCatalogInputDefinition
         *        a consumer that will call methods on {@link DataCatalogInputDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataCatalogInputDefinition(DataCatalogInputDefinition)
         */
        default Builder dataCatalogInputDefinition(Consumer<DataCatalogInputDefinition.Builder> dataCatalogInputDefinition) {
            return dataCatalogInputDefinition(DataCatalogInputDefinition.builder().applyMutation(dataCatalogInputDefinition)
                    .build());
        }

        /**
         * <p>
         * Connection information for dataset input files stored in a database.
         * </p>
         * 
         * @param databaseInputDefinition
         *        Connection information for dataset input files stored in a database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseInputDefinition(DatabaseInputDefinition databaseInputDefinition);

        /**
         * <p>
         * Connection information for dataset input files stored in a database.
         * </p>
         * This is a convenience that creates an instance of the {@link DatabaseInputDefinition.Builder} avoiding the
         * need to create one manually via {@link DatabaseInputDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatabaseInputDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #databaseInputDefinition(DatabaseInputDefinition)}.
         * 
         * @param databaseInputDefinition
         *        a consumer that will call methods on {@link DatabaseInputDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #databaseInputDefinition(DatabaseInputDefinition)
         */
        default Builder databaseInputDefinition(Consumer<DatabaseInputDefinition.Builder> databaseInputDefinition) {
            return databaseInputDefinition(DatabaseInputDefinition.builder().applyMutation(databaseInputDefinition).build());
        }

        /**
         * <p>
         * Contains additional resource information needed for specific datasets.
         * </p>
         * 
         * @param metadata
         *        Contains additional resource information needed for specific datasets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Metadata metadata);

        /**
         * <p>
         * Contains additional resource information needed for specific datasets.
         * </p>
         * This is a convenience that creates an instance of the {@link Metadata.Builder} avoiding the need to create
         * one manually via {@link Metadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link Metadata.Builder#build()} is called immediately and its result is
         * passed to {@link #metadata(Metadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link Metadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(Metadata)
         */
        default Builder metadata(Consumer<Metadata.Builder> metadata) {
            return metadata(Metadata.builder().applyMutation(metadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3Location s3InputDefinition;

        private DataCatalogInputDefinition dataCatalogInputDefinition;

        private DatabaseInputDefinition databaseInputDefinition;

        private Metadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(Input model) {
            s3InputDefinition(model.s3InputDefinition);
            dataCatalogInputDefinition(model.dataCatalogInputDefinition);
            databaseInputDefinition(model.databaseInputDefinition);
            metadata(model.metadata);
        }

        public final S3Location.Builder getS3InputDefinition() {
            return s3InputDefinition != null ? s3InputDefinition.toBuilder() : null;
        }

        public final void setS3InputDefinition(S3Location.BuilderImpl s3InputDefinition) {
            this.s3InputDefinition = s3InputDefinition != null ? s3InputDefinition.build() : null;
        }

        @Override
        @Transient
        public final Builder s3InputDefinition(S3Location s3InputDefinition) {
            this.s3InputDefinition = s3InputDefinition;
            return this;
        }

        public final DataCatalogInputDefinition.Builder getDataCatalogInputDefinition() {
            return dataCatalogInputDefinition != null ? dataCatalogInputDefinition.toBuilder() : null;
        }

        public final void setDataCatalogInputDefinition(DataCatalogInputDefinition.BuilderImpl dataCatalogInputDefinition) {
            this.dataCatalogInputDefinition = dataCatalogInputDefinition != null ? dataCatalogInputDefinition.build() : null;
        }

        @Override
        @Transient
        public final Builder dataCatalogInputDefinition(DataCatalogInputDefinition dataCatalogInputDefinition) {
            this.dataCatalogInputDefinition = dataCatalogInputDefinition;
            return this;
        }

        public final DatabaseInputDefinition.Builder getDatabaseInputDefinition() {
            return databaseInputDefinition != null ? databaseInputDefinition.toBuilder() : null;
        }

        public final void setDatabaseInputDefinition(DatabaseInputDefinition.BuilderImpl databaseInputDefinition) {
            this.databaseInputDefinition = databaseInputDefinition != null ? databaseInputDefinition.build() : null;
        }

        @Override
        @Transient
        public final Builder databaseInputDefinition(DatabaseInputDefinition databaseInputDefinition) {
            this.databaseInputDefinition = databaseInputDefinition;
            return this;
        }

        public final Metadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(Metadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        @Transient
        public final Builder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public Input build() {
            return new Input(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
