/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration of evaluations for a profile job. This configuration can be used to select evaluations and override the
 * parameters of selected evaluations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatisticsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<StatisticsConfiguration.Builder, StatisticsConfiguration> {
    private static final SdkField<List<String>> INCLUDED_STATISTICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IncludedStatistics")
            .getter(getter(StatisticsConfiguration::includedStatistics))
            .setter(setter(Builder::includedStatistics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedStatistics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StatisticOverride>> OVERRIDES_FIELD = SdkField
            .<List<StatisticOverride>> builder(MarshallingType.LIST)
            .memberName("Overrides")
            .getter(getter(StatisticsConfiguration::overrides))
            .setter(setter(Builder::overrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StatisticOverride> builder(MarshallingType.SDK_POJO)
                                            .constructor(StatisticOverride::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDED_STATISTICS_FIELD,
            OVERRIDES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> includedStatistics;

    private final List<StatisticOverride> overrides;

    private StatisticsConfiguration(BuilderImpl builder) {
        this.includedStatistics = builder.includedStatistics;
        this.overrides = builder.overrides;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncludedStatistics property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIncludedStatistics() {
        return includedStatistics != null && !(includedStatistics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of included evaluations. When the list is undefined, all supported evaluations will be included.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludedStatistics} method.
     * </p>
     * 
     * @return List of included evaluations. When the list is undefined, all supported evaluations will be included.
     */
    public final List<String> includedStatistics() {
        return includedStatistics;
    }

    /**
     * For responses, this returns true if the service returned a value for the Overrides property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOverrides() {
        return overrides != null && !(overrides instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of overrides for evaluations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOverrides} method.
     * </p>
     * 
     * @return List of overrides for evaluations.
     */
    public final List<StatisticOverride> overrides() {
        return overrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludedStatistics() ? includedStatistics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOverrides() ? overrides() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatisticsConfiguration)) {
            return false;
        }
        StatisticsConfiguration other = (StatisticsConfiguration) obj;
        return hasIncludedStatistics() == other.hasIncludedStatistics()
                && Objects.equals(includedStatistics(), other.includedStatistics()) && hasOverrides() == other.hasOverrides()
                && Objects.equals(overrides(), other.overrides());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatisticsConfiguration")
                .add("IncludedStatistics", hasIncludedStatistics() ? includedStatistics() : null)
                .add("Overrides", hasOverrides() ? overrides() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IncludedStatistics":
            return Optional.ofNullable(clazz.cast(includedStatistics()));
        case "Overrides":
            return Optional.ofNullable(clazz.cast(overrides()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatisticsConfiguration, T> g) {
        return obj -> g.apply((StatisticsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatisticsConfiguration> {
        /**
         * <p>
         * List of included evaluations. When the list is undefined, all supported evaluations will be included.
         * </p>
         * 
         * @param includedStatistics
         *        List of included evaluations. When the list is undefined, all supported evaluations will be included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedStatistics(Collection<String> includedStatistics);

        /**
         * <p>
         * List of included evaluations. When the list is undefined, all supported evaluations will be included.
         * </p>
         * 
         * @param includedStatistics
         *        List of included evaluations. When the list is undefined, all supported evaluations will be included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedStatistics(String... includedStatistics);

        /**
         * <p>
         * List of overrides for evaluations.
         * </p>
         * 
         * @param overrides
         *        List of overrides for evaluations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(Collection<StatisticOverride> overrides);

        /**
         * <p>
         * List of overrides for evaluations.
         * </p>
         * 
         * @param overrides
         *        List of overrides for evaluations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(StatisticOverride... overrides);

        /**
         * <p>
         * List of overrides for evaluations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StatisticOverride>.Builder} avoiding the
         * need to create one manually via {@link List<StatisticOverride>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StatisticOverride>.Builder#build()} is called immediately
         * and its result is passed to {@link #overrides(List<StatisticOverride>)}.
         * 
         * @param overrides
         *        a consumer that will call methods on {@link List<StatisticOverride>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrides(List<StatisticOverride>)
         */
        Builder overrides(Consumer<StatisticOverride.Builder>... overrides);
    }

    static final class BuilderImpl implements Builder {
        private List<String> includedStatistics = DefaultSdkAutoConstructList.getInstance();

        private List<StatisticOverride> overrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StatisticsConfiguration model) {
            includedStatistics(model.includedStatistics);
            overrides(model.overrides);
        }

        public final Collection<String> getIncludedStatistics() {
            if (includedStatistics instanceof SdkAutoConstructList) {
                return null;
            }
            return includedStatistics;
        }

        public final void setIncludedStatistics(Collection<String> includedStatistics) {
            this.includedStatistics = StatisticListCopier.copy(includedStatistics);
        }

        @Override
        @Transient
        public final Builder includedStatistics(Collection<String> includedStatistics) {
            this.includedStatistics = StatisticListCopier.copy(includedStatistics);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder includedStatistics(String... includedStatistics) {
            includedStatistics(Arrays.asList(includedStatistics));
            return this;
        }

        public final List<StatisticOverride.Builder> getOverrides() {
            List<StatisticOverride.Builder> result = StatisticOverrideListCopier.copyToBuilder(this.overrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOverrides(Collection<StatisticOverride.BuilderImpl> overrides) {
            this.overrides = StatisticOverrideListCopier.copyFromBuilder(overrides);
        }

        @Override
        @Transient
        public final Builder overrides(Collection<StatisticOverride> overrides) {
            this.overrides = StatisticOverrideListCopier.copy(overrides);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder overrides(StatisticOverride... overrides) {
            overrides(Arrays.asList(overrides));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder overrides(Consumer<StatisticOverride.Builder>... overrides) {
            overrides(Stream.of(overrides).map(c -> StatisticOverride.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public StatisticsConfiguration build() {
            return new StatisticsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
