/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databrew.model.DataBrewResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRecipeVersionResponse
extends DataBrewResponse
implements ToCopyableBuilder<Builder, DeleteRecipeVersionResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DeleteRecipeVersionResponse.getter(DeleteRecipeVersionResponse::name)).setter(DeleteRecipeVersionResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RECIPE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecipeVersion").getter(DeleteRecipeVersionResponse.getter(DeleteRecipeVersionResponse::recipeVersion)).setter(DeleteRecipeVersionResponse.setter(Builder::recipeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RECIPE_VERSION_FIELD));
    private final String name;
    private final String recipeVersion;

    private DeleteRecipeVersionResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.recipeVersion = builder.recipeVersion;
    }

    public final String name() {
        return this.name;
    }

    public final String recipeVersion() {
        return this.recipeVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRecipeVersionResponse)) {
            return false;
        }
        DeleteRecipeVersionResponse other = (DeleteRecipeVersionResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.recipeVersion(), other.recipeVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteRecipeVersionResponse").add("Name", (Object)this.name()).add("RecipeVersion", (Object)this.recipeVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RecipeVersion": {
                return Optional.ofNullable(clazz.cast(this.recipeVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRecipeVersionResponse, T> g) {
        return obj -> g.apply((DeleteRecipeVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataBrewResponse.BuilderImpl
    implements Builder {
        private String name;
        private String recipeVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRecipeVersionResponse model) {
            super(model);
            this.name(model.name);
            this.recipeVersion(model.recipeVersion);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRecipeVersion() {
            return this.recipeVersion;
        }

        public final void setRecipeVersion(String recipeVersion) {
            this.recipeVersion = recipeVersion;
        }

        @Override
        @Transient
        public final Builder recipeVersion(String recipeVersion) {
            this.recipeVersion = recipeVersion;
            return this;
        }

        @Override
        public DeleteRecipeVersionResponse build() {
            return new DeleteRecipeVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataBrewResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRecipeVersionResponse> {
        public Builder name(String var1);

        public Builder recipeVersion(String var1);
    }
}

