/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databrew.model.AllowedStatisticListCopier;
import software.amazon.awssdk.services.databrew.model.AllowedStatistics;
import software.amazon.awssdk.services.databrew.model.EntityTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityDetectorConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityDetectorConfiguration> {
    private static final SdkField<List<String>> ENTITY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntityTypes").getter(EntityDetectorConfiguration.getter(EntityDetectorConfiguration::entityTypes)).setter(EntityDetectorConfiguration.setter(Builder::entityTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AllowedStatistics>> ALLOWED_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedStatistics").getter(EntityDetectorConfiguration.getter(EntityDetectorConfiguration::allowedStatistics)).setter(EntityDetectorConfiguration.setter(Builder::allowedStatistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedStatistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AllowedStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_TYPES_FIELD, ALLOWED_STATISTICS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> entityTypes;
    private final List<AllowedStatistics> allowedStatistics;

    private EntityDetectorConfiguration(BuilderImpl builder) {
        this.entityTypes = builder.entityTypes;
        this.allowedStatistics = builder.allowedStatistics;
    }

    public final boolean hasEntityTypes() {
        return this.entityTypes != null && !(this.entityTypes instanceof SdkAutoConstructList);
    }

    public final List<String> entityTypes() {
        return this.entityTypes;
    }

    public final boolean hasAllowedStatistics() {
        return this.allowedStatistics != null && !(this.allowedStatistics instanceof SdkAutoConstructList);
    }

    public final List<AllowedStatistics> allowedStatistics() {
        return this.allowedStatistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityTypes() ? this.entityTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedStatistics() ? this.allowedStatistics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityDetectorConfiguration)) {
            return false;
        }
        EntityDetectorConfiguration other = (EntityDetectorConfiguration)obj;
        return this.hasEntityTypes() == other.hasEntityTypes() && Objects.equals(this.entityTypes(), other.entityTypes()) && this.hasAllowedStatistics() == other.hasAllowedStatistics() && Objects.equals(this.allowedStatistics(), other.allowedStatistics());
    }

    public final String toString() {
        return ToString.builder((String)"EntityDetectorConfiguration").add("EntityTypes", this.hasEntityTypes() ? this.entityTypes() : null).add("AllowedStatistics", this.hasAllowedStatistics() ? this.allowedStatistics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityTypes": {
                return Optional.ofNullable(clazz.cast(this.entityTypes()));
            }
            case "AllowedStatistics": {
                return Optional.ofNullable(clazz.cast(this.allowedStatistics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityDetectorConfiguration, T> g) {
        return obj -> g.apply((EntityDetectorConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> entityTypes = DefaultSdkAutoConstructList.getInstance();
        private List<AllowedStatistics> allowedStatistics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EntityDetectorConfiguration model) {
            this.entityTypes(model.entityTypes);
            this.allowedStatistics(model.allowedStatistics);
        }

        public final Collection<String> getEntityTypes() {
            if (this.entityTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entityTypes;
        }

        public final void setEntityTypes(Collection<String> entityTypes) {
            this.entityTypes = EntityTypeListCopier.copy(entityTypes);
        }

        @Override
        @Transient
        public final Builder entityTypes(Collection<String> entityTypes) {
            this.entityTypes = EntityTypeListCopier.copy(entityTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entityTypes(String ... entityTypes) {
            this.entityTypes(Arrays.asList(entityTypes));
            return this;
        }

        public final List<AllowedStatistics.Builder> getAllowedStatistics() {
            List<AllowedStatistics.Builder> result = AllowedStatisticListCopier.copyToBuilder(this.allowedStatistics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllowedStatistics(Collection<AllowedStatistics.BuilderImpl> allowedStatistics) {
            this.allowedStatistics = AllowedStatisticListCopier.copyFromBuilder(allowedStatistics);
        }

        @Override
        @Transient
        public final Builder allowedStatistics(Collection<AllowedStatistics> allowedStatistics) {
            this.allowedStatistics = AllowedStatisticListCopier.copy(allowedStatistics);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder allowedStatistics(AllowedStatistics ... allowedStatistics) {
            this.allowedStatistics(Arrays.asList(allowedStatistics));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder allowedStatistics(Consumer<AllowedStatistics.Builder> ... allowedStatistics) {
            this.allowedStatistics(Stream.of(allowedStatistics).map(c -> (AllowedStatistics)((AllowedStatistics.Builder)AllowedStatistics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EntityDetectorConfiguration build() {
            return new EntityDetectorConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityDetectorConfiguration> {
        public Builder entityTypes(Collection<String> var1);

        public Builder entityTypes(String ... var1);

        public Builder allowedStatistics(Collection<AllowedStatistics> var1);

        public Builder allowedStatistics(AllowedStatistics ... var1);

        public Builder allowedStatistics(Consumer<AllowedStatistics.Builder> ... var1);
    }
}

