/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.databrew.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RulesetItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RulesetItem> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(RulesetItem.getter(RulesetItem::accountId)).setter(RulesetItem.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(RulesetItem.getter(RulesetItem::createdBy)).setter(RulesetItem.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(RulesetItem.getter(RulesetItem::createDate)).setter(RulesetItem.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RulesetItem.getter(RulesetItem::description)).setter(RulesetItem.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedBy").getter(RulesetItem.getter(RulesetItem::lastModifiedBy)).setter(RulesetItem.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(RulesetItem.getter(RulesetItem::lastModifiedDate)).setter(RulesetItem.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RulesetItem.getter(RulesetItem::name)).setter(RulesetItem.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(RulesetItem.getter(RulesetItem::resourceArn)).setter(RulesetItem.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<Integer> RULE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RuleCount").getter(RulesetItem.getter(RulesetItem::ruleCount)).setter(RulesetItem.setter(Builder::ruleCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleCount").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(RulesetItem.getter(RulesetItem::tags)).setter(RulesetItem.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetArn").getter(RulesetItem.getter(RulesetItem::targetArn)).setter(RulesetItem.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, CREATED_BY_FIELD, CREATE_DATE_FIELD, DESCRIPTION_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_DATE_FIELD, NAME_FIELD, RESOURCE_ARN_FIELD, RULE_COUNT_FIELD, TAGS_FIELD, TARGET_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String createdBy;
    private final Instant createDate;
    private final String description;
    private final String lastModifiedBy;
    private final Instant lastModifiedDate;
    private final String name;
    private final String resourceArn;
    private final Integer ruleCount;
    private final Map<String, String> tags;
    private final String targetArn;

    private RulesetItem(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.createdBy = builder.createdBy;
        this.createDate = builder.createDate;
        this.description = builder.description;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.name = builder.name;
        this.resourceArn = builder.resourceArn;
        this.ruleCount = builder.ruleCount;
        this.tags = builder.tags;
        this.targetArn = builder.targetArn;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final String description() {
        return this.description;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final String name() {
        return this.name;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final Integer ruleCount() {
        return this.ruleCount;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RulesetItem)) {
            return false;
        }
        RulesetItem other = (RulesetItem)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.ruleCount(), other.ruleCount()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.targetArn(), other.targetArn());
    }

    public final String toString() {
        return ToString.builder((String)"RulesetItem").add("AccountId", (Object)this.accountId()).add("CreatedBy", (Object)this.createdBy()).add("CreateDate", (Object)this.createDate()).add("Description", (Object)this.description()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("Name", (Object)this.name()).add("ResourceArn", (Object)this.resourceArn()).add("RuleCount", (Object)this.ruleCount()).add("Tags", this.hasTags() ? this.tags() : null).add("TargetArn", (Object)this.targetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "RuleCount": {
                return Optional.ofNullable(clazz.cast(this.ruleCount()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TargetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RulesetItem, T> g) {
        return obj -> g.apply((RulesetItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String createdBy;
        private Instant createDate;
        private String description;
        private String lastModifiedBy;
        private Instant lastModifiedDate;
        private String name;
        private String resourceArn;
        private Integer ruleCount;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String targetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RulesetItem model) {
            this.accountId(model.accountId);
            this.createdBy(model.createdBy);
            this.createDate(model.createDate);
            this.description(model.description);
            this.lastModifiedBy(model.lastModifiedBy);
            this.lastModifiedDate(model.lastModifiedDate);
            this.name(model.name);
            this.resourceArn(model.resourceArn);
            this.ruleCount(model.ruleCount);
            this.tags(model.tags);
            this.targetArn(model.targetArn);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        @Transient
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        @Transient
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        @Transient
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        @Transient
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Integer getRuleCount() {
            return this.ruleCount;
        }

        public final void setRuleCount(Integer ruleCount) {
            this.ruleCount = ruleCount;
        }

        @Override
        @Transient
        public final Builder ruleCount(Integer ruleCount) {
            this.ruleCount = ruleCount;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        @Transient
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public RulesetItem build() {
            return new RulesetItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RulesetItem> {
        public Builder accountId(String var1);

        public Builder createdBy(String var1);

        public Builder createDate(Instant var1);

        public Builder description(String var1);

        public Builder lastModifiedBy(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder name(String var1);

        public Builder resourceArn(String var1);

        public Builder ruleCount(Integer var1);

        public Builder tags(Map<String, String> var1);

        public Builder targetArn(String var1);
    }
}

