/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for profile jobs. Configuration can be used to select columns, do evaluations, and override default
 * parameters of evaluations. When configuration is undefined, the profile job will apply default settings to all
 * supported columns.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProfileConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ProfileConfiguration.Builder, ProfileConfiguration> {
    private static final SdkField<StatisticsConfiguration> DATASET_STATISTICS_CONFIGURATION_FIELD = SdkField
            .<StatisticsConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DatasetStatisticsConfiguration")
            .getter(getter(ProfileConfiguration::datasetStatisticsConfiguration))
            .setter(setter(Builder::datasetStatisticsConfiguration))
            .constructor(StatisticsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetStatisticsConfiguration")
                    .build()).build();

    private static final SdkField<List<ColumnSelector>> PROFILE_COLUMNS_FIELD = SdkField
            .<List<ColumnSelector>> builder(MarshallingType.LIST)
            .memberName("ProfileColumns")
            .getter(getter(ProfileConfiguration::profileColumns))
            .setter(setter(Builder::profileColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ColumnStatisticsConfiguration>> COLUMN_STATISTICS_CONFIGURATIONS_FIELD = SdkField
            .<List<ColumnStatisticsConfiguration>> builder(MarshallingType.LIST)
            .memberName("ColumnStatisticsConfigurations")
            .getter(getter(ProfileConfiguration::columnStatisticsConfigurations))
            .setter(setter(Builder::columnStatisticsConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnStatisticsConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnStatisticsConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnStatisticsConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EntityDetectorConfiguration> ENTITY_DETECTOR_CONFIGURATION_FIELD = SdkField
            .<EntityDetectorConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("EntityDetectorConfiguration")
            .getter(getter(ProfileConfiguration::entityDetectorConfiguration))
            .setter(setter(Builder::entityDetectorConfiguration))
            .constructor(EntityDetectorConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityDetectorConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATASET_STATISTICS_CONFIGURATION_FIELD, PROFILE_COLUMNS_FIELD, COLUMN_STATISTICS_CONFIGURATIONS_FIELD,
            ENTITY_DETECTOR_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final StatisticsConfiguration datasetStatisticsConfiguration;

    private final List<ColumnSelector> profileColumns;

    private final List<ColumnStatisticsConfiguration> columnStatisticsConfigurations;

    private final EntityDetectorConfiguration entityDetectorConfiguration;

    private ProfileConfiguration(BuilderImpl builder) {
        this.datasetStatisticsConfiguration = builder.datasetStatisticsConfiguration;
        this.profileColumns = builder.profileColumns;
        this.columnStatisticsConfigurations = builder.columnStatisticsConfigurations;
        this.entityDetectorConfiguration = builder.entityDetectorConfiguration;
    }

    /**
     * <p>
     * Configuration for inter-column evaluations. Configuration can be used to select evaluations and override
     * parameters of evaluations. When configuration is undefined, the profile job will run all supported inter-column
     * evaluations.
     * </p>
     * 
     * @return Configuration for inter-column evaluations. Configuration can be used to select evaluations and override
     *         parameters of evaluations. When configuration is undefined, the profile job will run all supported
     *         inter-column evaluations.
     */
    public final StatisticsConfiguration datasetStatisticsConfiguration() {
        return datasetStatisticsConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProfileColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProfileColumns() {
        return profileColumns != null && !(profileColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of column selectors. ProfileColumns can be used to select columns from the dataset. When ProfileColumns is
     * undefined, the profile job will profile all supported columns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfileColumns} method.
     * </p>
     * 
     * @return List of column selectors. ProfileColumns can be used to select columns from the dataset. When
     *         ProfileColumns is undefined, the profile job will profile all supported columns.
     */
    public final List<ColumnSelector> profileColumns() {
        return profileColumns;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnStatisticsConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasColumnStatisticsConfigurations() {
        return columnStatisticsConfigurations != null && !(columnStatisticsConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of configurations for column evaluations. ColumnStatisticsConfigurations are used to select evaluations and
     * override parameters of evaluations for particular columns. When ColumnStatisticsConfigurations is undefined, the
     * profile job will profile all supported columns and run all supported evaluations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnStatisticsConfigurations} method.
     * </p>
     * 
     * @return List of configurations for column evaluations. ColumnStatisticsConfigurations are used to select
     *         evaluations and override parameters of evaluations for particular columns. When
     *         ColumnStatisticsConfigurations is undefined, the profile job will profile all supported columns and run
     *         all supported evaluations.
     */
    public final List<ColumnStatisticsConfiguration> columnStatisticsConfigurations() {
        return columnStatisticsConfigurations;
    }

    /**
     * <p>
     * Configuration of entity detection for a profile job. When undefined, entity detection is disabled.
     * </p>
     * 
     * @return Configuration of entity detection for a profile job. When undefined, entity detection is disabled.
     */
    public final EntityDetectorConfiguration entityDetectorConfiguration() {
        return entityDetectorConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetStatisticsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasProfileColumns() ? profileColumns() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasColumnStatisticsConfigurations() ? columnStatisticsConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(entityDetectorConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileConfiguration)) {
            return false;
        }
        ProfileConfiguration other = (ProfileConfiguration) obj;
        return Objects.equals(datasetStatisticsConfiguration(), other.datasetStatisticsConfiguration())
                && hasProfileColumns() == other.hasProfileColumns() && Objects.equals(profileColumns(), other.profileColumns())
                && hasColumnStatisticsConfigurations() == other.hasColumnStatisticsConfigurations()
                && Objects.equals(columnStatisticsConfigurations(), other.columnStatisticsConfigurations())
                && Objects.equals(entityDetectorConfiguration(), other.entityDetectorConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ProfileConfiguration")
                .add("DatasetStatisticsConfiguration", datasetStatisticsConfiguration())
                .add("ProfileColumns", hasProfileColumns() ? profileColumns() : null)
                .add("ColumnStatisticsConfigurations",
                        hasColumnStatisticsConfigurations() ? columnStatisticsConfigurations() : null)
                .add("EntityDetectorConfiguration", entityDetectorConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetStatisticsConfiguration":
            return Optional.ofNullable(clazz.cast(datasetStatisticsConfiguration()));
        case "ProfileColumns":
            return Optional.ofNullable(clazz.cast(profileColumns()));
        case "ColumnStatisticsConfigurations":
            return Optional.ofNullable(clazz.cast(columnStatisticsConfigurations()));
        case "EntityDetectorConfiguration":
            return Optional.ofNullable(clazz.cast(entityDetectorConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProfileConfiguration, T> g) {
        return obj -> g.apply((ProfileConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProfileConfiguration> {
        /**
         * <p>
         * Configuration for inter-column evaluations. Configuration can be used to select evaluations and override
         * parameters of evaluations. When configuration is undefined, the profile job will run all supported
         * inter-column evaluations.
         * </p>
         * 
         * @param datasetStatisticsConfiguration
         *        Configuration for inter-column evaluations. Configuration can be used to select evaluations and
         *        override parameters of evaluations. When configuration is undefined, the profile job will run all
         *        supported inter-column evaluations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetStatisticsConfiguration(StatisticsConfiguration datasetStatisticsConfiguration);

        /**
         * <p>
         * Configuration for inter-column evaluations. Configuration can be used to select evaluations and override
         * parameters of evaluations. When configuration is undefined, the profile job will run all supported
         * inter-column evaluations.
         * </p>
         * This is a convenience method that creates an instance of the {@link StatisticsConfiguration.Builder} avoiding
         * the need to create one manually via {@link StatisticsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link StatisticsConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #datasetStatisticsConfiguration(StatisticsConfiguration)}.
         * 
         * @param datasetStatisticsConfiguration
         *        a consumer that will call methods on {@link StatisticsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetStatisticsConfiguration(StatisticsConfiguration)
         */
        default Builder datasetStatisticsConfiguration(Consumer<StatisticsConfiguration.Builder> datasetStatisticsConfiguration) {
            return datasetStatisticsConfiguration(StatisticsConfiguration.builder().applyMutation(datasetStatisticsConfiguration)
                    .build());
        }

        /**
         * <p>
         * List of column selectors. ProfileColumns can be used to select columns from the dataset. When ProfileColumns
         * is undefined, the profile job will profile all supported columns.
         * </p>
         * 
         * @param profileColumns
         *        List of column selectors. ProfileColumns can be used to select columns from the dataset. When
         *        ProfileColumns is undefined, the profile job will profile all supported columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileColumns(Collection<ColumnSelector> profileColumns);

        /**
         * <p>
         * List of column selectors. ProfileColumns can be used to select columns from the dataset. When ProfileColumns
         * is undefined, the profile job will profile all supported columns.
         * </p>
         * 
         * @param profileColumns
         *        List of column selectors. ProfileColumns can be used to select columns from the dataset. When
         *        ProfileColumns is undefined, the profile job will profile all supported columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileColumns(ColumnSelector... profileColumns);

        /**
         * <p>
         * List of column selectors. ProfileColumns can be used to select columns from the dataset. When ProfileColumns
         * is undefined, the profile job will profile all supported columns.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ColumnSelector>.Builder} avoiding
         * the need to create one manually via {@link List<ColumnSelector>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ColumnSelector>.Builder#build()} is called immediately and
         * its result is passed to {@link #profileColumns(List<ColumnSelector>)}.
         * 
         * @param profileColumns
         *        a consumer that will call methods on {@link List<ColumnSelector>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profileColumns(List<ColumnSelector>)
         */
        Builder profileColumns(Consumer<ColumnSelector.Builder>... profileColumns);

        /**
         * <p>
         * List of configurations for column evaluations. ColumnStatisticsConfigurations are used to select evaluations
         * and override parameters of evaluations for particular columns. When ColumnStatisticsConfigurations is
         * undefined, the profile job will profile all supported columns and run all supported evaluations.
         * </p>
         * 
         * @param columnStatisticsConfigurations
         *        List of configurations for column evaluations. ColumnStatisticsConfigurations are used to select
         *        evaluations and override parameters of evaluations for particular columns. When
         *        ColumnStatisticsConfigurations is undefined, the profile job will profile all supported columns and
         *        run all supported evaluations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnStatisticsConfigurations(Collection<ColumnStatisticsConfiguration> columnStatisticsConfigurations);

        /**
         * <p>
         * List of configurations for column evaluations. ColumnStatisticsConfigurations are used to select evaluations
         * and override parameters of evaluations for particular columns. When ColumnStatisticsConfigurations is
         * undefined, the profile job will profile all supported columns and run all supported evaluations.
         * </p>
         * 
         * @param columnStatisticsConfigurations
         *        List of configurations for column evaluations. ColumnStatisticsConfigurations are used to select
         *        evaluations and override parameters of evaluations for particular columns. When
         *        ColumnStatisticsConfigurations is undefined, the profile job will profile all supported columns and
         *        run all supported evaluations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnStatisticsConfigurations(ColumnStatisticsConfiguration... columnStatisticsConfigurations);

        /**
         * <p>
         * List of configurations for column evaluations. ColumnStatisticsConfigurations are used to select evaluations
         * and override parameters of evaluations for particular columns. When ColumnStatisticsConfigurations is
         * undefined, the profile job will profile all supported columns and run all supported evaluations.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <ColumnStatisticsConfiguration>.Builder} avoiding the need to create one manually via {@link List
         * <ColumnStatisticsConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ColumnStatisticsConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #columnStatisticsConfigurations(List<ColumnStatisticsConfiguration>)}.
         * 
         * @param columnStatisticsConfigurations
         *        a consumer that will call methods on {@link List<ColumnStatisticsConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnStatisticsConfigurations(List<ColumnStatisticsConfiguration>)
         */
        Builder columnStatisticsConfigurations(Consumer<ColumnStatisticsConfiguration.Builder>... columnStatisticsConfigurations);

        /**
         * <p>
         * Configuration of entity detection for a profile job. When undefined, entity detection is disabled.
         * </p>
         * 
         * @param entityDetectorConfiguration
         *        Configuration of entity detection for a profile job. When undefined, entity detection is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityDetectorConfiguration(EntityDetectorConfiguration entityDetectorConfiguration);

        /**
         * <p>
         * Configuration of entity detection for a profile job. When undefined, entity detection is disabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link EntityDetectorConfiguration.Builder}
         * avoiding the need to create one manually via {@link EntityDetectorConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link EntityDetectorConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #entityDetectorConfiguration(EntityDetectorConfiguration)}.
         * 
         * @param entityDetectorConfiguration
         *        a consumer that will call methods on {@link EntityDetectorConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityDetectorConfiguration(EntityDetectorConfiguration)
         */
        default Builder entityDetectorConfiguration(Consumer<EntityDetectorConfiguration.Builder> entityDetectorConfiguration) {
            return entityDetectorConfiguration(EntityDetectorConfiguration.builder().applyMutation(entityDetectorConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StatisticsConfiguration datasetStatisticsConfiguration;

        private List<ColumnSelector> profileColumns = DefaultSdkAutoConstructList.getInstance();

        private List<ColumnStatisticsConfiguration> columnStatisticsConfigurations = DefaultSdkAutoConstructList.getInstance();

        private EntityDetectorConfiguration entityDetectorConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileConfiguration model) {
            datasetStatisticsConfiguration(model.datasetStatisticsConfiguration);
            profileColumns(model.profileColumns);
            columnStatisticsConfigurations(model.columnStatisticsConfigurations);
            entityDetectorConfiguration(model.entityDetectorConfiguration);
        }

        public final StatisticsConfiguration.Builder getDatasetStatisticsConfiguration() {
            return datasetStatisticsConfiguration != null ? datasetStatisticsConfiguration.toBuilder() : null;
        }

        public final void setDatasetStatisticsConfiguration(StatisticsConfiguration.BuilderImpl datasetStatisticsConfiguration) {
            this.datasetStatisticsConfiguration = datasetStatisticsConfiguration != null ? datasetStatisticsConfiguration.build()
                    : null;
        }

        @Override
        public final Builder datasetStatisticsConfiguration(StatisticsConfiguration datasetStatisticsConfiguration) {
            this.datasetStatisticsConfiguration = datasetStatisticsConfiguration;
            return this;
        }

        public final List<ColumnSelector.Builder> getProfileColumns() {
            List<ColumnSelector.Builder> result = ColumnSelectorListCopier.copyToBuilder(this.profileColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfileColumns(Collection<ColumnSelector.BuilderImpl> profileColumns) {
            this.profileColumns = ColumnSelectorListCopier.copyFromBuilder(profileColumns);
        }

        @Override
        public final Builder profileColumns(Collection<ColumnSelector> profileColumns) {
            this.profileColumns = ColumnSelectorListCopier.copy(profileColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileColumns(ColumnSelector... profileColumns) {
            profileColumns(Arrays.asList(profileColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileColumns(Consumer<ColumnSelector.Builder>... profileColumns) {
            profileColumns(Stream.of(profileColumns).map(c -> ColumnSelector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ColumnStatisticsConfiguration.Builder> getColumnStatisticsConfigurations() {
            List<ColumnStatisticsConfiguration.Builder> result = ColumnStatisticsConfigurationListCopier
                    .copyToBuilder(this.columnStatisticsConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnStatisticsConfigurations(
                Collection<ColumnStatisticsConfiguration.BuilderImpl> columnStatisticsConfigurations) {
            this.columnStatisticsConfigurations = ColumnStatisticsConfigurationListCopier
                    .copyFromBuilder(columnStatisticsConfigurations);
        }

        @Override
        public final Builder columnStatisticsConfigurations(
                Collection<ColumnStatisticsConfiguration> columnStatisticsConfigurations) {
            this.columnStatisticsConfigurations = ColumnStatisticsConfigurationListCopier.copy(columnStatisticsConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnStatisticsConfigurations(ColumnStatisticsConfiguration... columnStatisticsConfigurations) {
            columnStatisticsConfigurations(Arrays.asList(columnStatisticsConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnStatisticsConfigurations(
                Consumer<ColumnStatisticsConfiguration.Builder>... columnStatisticsConfigurations) {
            columnStatisticsConfigurations(Stream.of(columnStatisticsConfigurations)
                    .map(c -> ColumnStatisticsConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final EntityDetectorConfiguration.Builder getEntityDetectorConfiguration() {
            return entityDetectorConfiguration != null ? entityDetectorConfiguration.toBuilder() : null;
        }

        public final void setEntityDetectorConfiguration(EntityDetectorConfiguration.BuilderImpl entityDetectorConfiguration) {
            this.entityDetectorConfiguration = entityDetectorConfiguration != null ? entityDetectorConfiguration.build() : null;
        }

        @Override
        public final Builder entityDetectorConfiguration(EntityDetectorConfiguration entityDetectorConfiguration) {
            this.entityDetectorConfiguration = entityDetectorConfiguration;
            return this;
        }

        @Override
        public ProfileConfiguration build() {
            return new ProfileConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
