/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a single step from a DataBrew recipe to be performed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecipeStep implements SdkPojo, Serializable, ToCopyableBuilder<RecipeStep.Builder, RecipeStep> {
    private static final SdkField<RecipeAction> ACTION_FIELD = SdkField.<RecipeAction> builder(MarshallingType.SDK_POJO)
            .memberName("Action").getter(getter(RecipeStep::action)).setter(setter(Builder::action))
            .constructor(RecipeAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<List<ConditionExpression>> CONDITION_EXPRESSIONS_FIELD = SdkField
            .<List<ConditionExpression>> builder(MarshallingType.LIST)
            .memberName("ConditionExpressions")
            .getter(getter(RecipeStep::conditionExpressions))
            .setter(setter(Builder::conditionExpressions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionExpressions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConditionExpression> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConditionExpression::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            CONDITION_EXPRESSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final RecipeAction action;

    private final List<ConditionExpression> conditionExpressions;

    private RecipeStep(BuilderImpl builder) {
        this.action = builder.action;
        this.conditionExpressions = builder.conditionExpressions;
    }

    /**
     * <p>
     * The particular action to be performed in the recipe step.
     * </p>
     * 
     * @return The particular action to be performed in the recipe step.
     */
    public final RecipeAction action() {
        return action;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConditionExpressions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConditionExpressions() {
        return conditionExpressions != null && !(conditionExpressions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more conditions that must be met for the recipe step to succeed.
     * </p>
     * <note>
     * <p>
     * All of the conditions in the array must be met. In other words, all of the conditions must be combined using a
     * logical AND operation.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConditionExpressions} method.
     * </p>
     * 
     * @return One or more conditions that must be met for the recipe step to succeed.</p> <note>
     *         <p>
     *         All of the conditions in the array must be met. In other words, all of the conditions must be combined
     *         using a logical AND operation.
     *         </p>
     */
    public final List<ConditionExpression> conditionExpressions() {
        return conditionExpressions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(hasConditionExpressions() ? conditionExpressions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecipeStep)) {
            return false;
        }
        RecipeStep other = (RecipeStep) obj;
        return Objects.equals(action(), other.action()) && hasConditionExpressions() == other.hasConditionExpressions()
                && Objects.equals(conditionExpressions(), other.conditionExpressions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecipeStep").add("Action", action())
                .add("ConditionExpressions", hasConditionExpressions() ? conditionExpressions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "ConditionExpressions":
            return Optional.ofNullable(clazz.cast(conditionExpressions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecipeStep, T> g) {
        return obj -> g.apply((RecipeStep) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecipeStep> {
        /**
         * <p>
         * The particular action to be performed in the recipe step.
         * </p>
         * 
         * @param action
         *        The particular action to be performed in the recipe step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(RecipeAction action);

        /**
         * <p>
         * The particular action to be performed in the recipe step.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecipeAction.Builder} avoiding the need
         * to create one manually via {@link RecipeAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecipeAction.Builder#build()} is called immediately and its
         * result is passed to {@link #action(RecipeAction)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link RecipeAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(RecipeAction)
         */
        default Builder action(Consumer<RecipeAction.Builder> action) {
            return action(RecipeAction.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * One or more conditions that must be met for the recipe step to succeed.
         * </p>
         * <note>
         * <p>
         * All of the conditions in the array must be met. In other words, all of the conditions must be combined using
         * a logical AND operation.
         * </p>
         * </note>
         * 
         * @param conditionExpressions
         *        One or more conditions that must be met for the recipe step to succeed.</p> <note>
         *        <p>
         *        All of the conditions in the array must be met. In other words, all of the conditions must be combined
         *        using a logical AND operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionExpressions(Collection<ConditionExpression> conditionExpressions);

        /**
         * <p>
         * One or more conditions that must be met for the recipe step to succeed.
         * </p>
         * <note>
         * <p>
         * All of the conditions in the array must be met. In other words, all of the conditions must be combined using
         * a logical AND operation.
         * </p>
         * </note>
         * 
         * @param conditionExpressions
         *        One or more conditions that must be met for the recipe step to succeed.</p> <note>
         *        <p>
         *        All of the conditions in the array must be met. In other words, all of the conditions must be combined
         *        using a logical AND operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionExpressions(ConditionExpression... conditionExpressions);

        /**
         * <p>
         * One or more conditions that must be met for the recipe step to succeed.
         * </p>
         * <note>
         * <p>
         * All of the conditions in the array must be met. In other words, all of the conditions must be combined using
         * a logical AND operation.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link List
         * <ConditionExpression>.Builder} avoiding the need to create one manually via {@link List
         * <ConditionExpression>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConditionExpression>.Builder#build()} is called immediately
         * and its result is passed to {@link #conditionExpressions(List<ConditionExpression>)}.
         * 
         * @param conditionExpressions
         *        a consumer that will call methods on {@link List<ConditionExpression>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditionExpressions(List<ConditionExpression>)
         */
        Builder conditionExpressions(Consumer<ConditionExpression.Builder>... conditionExpressions);
    }

    static final class BuilderImpl implements Builder {
        private RecipeAction action;

        private List<ConditionExpression> conditionExpressions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecipeStep model) {
            action(model.action);
            conditionExpressions(model.conditionExpressions);
        }

        public final RecipeAction.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(RecipeAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(RecipeAction action) {
            this.action = action;
            return this;
        }

        public final List<ConditionExpression.Builder> getConditionExpressions() {
            List<ConditionExpression.Builder> result = ConditionExpressionListCopier.copyToBuilder(this.conditionExpressions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditionExpressions(Collection<ConditionExpression.BuilderImpl> conditionExpressions) {
            this.conditionExpressions = ConditionExpressionListCopier.copyFromBuilder(conditionExpressions);
        }

        @Override
        public final Builder conditionExpressions(Collection<ConditionExpression> conditionExpressions) {
            this.conditionExpressions = ConditionExpressionListCopier.copy(conditionExpressions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionExpressions(ConditionExpression... conditionExpressions) {
            conditionExpressions(Arrays.asList(conditionExpressions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionExpressions(Consumer<ConditionExpression.Builder>... conditionExpressions) {
            conditionExpressions(Stream.of(conditionExpressions).map(c -> ConditionExpression.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RecipeStep build() {
            return new RecipeStep(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
