/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents options that specify how and where DataBrew writes the Amazon S3 output generated by recipe jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3TableOutputOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<S3TableOutputOptions.Builder, S3TableOutputOptions> {
    private static final SdkField<S3Location> LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("Location").getter(getter(S3TableOutputOptions::location)).setter(setter(Builder::location))
            .constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3Location location;

    private S3TableOutputOptions(BuilderImpl builder) {
        this.location = builder.location;
    }

    /**
     * <p>
     * Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output from a job.
     * </p>
     * 
     * @return Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output from a job.
     */
    public final S3Location location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3TableOutputOptions)) {
            return false;
        }
        S3TableOutputOptions other = (S3TableOutputOptions) obj;
        return Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3TableOutputOptions").add("Location", location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3TableOutputOptions, T> g) {
        return obj -> g.apply((S3TableOutputOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3TableOutputOptions> {
        /**
         * <p>
         * Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output from a job.
         * </p>
         * 
         * @param location
         *        Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output from a
         *        job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(S3Location location);

        /**
         * <p>
         * Represents an Amazon S3 location (bucket name and object key) where DataBrew can write output from a job.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #location(S3Location)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(S3Location)
         */
        default Builder location(Consumer<S3Location.Builder> location) {
            return location(S3Location.builder().applyMutation(location).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3Location location;

        private BuilderImpl() {
        }

        private BuilderImpl(S3TableOutputOptions model) {
            location(model.location);
        }

        public final S3Location.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(S3Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(S3Location location) {
            this.location = location;
            return this;
        }

        @Override
        public S3TableOutputOptions build() {
            return new S3TableOutputOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
