/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AnalyticsMode {
    ENABLE("ENABLE"),
    DISABLE("DISABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AnalyticsMode> VALUE_MAP;
    private final String value;

    private AnalyticsMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AnalyticsMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AnalyticsMode> knownValues() {
        EnumSet<AnalyticsMode> knownValues = EnumSet.allOf(AnalyticsMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AnalyticsMode.class, AnalyticsMode::toString);
    }
}

