/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databrew.DataBrewClient;
import software.amazon.awssdk.services.databrew.internal.UserAgentUtils;
import software.amazon.awssdk.services.databrew.model.Dataset;
import software.amazon.awssdk.services.databrew.model.ListDatasetsRequest;
import software.amazon.awssdk.services.databrew.model.ListDatasetsResponse;

public class ListDatasetsIterable
implements SdkIterable<ListDatasetsResponse> {
    private final DataBrewClient client;
    private final ListDatasetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDatasetsIterable(DataBrewClient client, ListDatasetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDatasetsResponseFetcher();
    }

    public Iterator<ListDatasetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Dataset> datasets() {
        Function<ListDatasetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.datasets() != null) {
                return response.datasets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDatasetsResponseFetcher
    implements SyncPageFetcher<ListDatasetsResponse> {
        private ListDatasetsResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDatasetsResponse nextPage(ListDatasetsResponse previousPage) {
            if (previousPage == null) {
                return ListDatasetsIterable.this.client.listDatasets(ListDatasetsIterable.this.firstRequest);
            }
            return ListDatasetsIterable.this.client.listDatasets((ListDatasetsRequest)((Object)ListDatasetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

