/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProjectResponse extends DataBrewResponse implements
        ToCopyableBuilder<DescribeProjectResponse.Builder, DescribeProjectResponse> {
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(DescribeProjectResponse::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(DescribeProjectResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(DescribeProjectResponse::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate").getter(getter(DescribeProjectResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedBy").getter(getter(DescribeProjectResponse::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeProjectResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RECIPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecipeName").getter(getter(DescribeProjectResponse::recipeName)).setter(setter(Builder::recipeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeName").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(DescribeProjectResponse::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<Sample> SAMPLE_FIELD = SdkField.<Sample> builder(MarshallingType.SDK_POJO).memberName("Sample")
            .getter(getter(DescribeProjectResponse::sample)).setter(setter(Builder::sample)).constructor(Sample::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sample").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeProjectResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DescribeProjectResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SESSION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionStatus").getter(getter(DescribeProjectResponse::sessionStatusAsString))
            .setter(setter(Builder::sessionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionStatus").build()).build();

    private static final SdkField<String> OPENED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpenedBy").getter(getter(DescribeProjectResponse::openedBy)).setter(setter(Builder::openedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenedBy").build()).build();

    private static final SdkField<Instant> OPEN_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("OpenDate").getter(getter(DescribeProjectResponse::openDate)).setter(setter(Builder::openDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_DATE_FIELD,
            CREATED_BY_FIELD, DATASET_NAME_FIELD, LAST_MODIFIED_DATE_FIELD, LAST_MODIFIED_BY_FIELD, NAME_FIELD,
            RECIPE_NAME_FIELD, RESOURCE_ARN_FIELD, SAMPLE_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, SESSION_STATUS_FIELD,
            OPENED_BY_FIELD, OPEN_DATE_FIELD));

    private final Instant createDate;

    private final String createdBy;

    private final String datasetName;

    private final Instant lastModifiedDate;

    private final String lastModifiedBy;

    private final String name;

    private final String recipeName;

    private final String resourceArn;

    private final Sample sample;

    private final String roleArn;

    private final Map<String, String> tags;

    private final String sessionStatus;

    private final String openedBy;

    private final Instant openDate;

    private DescribeProjectResponse(BuilderImpl builder) {
        super(builder);
        this.createDate = builder.createDate;
        this.createdBy = builder.createdBy;
        this.datasetName = builder.datasetName;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.name = builder.name;
        this.recipeName = builder.recipeName;
        this.resourceArn = builder.resourceArn;
        this.sample = builder.sample;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.sessionStatus = builder.sessionStatus;
        this.openedBy = builder.openedBy;
        this.openDate = builder.openDate;
    }

    /**
     * <p>
     * The date and time that the project was created.
     * </p>
     * 
     * @return The date and time that the project was created.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The identifier (user name) of the user who created the project.
     * </p>
     * 
     * @return The identifier (user name) of the user who created the project.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The dataset associated with the project.
     * </p>
     * 
     * @return The dataset associated with the project.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The date and time that the project was last modified.
     * </p>
     * 
     * @return The date and time that the project was last modified.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The identifier (user name) of the user who last modified the project.
     * </p>
     * 
     * @return The identifier (user name) of the user who last modified the project.
     */
    public final String lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * The name of the project.
     * </p>
     * 
     * @return The name of the project.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The recipe associated with this job.
     * </p>
     * 
     * @return The recipe associated with this job.
     */
    public final String recipeName() {
        return recipeName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the project.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the project.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * Returns the value of the Sample property for this object.
     * 
     * @return The value of the Sample property for this object.
     */
    public final Sample sample() {
        return sample;
    }

    /**
     * <p>
     * The ARN of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.
     * </p>
     * 
     * @return The ARN of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata tags associated with this project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata tags associated with this project.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Describes the current state of the session:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PROVISIONING</code> - allocating resources for the session.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INITIALIZING</code> - getting the session ready for first use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ASSIGNED</code> - the session is ready for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sessionStatus}
     * will return {@link SessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sessionStatusAsString}.
     * </p>
     * 
     * @return Describes the current state of the session:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PROVISIONING</code> - allocating resources for the session.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INITIALIZING</code> - getting the session ready for first use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ASSIGNED</code> - the session is ready for use.
     *         </p>
     *         </li>
     * @see SessionStatus
     */
    public final SessionStatus sessionStatus() {
        return SessionStatus.fromValue(sessionStatus);
    }

    /**
     * <p>
     * Describes the current state of the session:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PROVISIONING</code> - allocating resources for the session.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INITIALIZING</code> - getting the session ready for first use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ASSIGNED</code> - the session is ready for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sessionStatus}
     * will return {@link SessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sessionStatusAsString}.
     * </p>
     * 
     * @return Describes the current state of the session:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PROVISIONING</code> - allocating resources for the session.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INITIALIZING</code> - getting the session ready for first use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ASSIGNED</code> - the session is ready for use.
     *         </p>
     *         </li>
     * @see SessionStatus
     */
    public final String sessionStatusAsString() {
        return sessionStatus;
    }

    /**
     * <p>
     * The identifier (user name) of the user that opened the project for use.
     * </p>
     * 
     * @return The identifier (user name) of the user that opened the project for use.
     */
    public final String openedBy() {
        return openedBy;
    }

    /**
     * <p>
     * The date and time when the project was opened.
     * </p>
     * 
     * @return The date and time when the project was opened.
     */
    public final Instant openDate() {
        return openDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(recipeName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sample());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sessionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(openedBy());
        hashCode = 31 * hashCode + Objects.hashCode(openDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProjectResponse)) {
            return false;
        }
        DescribeProjectResponse other = (DescribeProjectResponse) obj;
        return Objects.equals(createDate(), other.createDate()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(datasetName(), other.datasetName())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(name(), other.name())
                && Objects.equals(recipeName(), other.recipeName()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(sample(), other.sample()) && Objects.equals(roleArn(), other.roleArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(sessionStatusAsString(), other.sessionStatusAsString())
                && Objects.equals(openedBy(), other.openedBy()) && Objects.equals(openDate(), other.openDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProjectResponse").add("CreateDate", createDate()).add("CreatedBy", createdBy())
                .add("DatasetName", datasetName()).add("LastModifiedDate", lastModifiedDate())
                .add("LastModifiedBy", lastModifiedBy()).add("Name", name()).add("RecipeName", recipeName())
                .add("ResourceArn", resourceArn()).add("Sample", sample()).add("RoleArn", roleArn())
                .add("Tags", hasTags() ? tags() : null).add("SessionStatus", sessionStatusAsString()).add("OpenedBy", openedBy())
                .add("OpenDate", openDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RecipeName":
            return Optional.ofNullable(clazz.cast(recipeName()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Sample":
            return Optional.ofNullable(clazz.cast(sample()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SessionStatus":
            return Optional.ofNullable(clazz.cast(sessionStatusAsString()));
        case "OpenedBy":
            return Optional.ofNullable(clazz.cast(openedBy()));
        case "OpenDate":
            return Optional.ofNullable(clazz.cast(openDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProjectResponse, T> g) {
        return obj -> g.apply((DescribeProjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataBrewResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProjectResponse> {
        /**
         * <p>
         * The date and time that the project was created.
         * </p>
         * 
         * @param createDate
         *        The date and time that the project was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The identifier (user name) of the user who created the project.
         * </p>
         * 
         * @param createdBy
         *        The identifier (user name) of the user who created the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The dataset associated with the project.
         * </p>
         * 
         * @param datasetName
         *        The dataset associated with the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The date and time that the project was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time that the project was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The identifier (user name) of the user who last modified the project.
         * </p>
         * 
         * @param lastModifiedBy
         *        The identifier (user name) of the user who last modified the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(String lastModifiedBy);

        /**
         * <p>
         * The name of the project.
         * </p>
         * 
         * @param name
         *        The name of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The recipe associated with this job.
         * </p>
         * 
         * @param recipeName
         *        The recipe associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeName(String recipeName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the project.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * Sets the value of the Sample property for this object.
         *
         * @param sample
         *        The new value for the Sample property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sample(Sample sample);

        /**
         * Sets the value of the Sample property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Sample.Builder} avoiding the need to
         * create one manually via {@link Sample#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Sample.Builder#build()} is called immediately and its result is
         * passed to {@link #sample(Sample)}.
         * 
         * @param sample
         *        a consumer that will call methods on {@link Sample.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sample(Sample)
         */
        default Builder sample(Consumer<Sample.Builder> sample) {
            return sample(Sample.builder().applyMutation(sample).build());
        }

        /**
         * <p>
         * The ARN of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Metadata tags associated with this project.
         * </p>
         * 
         * @param tags
         *        Metadata tags associated with this project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Describes the current state of the session:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PROVISIONING</code> - allocating resources for the session.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INITIALIZING</code> - getting the session ready for first use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASSIGNED</code> - the session is ready for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sessionStatus
         *        Describes the current state of the session:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PROVISIONING</code> - allocating resources for the session.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INITIALIZING</code> - getting the session ready for first use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ASSIGNED</code> - the session is ready for use.
         *        </p>
         *        </li>
         * @see SessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatus
         */
        Builder sessionStatus(String sessionStatus);

        /**
         * <p>
         * Describes the current state of the session:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PROVISIONING</code> - allocating resources for the session.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INITIALIZING</code> - getting the session ready for first use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASSIGNED</code> - the session is ready for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sessionStatus
         *        Describes the current state of the session:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PROVISIONING</code> - allocating resources for the session.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INITIALIZING</code> - getting the session ready for first use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ASSIGNED</code> - the session is ready for use.
         *        </p>
         *        </li>
         * @see SessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatus
         */
        Builder sessionStatus(SessionStatus sessionStatus);

        /**
         * <p>
         * The identifier (user name) of the user that opened the project for use.
         * </p>
         * 
         * @param openedBy
         *        The identifier (user name) of the user that opened the project for use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openedBy(String openedBy);

        /**
         * <p>
         * The date and time when the project was opened.
         * </p>
         * 
         * @param openDate
         *        The date and time when the project was opened.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openDate(Instant openDate);
    }

    static final class BuilderImpl extends DataBrewResponse.BuilderImpl implements Builder {
        private Instant createDate;

        private String createdBy;

        private String datasetName;

        private Instant lastModifiedDate;

        private String lastModifiedBy;

        private String name;

        private String recipeName;

        private String resourceArn;

        private Sample sample;

        private String roleArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String sessionStatus;

        private String openedBy;

        private Instant openDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProjectResponse model) {
            super(model);
            createDate(model.createDate);
            createdBy(model.createdBy);
            datasetName(model.datasetName);
            lastModifiedDate(model.lastModifiedDate);
            lastModifiedBy(model.lastModifiedBy);
            name(model.name);
            recipeName(model.recipeName);
            resourceArn(model.resourceArn);
            sample(model.sample);
            roleArn(model.roleArn);
            tags(model.tags);
            sessionStatus(model.sessionStatus);
            openedBy(model.openedBy);
            openDate(model.openDate);
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDatasetName() {
            return datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getLastModifiedBy() {
            return lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRecipeName() {
            return recipeName;
        }

        public final void setRecipeName(String recipeName) {
            this.recipeName = recipeName;
        }

        @Override
        public final Builder recipeName(String recipeName) {
            this.recipeName = recipeName;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Sample.Builder getSample() {
            return sample != null ? sample.toBuilder() : null;
        }

        public final void setSample(Sample.BuilderImpl sample) {
            this.sample = sample != null ? sample.build() : null;
        }

        @Override
        public final Builder sample(Sample sample) {
            this.sample = sample;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getSessionStatus() {
            return sessionStatus;
        }

        public final void setSessionStatus(String sessionStatus) {
            this.sessionStatus = sessionStatus;
        }

        @Override
        public final Builder sessionStatus(String sessionStatus) {
            this.sessionStatus = sessionStatus;
            return this;
        }

        @Override
        public final Builder sessionStatus(SessionStatus sessionStatus) {
            this.sessionStatus(sessionStatus == null ? null : sessionStatus.toString());
            return this;
        }

        public final String getOpenedBy() {
            return openedBy;
        }

        public final void setOpenedBy(String openedBy) {
            this.openedBy = openedBy;
        }

        @Override
        public final Builder openedBy(String openedBy) {
            this.openedBy = openedBy;
            return this;
        }

        public final Instant getOpenDate() {
            return openDate;
        }

        public final void setOpenDate(Instant openDate) {
            this.openDate = openDate;
        }

        @Override
        public final Builder openDate(Instant openDate) {
            this.openDate = openDate;
            return this;
        }

        @Override
        public DescribeProjectResponse build() {
            return new DescribeProjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
