/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.databrew.model.DataBrewResponse;
import software.amazon.awssdk.services.databrew.model.DataCatalogOutput;
import software.amazon.awssdk.services.databrew.model.DataCatalogOutputListCopier;
import software.amazon.awssdk.services.databrew.model.DatabaseOutput;
import software.amazon.awssdk.services.databrew.model.DatabaseOutputListCopier;
import software.amazon.awssdk.services.databrew.model.EncryptionMode;
import software.amazon.awssdk.services.databrew.model.JobSample;
import software.amazon.awssdk.services.databrew.model.JobType;
import software.amazon.awssdk.services.databrew.model.LogSubscription;
import software.amazon.awssdk.services.databrew.model.Output;
import software.amazon.awssdk.services.databrew.model.OutputListCopier;
import software.amazon.awssdk.services.databrew.model.ProfileConfiguration;
import software.amazon.awssdk.services.databrew.model.RecipeReference;
import software.amazon.awssdk.services.databrew.model.TagMapCopier;
import software.amazon.awssdk.services.databrew.model.ValidationConfiguration;
import software.amazon.awssdk.services.databrew.model.ValidationConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeJobResponse
extends DataBrewResponse
implements ToCopyableBuilder<Builder, DescribeJobResponse> {
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(DescribeJobResponse.getter(DescribeJobResponse::createDate)).setter(DescribeJobResponse.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(DescribeJobResponse.getter(DescribeJobResponse::createdBy)).setter(DescribeJobResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetName").getter(DescribeJobResponse.getter(DescribeJobResponse::datasetName)).setter(DescribeJobResponse.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyArn").getter(DescribeJobResponse.getter(DescribeJobResponse::encryptionKeyArn)).setter(DescribeJobResponse.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()}).build();
    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionMode").getter(DescribeJobResponse.getter(DescribeJobResponse::encryptionModeAsString)).setter(DescribeJobResponse.setter(Builder::encryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionMode").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeJobResponse.getter(DescribeJobResponse::name)).setter(DescribeJobResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DescribeJobResponse.getter(DescribeJobResponse::typeAsString)).setter(DescribeJobResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedBy").getter(DescribeJobResponse.getter(DescribeJobResponse::lastModifiedBy)).setter(DescribeJobResponse.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(DescribeJobResponse.getter(DescribeJobResponse::lastModifiedDate)).setter(DescribeJobResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> LOG_SUBSCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogSubscription").getter(DescribeJobResponse.getter(DescribeJobResponse::logSubscriptionAsString)).setter(DescribeJobResponse.setter(Builder::logSubscription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogSubscription").build()}).build();
    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxCapacity").getter(DescribeJobResponse.getter(DescribeJobResponse::maxCapacity)).setter(DescribeJobResponse.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<Integer> MAX_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRetries").getter(DescribeJobResponse.getter(DescribeJobResponse::maxRetries)).setter(DescribeJobResponse.setter(Builder::maxRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetries").build()}).build();
    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Outputs").getter(DescribeJobResponse.getter(DescribeJobResponse::outputs)).setter(DescribeJobResponse.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Output::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataCatalogOutput>> DATA_CATALOG_OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataCatalogOutputs").getter(DescribeJobResponse.getter(DescribeJobResponse::dataCatalogOutputs)).setter(DescribeJobResponse.setter(Builder::dataCatalogOutputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCatalogOutputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataCatalogOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DatabaseOutput>> DATABASE_OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DatabaseOutputs").getter(DescribeJobResponse.getter(DescribeJobResponse::databaseOutputs)).setter(DescribeJobResponse.setter(Builder::databaseOutputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseOutputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatabaseOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectName").getter(DescribeJobResponse.getter(DescribeJobResponse::projectName)).setter(DescribeJobResponse.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()}).build();
    private static final SdkField<ProfileConfiguration> PROFILE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProfileConfiguration").getter(DescribeJobResponse.getter(DescribeJobResponse::profileConfiguration)).setter(DescribeJobResponse.setter(Builder::profileConfiguration)).constructor(ProfileConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileConfiguration").build()}).build();
    private static final SdkField<List<ValidationConfiguration>> VALIDATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidationConfigurations").getter(DescribeJobResponse.getter(DescribeJobResponse::validationConfigurations)).setter(DescribeJobResponse.setter(Builder::validationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RecipeReference> RECIPE_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecipeReference").getter(DescribeJobResponse.getter(DescribeJobResponse::recipeReference)).setter(DescribeJobResponse.setter(Builder::recipeReference)).constructor(RecipeReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeReference").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(DescribeJobResponse.getter(DescribeJobResponse::resourceArn)).setter(DescribeJobResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeJobResponse.getter(DescribeJobResponse::roleArn)).setter(DescribeJobResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribeJobResponse.getter(DescribeJobResponse::tags)).setter(DescribeJobResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(DescribeJobResponse.getter(DescribeJobResponse::timeout)).setter(DescribeJobResponse.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<JobSample> JOB_SAMPLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobSample").getter(DescribeJobResponse.getter(DescribeJobResponse::jobSample)).setter(DescribeJobResponse.setter(Builder::jobSample)).constructor(JobSample::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobSample").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_DATE_FIELD, CREATED_BY_FIELD, DATASET_NAME_FIELD, ENCRYPTION_KEY_ARN_FIELD, ENCRYPTION_MODE_FIELD, NAME_FIELD, TYPE_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_DATE_FIELD, LOG_SUBSCRIPTION_FIELD, MAX_CAPACITY_FIELD, MAX_RETRIES_FIELD, OUTPUTS_FIELD, DATA_CATALOG_OUTPUTS_FIELD, DATABASE_OUTPUTS_FIELD, PROJECT_NAME_FIELD, PROFILE_CONFIGURATION_FIELD, VALIDATION_CONFIGURATIONS_FIELD, RECIPE_REFERENCE_FIELD, RESOURCE_ARN_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, TIMEOUT_FIELD, JOB_SAMPLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CreateDate", CREATE_DATE_FIELD);
            this.put("CreatedBy", CREATED_BY_FIELD);
            this.put("DatasetName", DATASET_NAME_FIELD);
            this.put("EncryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
            this.put("EncryptionMode", ENCRYPTION_MODE_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
            this.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
            this.put("LogSubscription", LOG_SUBSCRIPTION_FIELD);
            this.put("MaxCapacity", MAX_CAPACITY_FIELD);
            this.put("MaxRetries", MAX_RETRIES_FIELD);
            this.put("Outputs", OUTPUTS_FIELD);
            this.put("DataCatalogOutputs", DATA_CATALOG_OUTPUTS_FIELD);
            this.put("DatabaseOutputs", DATABASE_OUTPUTS_FIELD);
            this.put("ProjectName", PROJECT_NAME_FIELD);
            this.put("ProfileConfiguration", PROFILE_CONFIGURATION_FIELD);
            this.put("ValidationConfigurations", VALIDATION_CONFIGURATIONS_FIELD);
            this.put("RecipeReference", RECIPE_REFERENCE_FIELD);
            this.put("ResourceArn", RESOURCE_ARN_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("Timeout", TIMEOUT_FIELD);
            this.put("JobSample", JOB_SAMPLE_FIELD);
        }
    });
    private final Instant createDate;
    private final String createdBy;
    private final String datasetName;
    private final String encryptionKeyArn;
    private final String encryptionMode;
    private final String name;
    private final String type;
    private final String lastModifiedBy;
    private final Instant lastModifiedDate;
    private final String logSubscription;
    private final Integer maxCapacity;
    private final Integer maxRetries;
    private final List<Output> outputs;
    private final List<DataCatalogOutput> dataCatalogOutputs;
    private final List<DatabaseOutput> databaseOutputs;
    private final String projectName;
    private final ProfileConfiguration profileConfiguration;
    private final List<ValidationConfiguration> validationConfigurations;
    private final RecipeReference recipeReference;
    private final String resourceArn;
    private final String roleArn;
    private final Map<String, String> tags;
    private final Integer timeout;
    private final JobSample jobSample;

    private DescribeJobResponse(BuilderImpl builder) {
        super(builder);
        this.createDate = builder.createDate;
        this.createdBy = builder.createdBy;
        this.datasetName = builder.datasetName;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.encryptionMode = builder.encryptionMode;
        this.name = builder.name;
        this.type = builder.type;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.logSubscription = builder.logSubscription;
        this.maxCapacity = builder.maxCapacity;
        this.maxRetries = builder.maxRetries;
        this.outputs = builder.outputs;
        this.dataCatalogOutputs = builder.dataCatalogOutputs;
        this.databaseOutputs = builder.databaseOutputs;
        this.projectName = builder.projectName;
        this.profileConfiguration = builder.profileConfiguration;
        this.validationConfigurations = builder.validationConfigurations;
        this.recipeReference = builder.recipeReference;
        this.resourceArn = builder.resourceArn;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.timeout = builder.timeout;
        this.jobSample = builder.jobSample;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public final EncryptionMode encryptionMode() {
        return EncryptionMode.fromValue(this.encryptionMode);
    }

    public final String encryptionModeAsString() {
        return this.encryptionMode;
    }

    public final String name() {
        return this.name;
    }

    public final JobType type() {
        return JobType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final LogSubscription logSubscription() {
        return LogSubscription.fromValue(this.logSubscription);
    }

    public final String logSubscriptionAsString() {
        return this.logSubscription;
    }

    public final Integer maxCapacity() {
        return this.maxCapacity;
    }

    public final Integer maxRetries() {
        return this.maxRetries;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<Output> outputs() {
        return this.outputs;
    }

    public final boolean hasDataCatalogOutputs() {
        return this.dataCatalogOutputs != null && !(this.dataCatalogOutputs instanceof SdkAutoConstructList);
    }

    public final List<DataCatalogOutput> dataCatalogOutputs() {
        return this.dataCatalogOutputs;
    }

    public final boolean hasDatabaseOutputs() {
        return this.databaseOutputs != null && !(this.databaseOutputs instanceof SdkAutoConstructList);
    }

    public final List<DatabaseOutput> databaseOutputs() {
        return this.databaseOutputs;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final ProfileConfiguration profileConfiguration() {
        return this.profileConfiguration;
    }

    public final boolean hasValidationConfigurations() {
        return this.validationConfigurations != null && !(this.validationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ValidationConfiguration> validationConfigurations() {
        return this.validationConfigurations;
    }

    public final RecipeReference recipeReference() {
        return this.recipeReference;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    public final JobSample jobSample() {
        return this.jobSample;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.logSubscriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataCatalogOutputs() ? this.dataCatalogOutputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatabaseOutputs() ? this.databaseOutputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidationConfigurations() ? this.validationConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobSample());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobResponse)) {
            return false;
        }
        DescribeJobResponse other = (DescribeJobResponse)((Object)obj);
        return Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(this.encryptionModeAsString(), other.encryptionModeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.logSubscriptionAsString(), other.logSubscriptionAsString()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.maxRetries(), other.maxRetries()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && this.hasDataCatalogOutputs() == other.hasDataCatalogOutputs() && Objects.equals(this.dataCatalogOutputs(), other.dataCatalogOutputs()) && this.hasDatabaseOutputs() == other.hasDatabaseOutputs() && Objects.equals(this.databaseOutputs(), other.databaseOutputs()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.profileConfiguration(), other.profileConfiguration()) && this.hasValidationConfigurations() == other.hasValidationConfigurations() && Objects.equals(this.validationConfigurations(), other.validationConfigurations()) && Objects.equals(this.recipeReference(), other.recipeReference()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.jobSample(), other.jobSample());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeJobResponse").add("CreateDate", (Object)this.createDate()).add("CreatedBy", (Object)this.createdBy()).add("DatasetName", (Object)this.datasetName()).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("EncryptionMode", (Object)this.encryptionModeAsString()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("LogSubscription", (Object)this.logSubscriptionAsString()).add("MaxCapacity", (Object)this.maxCapacity()).add("MaxRetries", (Object)this.maxRetries()).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("DataCatalogOutputs", this.hasDataCatalogOutputs() ? this.dataCatalogOutputs() : null).add("DatabaseOutputs", this.hasDatabaseOutputs() ? this.databaseOutputs() : null).add("ProjectName", (Object)this.projectName()).add("ProfileConfiguration", (Object)this.profileConfiguration()).add("ValidationConfigurations", this.hasValidationConfigurations() ? this.validationConfigurations() : null).add("RecipeReference", (Object)this.recipeReference()).add("ResourceArn", (Object)this.resourceArn()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).add("Timeout", (Object)this.timeout()).add("JobSample", (Object)this.jobSample()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "EncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "EncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.encryptionModeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "LogSubscription": {
                return Optional.ofNullable(clazz.cast(this.logSubscriptionAsString()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "MaxRetries": {
                return Optional.ofNullable(clazz.cast(this.maxRetries()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "DataCatalogOutputs": {
                return Optional.ofNullable(clazz.cast(this.dataCatalogOutputs()));
            }
            case "DatabaseOutputs": {
                return Optional.ofNullable(clazz.cast(this.databaseOutputs()));
            }
            case "ProjectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "ProfileConfiguration": {
                return Optional.ofNullable(clazz.cast(this.profileConfiguration()));
            }
            case "ValidationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.validationConfigurations()));
            }
            case "RecipeReference": {
                return Optional.ofNullable(clazz.cast(this.recipeReference()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "JobSample": {
                return Optional.ofNullable(clazz.cast(this.jobSample()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobResponse, T> g) {
        return obj -> g.apply((DescribeJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataBrewResponse.BuilderImpl
    implements Builder {
        private Instant createDate;
        private String createdBy;
        private String datasetName;
        private String encryptionKeyArn;
        private String encryptionMode;
        private String name;
        private String type;
        private String lastModifiedBy;
        private Instant lastModifiedDate;
        private String logSubscription;
        private Integer maxCapacity;
        private Integer maxRetries;
        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();
        private List<DataCatalogOutput> dataCatalogOutputs = DefaultSdkAutoConstructList.getInstance();
        private List<DatabaseOutput> databaseOutputs = DefaultSdkAutoConstructList.getInstance();
        private String projectName;
        private ProfileConfiguration profileConfiguration;
        private List<ValidationConfiguration> validationConfigurations = DefaultSdkAutoConstructList.getInstance();
        private RecipeReference recipeReference;
        private String resourceArn;
        private String roleArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Integer timeout;
        private JobSample jobSample;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobResponse model) {
            super(model);
            this.createDate(model.createDate);
            this.createdBy(model.createdBy);
            this.datasetName(model.datasetName);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.encryptionMode(model.encryptionMode);
            this.name(model.name);
            this.type(model.type);
            this.lastModifiedBy(model.lastModifiedBy);
            this.lastModifiedDate(model.lastModifiedDate);
            this.logSubscription(model.logSubscription);
            this.maxCapacity(model.maxCapacity);
            this.maxRetries(model.maxRetries);
            this.outputs(model.outputs);
            this.dataCatalogOutputs(model.dataCatalogOutputs);
            this.databaseOutputs(model.databaseOutputs);
            this.projectName(model.projectName);
            this.profileConfiguration(model.profileConfiguration);
            this.validationConfigurations(model.validationConfigurations);
            this.recipeReference(model.recipeReference);
            this.resourceArn(model.resourceArn);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
            this.timeout(model.timeout);
            this.jobSample(model.jobSample);
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getEncryptionMode() {
            return this.encryptionMode;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        @Override
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        @Override
        public final Builder encryptionMode(EncryptionMode encryptionMode) {
            this.encryptionMode(encryptionMode == null ? null : encryptionMode.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(JobType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getLogSubscription() {
            return this.logSubscription;
        }

        public final void setLogSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
        }

        @Override
        public final Builder logSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
            return this;
        }

        @Override
        public final Builder logSubscription(LogSubscription logSubscription) {
            this.logSubscription(logSubscription == null ? null : logSubscription.toString());
            return this;
        }

        public final Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final Integer getMaxRetries() {
            return this.maxRetries;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        @Override
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final List<Output.Builder> getOutputs() {
            List<Output.Builder> result = OutputListCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = OutputListCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputListCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (Output)((Output.Builder)Output.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataCatalogOutput.Builder> getDataCatalogOutputs() {
            List<DataCatalogOutput.Builder> result = DataCatalogOutputListCopier.copyToBuilder(this.dataCatalogOutputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataCatalogOutputs(Collection<DataCatalogOutput.BuilderImpl> dataCatalogOutputs) {
            this.dataCatalogOutputs = DataCatalogOutputListCopier.copyFromBuilder(dataCatalogOutputs);
        }

        @Override
        public final Builder dataCatalogOutputs(Collection<DataCatalogOutput> dataCatalogOutputs) {
            this.dataCatalogOutputs = DataCatalogOutputListCopier.copy(dataCatalogOutputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataCatalogOutputs(DataCatalogOutput ... dataCatalogOutputs) {
            this.dataCatalogOutputs(Arrays.asList(dataCatalogOutputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataCatalogOutputs(Consumer<DataCatalogOutput.Builder> ... dataCatalogOutputs) {
            this.dataCatalogOutputs(Stream.of(dataCatalogOutputs).map(c -> (DataCatalogOutput)((DataCatalogOutput.Builder)DataCatalogOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DatabaseOutput.Builder> getDatabaseOutputs() {
            List<DatabaseOutput.Builder> result = DatabaseOutputListCopier.copyToBuilder(this.databaseOutputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatabaseOutputs(Collection<DatabaseOutput.BuilderImpl> databaseOutputs) {
            this.databaseOutputs = DatabaseOutputListCopier.copyFromBuilder(databaseOutputs);
        }

        @Override
        public final Builder databaseOutputs(Collection<DatabaseOutput> databaseOutputs) {
            this.databaseOutputs = DatabaseOutputListCopier.copy(databaseOutputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databaseOutputs(DatabaseOutput ... databaseOutputs) {
            this.databaseOutputs(Arrays.asList(databaseOutputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databaseOutputs(Consumer<DatabaseOutput.Builder> ... databaseOutputs) {
            this.databaseOutputs(Stream.of(databaseOutputs).map(c -> (DatabaseOutput)((DatabaseOutput.Builder)DatabaseOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final ProfileConfiguration.Builder getProfileConfiguration() {
            return this.profileConfiguration != null ? this.profileConfiguration.toBuilder() : null;
        }

        public final void setProfileConfiguration(ProfileConfiguration.BuilderImpl profileConfiguration) {
            this.profileConfiguration = profileConfiguration != null ? profileConfiguration.build() : null;
        }

        @Override
        public final Builder profileConfiguration(ProfileConfiguration profileConfiguration) {
            this.profileConfiguration = profileConfiguration;
            return this;
        }

        public final List<ValidationConfiguration.Builder> getValidationConfigurations() {
            List<ValidationConfiguration.Builder> result = ValidationConfigurationListCopier.copyToBuilder(this.validationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidationConfigurations(Collection<ValidationConfiguration.BuilderImpl> validationConfigurations) {
            this.validationConfigurations = ValidationConfigurationListCopier.copyFromBuilder(validationConfigurations);
        }

        @Override
        public final Builder validationConfigurations(Collection<ValidationConfiguration> validationConfigurations) {
            this.validationConfigurations = ValidationConfigurationListCopier.copy(validationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationConfigurations(ValidationConfiguration ... validationConfigurations) {
            this.validationConfigurations(Arrays.asList(validationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationConfigurations(Consumer<ValidationConfiguration.Builder> ... validationConfigurations) {
            this.validationConfigurations(Stream.of(validationConfigurations).map(c -> (ValidationConfiguration)((ValidationConfiguration.Builder)ValidationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RecipeReference.Builder getRecipeReference() {
            return this.recipeReference != null ? this.recipeReference.toBuilder() : null;
        }

        public final void setRecipeReference(RecipeReference.BuilderImpl recipeReference) {
            this.recipeReference = recipeReference != null ? recipeReference.build() : null;
        }

        @Override
        public final Builder recipeReference(RecipeReference recipeReference) {
            this.recipeReference = recipeReference;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final JobSample.Builder getJobSample() {
            return this.jobSample != null ? this.jobSample.toBuilder() : null;
        }

        public final void setJobSample(JobSample.BuilderImpl jobSample) {
            this.jobSample = jobSample != null ? jobSample.build() : null;
        }

        @Override
        public final Builder jobSample(JobSample jobSample) {
            this.jobSample = jobSample;
            return this;
        }

        @Override
        public DescribeJobResponse build() {
            return new DescribeJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataBrewResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeJobResponse> {
        public Builder createDate(Instant var1);

        public Builder createdBy(String var1);

        public Builder datasetName(String var1);

        public Builder encryptionKeyArn(String var1);

        public Builder encryptionMode(String var1);

        public Builder encryptionMode(EncryptionMode var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(JobType var1);

        public Builder lastModifiedBy(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder logSubscription(String var1);

        public Builder logSubscription(LogSubscription var1);

        public Builder maxCapacity(Integer var1);

        public Builder maxRetries(Integer var1);

        public Builder outputs(Collection<Output> var1);

        public Builder outputs(Output ... var1);

        public Builder outputs(Consumer<Output.Builder> ... var1);

        public Builder dataCatalogOutputs(Collection<DataCatalogOutput> var1);

        public Builder dataCatalogOutputs(DataCatalogOutput ... var1);

        public Builder dataCatalogOutputs(Consumer<DataCatalogOutput.Builder> ... var1);

        public Builder databaseOutputs(Collection<DatabaseOutput> var1);

        public Builder databaseOutputs(DatabaseOutput ... var1);

        public Builder databaseOutputs(Consumer<DatabaseOutput.Builder> ... var1);

        public Builder projectName(String var1);

        public Builder profileConfiguration(ProfileConfiguration var1);

        default public Builder profileConfiguration(Consumer<ProfileConfiguration.Builder> profileConfiguration) {
            return this.profileConfiguration((ProfileConfiguration)((ProfileConfiguration.Builder)ProfileConfiguration.builder().applyMutation(profileConfiguration)).build());
        }

        public Builder validationConfigurations(Collection<ValidationConfiguration> var1);

        public Builder validationConfigurations(ValidationConfiguration ... var1);

        public Builder validationConfigurations(Consumer<ValidationConfiguration.Builder> ... var1);

        public Builder recipeReference(RecipeReference var1);

        default public Builder recipeReference(Consumer<RecipeReference.Builder> recipeReference) {
            return this.recipeReference((RecipeReference)((RecipeReference.Builder)RecipeReference.builder().applyMutation(recipeReference)).build());
        }

        public Builder resourceArn(String var1);

        public Builder roleArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder timeout(Integer var1);

        public Builder jobSample(JobSample var1);

        default public Builder jobSample(Consumer<JobSample.Builder> jobSample) {
            return this.jobSample((JobSample)((JobSample.Builder)JobSample.builder().applyMutation(jobSample)).build());
        }
    }
}

