/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databrew.model.StatisticListCopier;
import software.amazon.awssdk.services.databrew.model.StatisticOverride;
import software.amazon.awssdk.services.databrew.model.StatisticOverrideListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StatisticsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StatisticsConfiguration> {
    private static final SdkField<List<String>> INCLUDED_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludedStatistics").getter(StatisticsConfiguration.getter(StatisticsConfiguration::includedStatistics)).setter(StatisticsConfiguration.setter(Builder::includedStatistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedStatistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StatisticOverride>> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Overrides").getter(StatisticsConfiguration.getter(StatisticsConfiguration::overrides)).setter(StatisticsConfiguration.setter(Builder::overrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StatisticOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDED_STATISTICS_FIELD, OVERRIDES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IncludedStatistics", INCLUDED_STATISTICS_FIELD);
            this.put("Overrides", OVERRIDES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> includedStatistics;
    private final List<StatisticOverride> overrides;

    private StatisticsConfiguration(BuilderImpl builder) {
        this.includedStatistics = builder.includedStatistics;
        this.overrides = builder.overrides;
    }

    public final boolean hasIncludedStatistics() {
        return this.includedStatistics != null && !(this.includedStatistics instanceof SdkAutoConstructList);
    }

    public final List<String> includedStatistics() {
        return this.includedStatistics;
    }

    public final boolean hasOverrides() {
        return this.overrides != null && !(this.overrides instanceof SdkAutoConstructList);
    }

    public final List<StatisticOverride> overrides() {
        return this.overrides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludedStatistics() ? this.includedStatistics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOverrides() ? this.overrides() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatisticsConfiguration)) {
            return false;
        }
        StatisticsConfiguration other = (StatisticsConfiguration)obj;
        return this.hasIncludedStatistics() == other.hasIncludedStatistics() && Objects.equals(this.includedStatistics(), other.includedStatistics()) && this.hasOverrides() == other.hasOverrides() && Objects.equals(this.overrides(), other.overrides());
    }

    public final String toString() {
        return ToString.builder((String)"StatisticsConfiguration").add("IncludedStatistics", this.hasIncludedStatistics() ? this.includedStatistics() : null).add("Overrides", this.hasOverrides() ? this.overrides() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IncludedStatistics": {
                return Optional.ofNullable(clazz.cast(this.includedStatistics()));
            }
            case "Overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StatisticsConfiguration, T> g) {
        return obj -> g.apply((StatisticsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> includedStatistics = DefaultSdkAutoConstructList.getInstance();
        private List<StatisticOverride> overrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StatisticsConfiguration model) {
            this.includedStatistics(model.includedStatistics);
            this.overrides(model.overrides);
        }

        public final Collection<String> getIncludedStatistics() {
            if (this.includedStatistics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includedStatistics;
        }

        public final void setIncludedStatistics(Collection<String> includedStatistics) {
            this.includedStatistics = StatisticListCopier.copy(includedStatistics);
        }

        @Override
        public final Builder includedStatistics(Collection<String> includedStatistics) {
            this.includedStatistics = StatisticListCopier.copy(includedStatistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedStatistics(String ... includedStatistics) {
            this.includedStatistics(Arrays.asList(includedStatistics));
            return this;
        }

        public final List<StatisticOverride.Builder> getOverrides() {
            List<StatisticOverride.Builder> result = StatisticOverrideListCopier.copyToBuilder(this.overrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOverrides(Collection<StatisticOverride.BuilderImpl> overrides) {
            this.overrides = StatisticOverrideListCopier.copyFromBuilder(overrides);
        }

        @Override
        public final Builder overrides(Collection<StatisticOverride> overrides) {
            this.overrides = StatisticOverrideListCopier.copy(overrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(StatisticOverride ... overrides) {
            this.overrides(Arrays.asList(overrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(Consumer<StatisticOverride.Builder> ... overrides) {
            this.overrides(Stream.of(overrides).map(c -> (StatisticOverride)((StatisticOverride.Builder)StatisticOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public StatisticsConfiguration build() {
            return new StatisticsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StatisticsConfiguration> {
        public Builder includedStatistics(Collection<String> var1);

        public Builder includedStatistics(String ... var1);

        public Builder overrides(Collection<StatisticOverride> var1);

        public Builder overrides(StatisticOverride ... var1);

        public Builder overrides(Consumer<StatisticOverride.Builder> ... var1);
    }
}

