/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartProjectSessionRequest extends DataBrewRequest implements
        ToCopyableBuilder<StartProjectSessionRequest.Builder, StartProjectSessionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(StartProjectSessionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<Boolean> ASSUME_CONTROL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AssumeControl").getter(getter(StartProjectSessionRequest::assumeControl))
            .setter(setter(Builder::assumeControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssumeControl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            ASSUME_CONTROL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final Boolean assumeControl;

    private StartProjectSessionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.assumeControl = builder.assumeControl;
    }

    /**
     * <p>
     * The name of the project to act upon.
     * </p>
     * 
     * @return The name of the project to act upon.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A value that, if true, enables you to take control of a session, even if a different client is currently
     * accessing the project.
     * </p>
     * 
     * @return A value that, if true, enables you to take control of a session, even if a different client is currently
     *         accessing the project.
     */
    public final Boolean assumeControl() {
        return assumeControl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(assumeControl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartProjectSessionRequest)) {
            return false;
        }
        StartProjectSessionRequest other = (StartProjectSessionRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(assumeControl(), other.assumeControl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartProjectSessionRequest").add("Name", name()).add("AssumeControl", assumeControl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AssumeControl":
            return Optional.ofNullable(clazz.cast(assumeControl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("AssumeControl", ASSUME_CONTROL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartProjectSessionRequest, T> g) {
        return obj -> g.apply((StartProjectSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataBrewRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartProjectSessionRequest> {
        /**
         * <p>
         * The name of the project to act upon.
         * </p>
         * 
         * @param name
         *        The name of the project to act upon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A value that, if true, enables you to take control of a session, even if a different client is currently
         * accessing the project.
         * </p>
         * 
         * @param assumeControl
         *        A value that, if true, enables you to take control of a session, even if a different client is
         *        currently accessing the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assumeControl(Boolean assumeControl);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataBrewRequest.BuilderImpl implements Builder {
        private String name;

        private Boolean assumeControl;

        private BuilderImpl() {
        }

        private BuilderImpl(StartProjectSessionRequest model) {
            super(model);
            name(model.name);
            assumeControl(model.assumeControl);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getAssumeControl() {
            return assumeControl;
        }

        public final void setAssumeControl(Boolean assumeControl) {
            this.assumeControl = assumeControl;
        }

        @Override
        public final Builder assumeControl(Boolean assumeControl) {
            this.assumeControl = assumeControl;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartProjectSessionRequest build() {
            return new StartProjectSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
