/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.databrew.model.DataBrewResponse;
import software.amazon.awssdk.services.databrew.model.FormatOptions;
import software.amazon.awssdk.services.databrew.model.Input;
import software.amazon.awssdk.services.databrew.model.InputFormat;
import software.amazon.awssdk.services.databrew.model.PathOptions;
import software.amazon.awssdk.services.databrew.model.Source;
import software.amazon.awssdk.services.databrew.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDatasetResponse
extends DataBrewResponse
implements ToCopyableBuilder<Builder, DescribeDatasetResponse> {
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::createdBy)).setter(DescribeDatasetResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::createDate)).setter(DescribeDatasetResponse.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::name)).setter(DescribeDatasetResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::formatAsString)).setter(DescribeDatasetResponse.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<FormatOptions> FORMAT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FormatOptions").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::formatOptions)).setter(DescribeDatasetResponse.setter(Builder::formatOptions)).constructor(FormatOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatOptions").build()}).build();
    private static final SdkField<Input> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Input").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::input)).setter(DescribeDatasetResponse.setter(Builder::input)).constructor(Input::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::lastModifiedDate)).setter(DescribeDatasetResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedBy").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::lastModifiedBy)).setter(DescribeDatasetResponse.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::sourceAsString)).setter(DescribeDatasetResponse.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<PathOptions> PATH_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PathOptions").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::pathOptions)).setter(DescribeDatasetResponse.setter(Builder::pathOptions)).constructor(PathOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathOptions").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::tags)).setter(DescribeDatasetResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(DescribeDatasetResponse.getter(DescribeDatasetResponse::resourceArn)).setter(DescribeDatasetResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_BY_FIELD, CREATE_DATE_FIELD, NAME_FIELD, FORMAT_FIELD, FORMAT_OPTIONS_FIELD, INPUT_FIELD, LAST_MODIFIED_DATE_FIELD, LAST_MODIFIED_BY_FIELD, SOURCE_FIELD, PATH_OPTIONS_FIELD, TAGS_FIELD, RESOURCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDatasetResponse.memberNameToFieldInitializer();
    private final String createdBy;
    private final Instant createDate;
    private final String name;
    private final String format;
    private final FormatOptions formatOptions;
    private final Input input;
    private final Instant lastModifiedDate;
    private final String lastModifiedBy;
    private final String source;
    private final PathOptions pathOptions;
    private final Map<String, String> tags;
    private final String resourceArn;

    private DescribeDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.createdBy = builder.createdBy;
        this.createDate = builder.createDate;
        this.name = builder.name;
        this.format = builder.format;
        this.formatOptions = builder.formatOptions;
        this.input = builder.input;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.source = builder.source;
        this.pathOptions = builder.pathOptions;
        this.tags = builder.tags;
        this.resourceArn = builder.resourceArn;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final String name() {
        return this.name;
    }

    public final InputFormat format() {
        return InputFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final FormatOptions formatOptions() {
        return this.formatOptions;
    }

    public final Input input() {
        return this.input;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final Source source() {
        return Source.fromValue(this.source);
    }

    public final String sourceAsString() {
        return this.source;
    }

    public final PathOptions pathOptions() {
        return this.pathOptions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetResponse)) {
            return false;
        }
        DescribeDatasetResponse other = (DescribeDatasetResponse)((Object)obj);
        return Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.formatOptions(), other.formatOptions()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.sourceAsString(), other.sourceAsString()) && Objects.equals(this.pathOptions(), other.pathOptions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.resourceArn(), other.resourceArn());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDatasetResponse").add("CreatedBy", (Object)this.createdBy()).add("CreateDate", (Object)this.createDate()).add("Name", (Object)this.name()).add("Format", (Object)this.formatAsString()).add("FormatOptions", (Object)this.formatOptions()).add("Input", (Object)this.input()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("Source", (Object)this.sourceAsString()).add("PathOptions", (Object)this.pathOptions()).add("Tags", this.hasTags() ? this.tags() : null).add("ResourceArn", (Object)this.resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "FormatOptions": {
                return Optional.ofNullable(clazz.cast(this.formatOptions()));
            }
            case "Input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
            case "PathOptions": {
                return Optional.ofNullable(clazz.cast(this.pathOptions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Format", FORMAT_FIELD);
        map.put("FormatOptions", FORMAT_OPTIONS_FIELD);
        map.put("Input", INPUT_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("PathOptions", PATH_OPTIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetResponse, T> g) {
        return obj -> g.apply((DescribeDatasetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataBrewResponse.BuilderImpl
    implements Builder {
        private String createdBy;
        private Instant createDate;
        private String name;
        private String format;
        private FormatOptions formatOptions;
        private Input input;
        private Instant lastModifiedDate;
        private String lastModifiedBy;
        private String source;
        private PathOptions pathOptions;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetResponse model) {
            super(model);
            this.createdBy(model.createdBy);
            this.createDate(model.createDate);
            this.name(model.name);
            this.format(model.format);
            this.formatOptions(model.formatOptions);
            this.input(model.input);
            this.lastModifiedDate(model.lastModifiedDate);
            this.lastModifiedBy(model.lastModifiedBy);
            this.source(model.source);
            this.pathOptions(model.pathOptions);
            this.tags(model.tags);
            this.resourceArn(model.resourceArn);
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(InputFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final FormatOptions.Builder getFormatOptions() {
            return this.formatOptions != null ? this.formatOptions.toBuilder() : null;
        }

        public final void setFormatOptions(FormatOptions.BuilderImpl formatOptions) {
            this.formatOptions = formatOptions != null ? formatOptions.build() : null;
        }

        @Override
        public final Builder formatOptions(FormatOptions formatOptions) {
            this.formatOptions = formatOptions;
            return this;
        }

        public final Input.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        public final void setInput(Input.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(Input input) {
            this.input = input;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(Source source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final PathOptions.Builder getPathOptions() {
            return this.pathOptions != null ? this.pathOptions.toBuilder() : null;
        }

        public final void setPathOptions(PathOptions.BuilderImpl pathOptions) {
            this.pathOptions = pathOptions != null ? pathOptions.build() : null;
        }

        @Override
        public final Builder pathOptions(PathOptions pathOptions) {
            this.pathOptions = pathOptions;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public DescribeDatasetResponse build() {
            return new DescribeDatasetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataBrewResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDatasetResponse> {
        public Builder createdBy(String var1);

        public Builder createDate(Instant var1);

        public Builder name(String var1);

        public Builder format(String var1);

        public Builder format(InputFormat var1);

        public Builder formatOptions(FormatOptions var1);

        default public Builder formatOptions(Consumer<FormatOptions.Builder> formatOptions) {
            return this.formatOptions((FormatOptions)((FormatOptions.Builder)FormatOptions.builder().applyMutation(formatOptions)).build());
        }

        public Builder input(Input var1);

        default public Builder input(Consumer<Input.Builder> input) {
            return this.input((Input)((Input.Builder)Input.builder().applyMutation(input)).build());
        }

        public Builder lastModifiedDate(Instant var1);

        public Builder lastModifiedBy(String var1);

        public Builder source(String var1);

        public Builder source(Source var1);

        public Builder pathOptions(PathOptions var1);

        default public Builder pathOptions(Consumer<PathOptions.Builder> pathOptions) {
            return this.pathOptions((PathOptions)((PathOptions.Builder)PathOptions.builder().applyMutation(pathOptions)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder resourceArn(String var1);
    }
}

