/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databrew.model.ThresholdType;
import software.amazon.awssdk.services.databrew.model.ThresholdUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Threshold
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Threshold> {
    private static final SdkField<Double> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Value").getter(Threshold.getter(Threshold::value)).setter(Threshold.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Threshold.getter(Threshold::typeAsString)).setter(Threshold.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(Threshold.getter(Threshold::unitAsString)).setter(Threshold.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TYPE_FIELD, UNIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Threshold.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double value;
    private final String type;
    private final String unit;

    private Threshold(BuilderImpl builder) {
        this.value = builder.value;
        this.type = builder.type;
        this.unit = builder.unit;
    }

    public final Double value() {
        return this.value;
    }

    public final ThresholdType type() {
        return ThresholdType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final ThresholdUnit unit() {
        return ThresholdUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Threshold)) {
            return false;
        }
        Threshold other = (Threshold)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.unitAsString(), other.unitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Threshold").add("Value", (Object)this.value()).add("Type", (Object)this.typeAsString()).add("Unit", (Object)this.unitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Value", VALUE_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Unit", UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Threshold, T> g) {
        return obj -> g.apply((Threshold)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double value;
        private String type;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(Threshold model) {
            this.value(model.value);
            this.type(model.type);
            this.unit(model.unit);
        }

        public final Double getValue() {
            return this.value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ThresholdType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(ThresholdUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public Threshold build() {
            return new Threshold(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Threshold> {
        public Builder value(Double var1);

        public Builder type(String var1);

        public Builder type(ThresholdType var1);

        public Builder unit(String var1);

        public Builder unit(ThresholdUnit var1);
    }
}

