/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databrew.model.DatabaseTableOutputOptions;
import software.amazon.awssdk.services.databrew.model.S3TableOutputOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataCatalogOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataCatalogOutput> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(DataCatalogOutput.getter(DataCatalogOutput::catalogId)).setter(DataCatalogOutput.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(DataCatalogOutput.getter(DataCatalogOutput::databaseName)).setter(DataCatalogOutput.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(DataCatalogOutput.getter(DataCatalogOutput::tableName)).setter(DataCatalogOutput.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<S3TableOutputOptions> S3_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Options").getter(DataCatalogOutput.getter(DataCatalogOutput::s3Options)).setter(DataCatalogOutput.setter(Builder::s3Options)).constructor(S3TableOutputOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Options").build()}).build();
    private static final SdkField<DatabaseTableOutputOptions> DATABASE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatabaseOptions").getter(DataCatalogOutput.getter(DataCatalogOutput::databaseOptions)).setter(DataCatalogOutput.setter(Builder::databaseOptions)).constructor(DatabaseTableOutputOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseOptions").build()}).build();
    private static final SdkField<Boolean> OVERWRITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Overwrite").getter(DataCatalogOutput.getter(DataCatalogOutput::overwrite)).setter(DataCatalogOutput.setter(Builder::overwrite)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overwrite").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, S3_OPTIONS_FIELD, DATABASE_OPTIONS_FIELD, OVERWRITE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataCatalogOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String catalogId;
    private final String databaseName;
    private final String tableName;
    private final S3TableOutputOptions s3Options;
    private final DatabaseTableOutputOptions databaseOptions;
    private final Boolean overwrite;

    private DataCatalogOutput(BuilderImpl builder) {
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.s3Options = builder.s3Options;
        this.databaseOptions = builder.databaseOptions;
        this.overwrite = builder.overwrite;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final S3TableOutputOptions s3Options() {
        return this.s3Options;
    }

    public final DatabaseTableOutputOptions databaseOptions() {
        return this.databaseOptions;
    }

    public final Boolean overwrite() {
        return this.overwrite;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Options());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.overwrite());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCatalogOutput)) {
            return false;
        }
        DataCatalogOutput other = (DataCatalogOutput)obj;
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.s3Options(), other.s3Options()) && Objects.equals(this.databaseOptions(), other.databaseOptions()) && Objects.equals(this.overwrite(), other.overwrite());
    }

    public final String toString() {
        return ToString.builder((String)"DataCatalogOutput").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("S3Options", (Object)this.s3Options()).add("DatabaseOptions", (Object)this.databaseOptions()).add("Overwrite", (Object)this.overwrite()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "S3Options": {
                return Optional.ofNullable(clazz.cast(this.s3Options()));
            }
            case "DatabaseOptions": {
                return Optional.ofNullable(clazz.cast(this.databaseOptions()));
            }
            case "Overwrite": {
                return Optional.ofNullable(clazz.cast(this.overwrite()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("S3Options", S3_OPTIONS_FIELD);
        map.put("DatabaseOptions", DATABASE_OPTIONS_FIELD);
        map.put("Overwrite", OVERWRITE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataCatalogOutput, T> g) {
        return obj -> g.apply((DataCatalogOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String tableName;
        private S3TableOutputOptions s3Options;
        private DatabaseTableOutputOptions databaseOptions;
        private Boolean overwrite;

        private BuilderImpl() {
        }

        private BuilderImpl(DataCatalogOutput model) {
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.s3Options(model.s3Options);
            this.databaseOptions(model.databaseOptions);
            this.overwrite(model.overwrite);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final S3TableOutputOptions.Builder getS3Options() {
            return this.s3Options != null ? this.s3Options.toBuilder() : null;
        }

        public final void setS3Options(S3TableOutputOptions.BuilderImpl s3Options) {
            this.s3Options = s3Options != null ? s3Options.build() : null;
        }

        @Override
        public final Builder s3Options(S3TableOutputOptions s3Options) {
            this.s3Options = s3Options;
            return this;
        }

        public final DatabaseTableOutputOptions.Builder getDatabaseOptions() {
            return this.databaseOptions != null ? this.databaseOptions.toBuilder() : null;
        }

        public final void setDatabaseOptions(DatabaseTableOutputOptions.BuilderImpl databaseOptions) {
            this.databaseOptions = databaseOptions != null ? databaseOptions.build() : null;
        }

        @Override
        public final Builder databaseOptions(DatabaseTableOutputOptions databaseOptions) {
            this.databaseOptions = databaseOptions;
            return this;
        }

        public final Boolean getOverwrite() {
            return this.overwrite;
        }

        public final void setOverwrite(Boolean overwrite) {
            this.overwrite = overwrite;
        }

        @Override
        public final Builder overwrite(Boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        public DataCatalogOutput build() {
            return new DataCatalogOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataCatalogOutput> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder s3Options(S3TableOutputOptions var1);

        default public Builder s3Options(Consumer<S3TableOutputOptions.Builder> s3Options) {
            return this.s3Options((S3TableOutputOptions)((S3TableOutputOptions.Builder)S3TableOutputOptions.builder().applyMutation(s3Options)).build());
        }

        public Builder databaseOptions(DatabaseTableOutputOptions var1);

        default public Builder databaseOptions(Consumer<DatabaseTableOutputOptions.Builder> databaseOptions) {
            return this.databaseOptions((DatabaseTableOutputOptions)((DatabaseTableOutputOptions.Builder)DatabaseTableOutputOptions.builder().applyMutation(databaseOptions)).build());
        }

        public Builder overwrite(Boolean var1);
    }
}

