/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databrew.model.DataBrewResponse;
import software.amazon.awssdk.services.databrew.model.Dataset;
import software.amazon.awssdk.services.databrew.model.DatasetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDatasetsResponse
extends DataBrewResponse
implements ToCopyableBuilder<Builder, ListDatasetsResponse> {
    private static final SdkField<List<Dataset>> DATASETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Datasets").getter(ListDatasetsResponse.getter(ListDatasetsResponse::datasets)).setter(ListDatasetsResponse.setter(Builder::datasets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datasets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Dataset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDatasetsResponse.getter(ListDatasetsResponse::nextToken)).setter(ListDatasetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASETS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDatasetsResponse.memberNameToFieldInitializer();
    private final List<Dataset> datasets;
    private final String nextToken;

    private ListDatasetsResponse(BuilderImpl builder) {
        super(builder);
        this.datasets = builder.datasets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDatasets() {
        return this.datasets != null && !(this.datasets instanceof SdkAutoConstructList);
    }

    public final List<Dataset> datasets() {
        return this.datasets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasets() ? this.datasets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetsResponse)) {
            return false;
        }
        ListDatasetsResponse other = (ListDatasetsResponse)((Object)obj);
        return this.hasDatasets() == other.hasDatasets() && Objects.equals(this.datasets(), other.datasets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDatasetsResponse").add("Datasets", this.hasDatasets() ? this.datasets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Datasets": {
                return Optional.ofNullable(clazz.cast(this.datasets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Datasets", DATASETS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetsResponse, T> g) {
        return obj -> g.apply((ListDatasetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataBrewResponse.BuilderImpl
    implements Builder {
        private List<Dataset> datasets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetsResponse model) {
            super(model);
            this.datasets(model.datasets);
            this.nextToken(model.nextToken);
        }

        public final List<Dataset.Builder> getDatasets() {
            List<Dataset.Builder> result = DatasetListCopier.copyToBuilder(this.datasets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasets(Collection<Dataset.BuilderImpl> datasets) {
            this.datasets = DatasetListCopier.copyFromBuilder(datasets);
        }

        @Override
        public final Builder datasets(Collection<Dataset> datasets) {
            this.datasets = DatasetListCopier.copy(datasets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(Dataset ... datasets) {
            this.datasets(Arrays.asList(datasets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(Consumer<Dataset.Builder> ... datasets) {
            this.datasets(Stream.of(datasets).map(c -> (Dataset)((Dataset.Builder)Dataset.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDatasetsResponse build() {
            return new ListDatasetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataBrewResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDatasetsResponse> {
        public Builder datasets(Collection<Dataset> var1);

        public Builder datasets(Dataset ... var1);

        public Builder datasets(Consumer<Dataset.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

