/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.databrew.model.ColumnSelector;
import software.amazon.awssdk.services.databrew.model.ColumnSelectorListCopier;
import software.amazon.awssdk.services.databrew.model.Threshold;
import software.amazon.awssdk.services.databrew.model.ValuesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Rule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Rule> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Rule.getter(Rule::name)).setter(Rule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Disabled").getter(Rule.getter(Rule::disabled)).setter(Rule.setter(Builder::disabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()}).build();
    private static final SdkField<String> CHECK_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CheckExpression").getter(Rule.getter(Rule::checkExpression)).setter(Rule.setter(Builder::checkExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckExpression").build()}).build();
    private static final SdkField<Map<String, String>> SUBSTITUTION_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SubstitutionMap").getter(Rule.getter(Rule::substitutionMap)).setter(Rule.setter(Builder::substitutionMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubstitutionMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Threshold> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Threshold").getter(Rule.getter(Rule::threshold)).setter(Rule.setter(Builder::threshold)).constructor(Threshold::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()}).build();
    private static final SdkField<List<ColumnSelector>> COLUMN_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnSelectors").getter(Rule.getter(Rule::columnSelectors)).setter(Rule.setter(Builder::columnSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnSelectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DISABLED_FIELD, CHECK_EXPRESSION_FIELD, SUBSTITUTION_MAP_FIELD, THRESHOLD_FIELD, COLUMN_SELECTORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Rule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Boolean disabled;
    private final String checkExpression;
    private final Map<String, String> substitutionMap;
    private final Threshold threshold;
    private final List<ColumnSelector> columnSelectors;

    private Rule(BuilderImpl builder) {
        this.name = builder.name;
        this.disabled = builder.disabled;
        this.checkExpression = builder.checkExpression;
        this.substitutionMap = builder.substitutionMap;
        this.threshold = builder.threshold;
        this.columnSelectors = builder.columnSelectors;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean disabled() {
        return this.disabled;
    }

    public final String checkExpression() {
        return this.checkExpression;
    }

    public final boolean hasSubstitutionMap() {
        return this.substitutionMap != null && !(this.substitutionMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> substitutionMap() {
        return this.substitutionMap;
    }

    public final Threshold threshold() {
        return this.threshold;
    }

    public final boolean hasColumnSelectors() {
        return this.columnSelectors != null && !(this.columnSelectors instanceof SdkAutoConstructList);
    }

    public final List<ColumnSelector> columnSelectors() {
        return this.columnSelectors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubstitutionMap() ? this.substitutionMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnSelectors() ? this.columnSelectors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.disabled(), other.disabled()) && Objects.equals(this.checkExpression(), other.checkExpression()) && this.hasSubstitutionMap() == other.hasSubstitutionMap() && Objects.equals(this.substitutionMap(), other.substitutionMap()) && Objects.equals(this.threshold(), other.threshold()) && this.hasColumnSelectors() == other.hasColumnSelectors() && Objects.equals(this.columnSelectors(), other.columnSelectors());
    }

    public final String toString() {
        return ToString.builder((String)"Rule").add("Name", (Object)this.name()).add("Disabled", (Object)this.disabled()).add("CheckExpression", (Object)this.checkExpression()).add("SubstitutionMap", this.hasSubstitutionMap() ? this.substitutionMap() : null).add("Threshold", (Object)this.threshold()).add("ColumnSelectors", this.hasColumnSelectors() ? this.columnSelectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Disabled": {
                return Optional.ofNullable(clazz.cast(this.disabled()));
            }
            case "CheckExpression": {
                return Optional.ofNullable(clazz.cast(this.checkExpression()));
            }
            case "SubstitutionMap": {
                return Optional.ofNullable(clazz.cast(this.substitutionMap()));
            }
            case "Threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "ColumnSelectors": {
                return Optional.ofNullable(clazz.cast(this.columnSelectors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Disabled", DISABLED_FIELD);
        map.put("CheckExpression", CHECK_EXPRESSION_FIELD);
        map.put("SubstitutionMap", SUBSTITUTION_MAP_FIELD);
        map.put("Threshold", THRESHOLD_FIELD);
        map.put("ColumnSelectors", COLUMN_SELECTORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Boolean disabled;
        private String checkExpression;
        private Map<String, String> substitutionMap = DefaultSdkAutoConstructMap.getInstance();
        private Threshold threshold;
        private List<ColumnSelector> columnSelectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            this.name(model.name);
            this.disabled(model.disabled);
            this.checkExpression(model.checkExpression);
            this.substitutionMap(model.substitutionMap);
            this.threshold(model.threshold);
            this.columnSelectors(model.columnSelectors);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getDisabled() {
            return this.disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final String getCheckExpression() {
            return this.checkExpression;
        }

        public final void setCheckExpression(String checkExpression) {
            this.checkExpression = checkExpression;
        }

        @Override
        public final Builder checkExpression(String checkExpression) {
            this.checkExpression = checkExpression;
            return this;
        }

        public final Map<String, String> getSubstitutionMap() {
            if (this.substitutionMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.substitutionMap;
        }

        public final void setSubstitutionMap(Map<String, String> substitutionMap) {
            this.substitutionMap = ValuesMapCopier.copy(substitutionMap);
        }

        @Override
        public final Builder substitutionMap(Map<String, String> substitutionMap) {
            this.substitutionMap = ValuesMapCopier.copy(substitutionMap);
            return this;
        }

        public final Threshold.Builder getThreshold() {
            return this.threshold != null ? this.threshold.toBuilder() : null;
        }

        public final void setThreshold(Threshold.BuilderImpl threshold) {
            this.threshold = threshold != null ? threshold.build() : null;
        }

        @Override
        public final Builder threshold(Threshold threshold) {
            this.threshold = threshold;
            return this;
        }

        public final List<ColumnSelector.Builder> getColumnSelectors() {
            List<ColumnSelector.Builder> result = ColumnSelectorListCopier.copyToBuilder(this.columnSelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnSelectors(Collection<ColumnSelector.BuilderImpl> columnSelectors) {
            this.columnSelectors = ColumnSelectorListCopier.copyFromBuilder(columnSelectors);
        }

        @Override
        public final Builder columnSelectors(Collection<ColumnSelector> columnSelectors) {
            this.columnSelectors = ColumnSelectorListCopier.copy(columnSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnSelectors(ColumnSelector ... columnSelectors) {
            this.columnSelectors(Arrays.asList(columnSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnSelectors(Consumer<ColumnSelector.Builder> ... columnSelectors) {
            this.columnSelectors(Stream.of(columnSelectors).map(c -> (ColumnSelector)((ColumnSelector.Builder)ColumnSelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Rule build() {
            return new Rule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Rule> {
        public Builder name(String var1);

        public Builder disabled(Boolean var1);

        public Builder checkExpression(String var1);

        public Builder substitutionMap(Map<String, String> var1);

        public Builder threshold(Threshold var1);

        default public Builder threshold(Consumer<Threshold.Builder> threshold) {
            return this.threshold((Threshold)((Threshold.Builder)Threshold.builder().applyMutation(threshold)).build());
        }

        public Builder columnSelectors(Collection<ColumnSelector> var1);

        public Builder columnSelectors(ColumnSelector ... var1);

        public Builder columnSelectors(Consumer<ColumnSelector.Builder> ... var1);
    }
}

