/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents additional options for correct interpretation of datetime parameters used in the Amazon S3 path of a
 * dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatetimeOptions implements SdkPojo, Serializable, ToCopyableBuilder<DatetimeOptions.Builder, DatetimeOptions> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(DatetimeOptions::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<String> TIMEZONE_OFFSET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimezoneOffset").getter(getter(DatetimeOptions::timezoneOffset)).setter(setter(Builder::timezoneOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimezoneOffset").build()).build();

    private static final SdkField<String> LOCALE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocaleCode").getter(getter(DatetimeOptions::localeCode)).setter(setter(Builder::localeCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocaleCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD,
            TIMEZONE_OFFSET_FIELD, LOCALE_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String format;

    private final String timezoneOffset;

    private final String localeCode;

    private DatetimeOptions(BuilderImpl builder) {
        this.format = builder.format;
        this.timezoneOffset = builder.timezoneOffset;
        this.localeCode = builder.localeCode;
    }

    /**
     * <p>
     * Required option, that defines the datetime format used for a date parameter in the Amazon S3 path. Should use
     * only supported datetime specifiers and separation characters, all literal a-z or A-Z characters should be escaped
     * with single quotes. E.g. "MM.dd.yyyy-'at'-HH:mm".
     * </p>
     * 
     * @return Required option, that defines the datetime format used for a date parameter in the Amazon S3 path. Should
     *         use only supported datetime specifiers and separation characters, all literal a-z or A-Z characters
     *         should be escaped with single quotes. E.g. "MM.dd.yyyy-'at'-HH:mm".
     */
    public final String format() {
        return format;
    }

    /**
     * <p>
     * Optional value for a timezone offset of the datetime parameter value in the Amazon S3 path. Shouldn't be used if
     * Format for this parameter includes timezone fields. If no offset specified, UTC is assumed.
     * </p>
     * 
     * @return Optional value for a timezone offset of the datetime parameter value in the Amazon S3 path. Shouldn't be
     *         used if Format for this parameter includes timezone fields. If no offset specified, UTC is assumed.
     */
    public final String timezoneOffset() {
        return timezoneOffset;
    }

    /**
     * <p>
     * Optional value for a non-US locale code, needed for correct interpretation of some date formats.
     * </p>
     * 
     * @return Optional value for a non-US locale code, needed for correct interpretation of some date formats.
     */
    public final String localeCode() {
        return localeCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(timezoneOffset());
        hashCode = 31 * hashCode + Objects.hashCode(localeCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatetimeOptions)) {
            return false;
        }
        DatetimeOptions other = (DatetimeOptions) obj;
        return Objects.equals(format(), other.format()) && Objects.equals(timezoneOffset(), other.timezoneOffset())
                && Objects.equals(localeCode(), other.localeCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatetimeOptions").add("Format", format()).add("TimezoneOffset", timezoneOffset())
                .add("LocaleCode", localeCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        case "TimezoneOffset":
            return Optional.ofNullable(clazz.cast(timezoneOffset()));
        case "LocaleCode":
            return Optional.ofNullable(clazz.cast(localeCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Format", FORMAT_FIELD);
        map.put("TimezoneOffset", TIMEZONE_OFFSET_FIELD);
        map.put("LocaleCode", LOCALE_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatetimeOptions, T> g) {
        return obj -> g.apply((DatetimeOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatetimeOptions> {
        /**
         * <p>
         * Required option, that defines the datetime format used for a date parameter in the Amazon S3 path. Should use
         * only supported datetime specifiers and separation characters, all literal a-z or A-Z characters should be
         * escaped with single quotes. E.g. "MM.dd.yyyy-'at'-HH:mm".
         * </p>
         * 
         * @param format
         *        Required option, that defines the datetime format used for a date parameter in the Amazon S3 path.
         *        Should use only supported datetime specifiers and separation characters, all literal a-z or A-Z
         *        characters should be escaped with single quotes. E.g. "MM.dd.yyyy-'at'-HH:mm".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * Optional value for a timezone offset of the datetime parameter value in the Amazon S3 path. Shouldn't be used
         * if Format for this parameter includes timezone fields. If no offset specified, UTC is assumed.
         * </p>
         * 
         * @param timezoneOffset
         *        Optional value for a timezone offset of the datetime parameter value in the Amazon S3 path. Shouldn't
         *        be used if Format for this parameter includes timezone fields. If no offset specified, UTC is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezoneOffset(String timezoneOffset);

        /**
         * <p>
         * Optional value for a non-US locale code, needed for correct interpretation of some date formats.
         * </p>
         * 
         * @param localeCode
         *        Optional value for a non-US locale code, needed for correct interpretation of some date formats.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeCode(String localeCode);
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private String timezoneOffset;

        private String localeCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DatetimeOptions model) {
            format(model.format);
            timezoneOffset(model.timezoneOffset);
            localeCode(model.localeCode);
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final String getTimezoneOffset() {
            return timezoneOffset;
        }

        public final void setTimezoneOffset(String timezoneOffset) {
            this.timezoneOffset = timezoneOffset;
        }

        @Override
        public final Builder timezoneOffset(String timezoneOffset) {
            this.timezoneOffset = timezoneOffset;
            return this;
        }

        public final String getLocaleCode() {
            return localeCode;
        }

        public final void setLocaleCode(String localeCode) {
            this.localeCode = localeCode;
        }

        @Override
        public final Builder localeCode(String localeCode) {
            this.localeCode = localeCode;
            return this;
        }

        @Override
        public DatetimeOptions build() {
            return new DatetimeOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
