/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents one or more dates and times when a job is to run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Schedule implements SdkPojo, Serializable, ToCopyableBuilder<Schedule.Builder, Schedule> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(Schedule::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(Schedule::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(Schedule::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<List<String>> JOB_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("JobNames")
            .getter(getter(Schedule::jobNames))
            .setter(setter(Builder::jobNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedBy").getter(getter(Schedule::lastModifiedBy)).setter(setter(Builder::lastModifiedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate").getter(getter(Schedule::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(Schedule::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> CRON_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CronExpression").getter(getter(Schedule::cronExpression)).setter(setter(Builder::cronExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CronExpression").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Schedule::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Schedule::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            CREATED_BY_FIELD, CREATE_DATE_FIELD, JOB_NAMES_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_DATE_FIELD,
            RESOURCE_ARN_FIELD, CRON_EXPRESSION_FIELD, TAGS_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String createdBy;

    private final Instant createDate;

    private final List<String> jobNames;

    private final String lastModifiedBy;

    private final Instant lastModifiedDate;

    private final String resourceArn;

    private final String cronExpression;

    private final Map<String, String> tags;

    private final String name;

    private Schedule(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.createdBy = builder.createdBy;
        this.createDate = builder.createDate;
        this.jobNames = builder.jobNames;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.resourceArn = builder.resourceArn;
        this.cronExpression = builder.cronExpression;
        this.tags = builder.tags;
        this.name = builder.name;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the schedule.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the schedule.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who created the schedule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who created the schedule.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time that the schedule was created.
     * </p>
     * 
     * @return The date and time that the schedule was created.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobNames property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasJobNames() {
        return jobNames != null && !(jobNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of jobs to be run, according to the schedule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobNames} method.
     * </p>
     * 
     * @return A list of jobs to be run, according to the schedule.
     */
    public final List<String> jobNames() {
        return jobNames;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who last modified the schedule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who last modified the schedule.
     */
    public final String lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * The date and time when the schedule was last modified.
     * </p>
     * 
     * @return The date and time when the schedule was last modified.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the schedule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the schedule.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The dates and times when the job is to run. For more information, see <a
     * href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the <i>Glue DataBrew
     * Developer Guide</i>.
     * </p>
     * 
     * @return The dates and times when the job is to run. For more information, see <a
     *         href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the <i>Glue
     *         DataBrew Developer Guide</i>.
     */
    public final String cronExpression() {
        return cronExpression;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata tags that have been applied to the schedule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata tags that have been applied to the schedule.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The name of the schedule.
     * </p>
     * 
     * @return The name of the schedule.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasJobNames() ? jobNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(cronExpression());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(createDate(), other.createDate()) && hasJobNames() == other.hasJobNames()
                && Objects.equals(jobNames(), other.jobNames()) && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(cronExpression(), other.cronExpression())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Schedule").add("AccountId", accountId()).add("CreatedBy", createdBy())
                .add("CreateDate", createDate()).add("JobNames", hasJobNames() ? jobNames() : null)
                .add("LastModifiedBy", lastModifiedBy()).add("LastModifiedDate", lastModifiedDate())
                .add("ResourceArn", resourceArn()).add("CronExpression", cronExpression()).add("Tags", hasTags() ? tags() : null)
                .add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "JobNames":
            return Optional.ofNullable(clazz.cast(jobNames()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "CronExpression":
            return Optional.ofNullable(clazz.cast(cronExpression()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("JobNames", JOB_NAMES_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("CronExpression", CRON_EXPRESSION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Schedule, T> g) {
        return obj -> g.apply((Schedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Schedule> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the schedule.
         * </p>
         * 
         * @param accountId
         *        The ID of the Amazon Web Services account that owns the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who created the schedule.
         * </p>
         * 
         * @param createdBy
         *        The Amazon Resource Name (ARN) of the user who created the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time that the schedule was created.
         * </p>
         * 
         * @param createDate
         *        The date and time that the schedule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * A list of jobs to be run, according to the schedule.
         * </p>
         * 
         * @param jobNames
         *        A list of jobs to be run, according to the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobNames(Collection<String> jobNames);

        /**
         * <p>
         * A list of jobs to be run, according to the schedule.
         * </p>
         * 
         * @param jobNames
         *        A list of jobs to be run, according to the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobNames(String... jobNames);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who last modified the schedule.
         * </p>
         * 
         * @param lastModifiedBy
         *        The Amazon Resource Name (ARN) of the user who last modified the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(String lastModifiedBy);

        /**
         * <p>
         * The date and time when the schedule was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time when the schedule was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the schedule.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The dates and times when the job is to run. For more information, see <a
         * href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the <i>Glue
         * DataBrew Developer Guide</i>.
         * </p>
         * 
         * @param cronExpression
         *        The dates and times when the job is to run. For more information, see <a
         *        href="https://docs.aws.amazon.com/databrew/latest/dg/jobs.cron.html">Cron expressions</a> in the
         *        <i>Glue DataBrew Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cronExpression(String cronExpression);

        /**
         * <p>
         * Metadata tags that have been applied to the schedule.
         * </p>
         * 
         * @param tags
         *        Metadata tags that have been applied to the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The name of the schedule.
         * </p>
         * 
         * @param name
         *        The name of the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String createdBy;

        private Instant createDate;

        private List<String> jobNames = DefaultSdkAutoConstructList.getInstance();

        private String lastModifiedBy;

        private Instant lastModifiedDate;

        private String resourceArn;

        private String cronExpression;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(Schedule model) {
            accountId(model.accountId);
            createdBy(model.createdBy);
            createDate(model.createDate);
            jobNames(model.jobNames);
            lastModifiedBy(model.lastModifiedBy);
            lastModifiedDate(model.lastModifiedDate);
            resourceArn(model.resourceArn);
            cronExpression(model.cronExpression);
            tags(model.tags);
            name(model.name);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final Collection<String> getJobNames() {
            if (jobNames instanceof SdkAutoConstructList) {
                return null;
            }
            return jobNames;
        }

        public final void setJobNames(Collection<String> jobNames) {
            this.jobNames = JobNameListCopier.copy(jobNames);
        }

        @Override
        public final Builder jobNames(Collection<String> jobNames) {
            this.jobNames = JobNameListCopier.copy(jobNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobNames(String... jobNames) {
            jobNames(Arrays.asList(jobNames));
            return this;
        }

        public final String getLastModifiedBy() {
            return lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getCronExpression() {
            return cronExpression;
        }

        public final void setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
        }

        @Override
        public final Builder cronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Schedule build() {
            return new Schedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
