/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for data quality validation. Used to select the Rulesets and Validation Mode to be used in the profile
 * job. When ValidationConfiguration is null, the profile job will run without data quality validation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ValidationConfiguration.Builder, ValidationConfiguration> {
    private static final SdkField<String> RULESET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RulesetArn").getter(getter(ValidationConfiguration::rulesetArn)).setter(setter(Builder::rulesetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesetArn").build()).build();

    private static final SdkField<String> VALIDATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationMode").getter(getter(ValidationConfiguration::validationModeAsString))
            .setter(setter(Builder::validationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULESET_ARN_FIELD,
            VALIDATION_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String rulesetArn;

    private final String validationMode;

    private ValidationConfiguration(BuilderImpl builder) {
        this.rulesetArn = builder.rulesetArn;
        this.validationMode = builder.validationMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the ruleset to be validated in the profile job. The TargetArn of the selected
     * ruleset should be the same as the Amazon Resource Name (ARN) of the dataset that is associated with the profile
     * job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the ruleset to be validated in the profile job. The TargetArn of the
     *         selected ruleset should be the same as the Amazon Resource Name (ARN) of the dataset that is associated
     *         with the profile job.
     */
    public final String rulesetArn() {
        return rulesetArn;
    }

    /**
     * <p>
     * Mode of data quality validation. Default mode is “CHECK_ALL” which verifies all rules defined in the selected
     * ruleset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationMode}
     * will return {@link ValidationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #validationModeAsString}.
     * </p>
     * 
     * @return Mode of data quality validation. Default mode is “CHECK_ALL” which verifies all rules defined in the
     *         selected ruleset.
     * @see ValidationMode
     */
    public final ValidationMode validationMode() {
        return ValidationMode.fromValue(validationMode);
    }

    /**
     * <p>
     * Mode of data quality validation. Default mode is “CHECK_ALL” which verifies all rules defined in the selected
     * ruleset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationMode}
     * will return {@link ValidationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #validationModeAsString}.
     * </p>
     * 
     * @return Mode of data quality validation. Default mode is “CHECK_ALL” which verifies all rules defined in the
     *         selected ruleset.
     * @see ValidationMode
     */
    public final String validationModeAsString() {
        return validationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rulesetArn());
        hashCode = 31 * hashCode + Objects.hashCode(validationModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationConfiguration)) {
            return false;
        }
        ValidationConfiguration other = (ValidationConfiguration) obj;
        return Objects.equals(rulesetArn(), other.rulesetArn())
                && Objects.equals(validationModeAsString(), other.validationModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidationConfiguration").add("RulesetArn", rulesetArn())
                .add("ValidationMode", validationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RulesetArn":
            return Optional.ofNullable(clazz.cast(rulesetArn()));
        case "ValidationMode":
            return Optional.ofNullable(clazz.cast(validationModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RulesetArn", RULESET_ARN_FIELD);
        map.put("ValidationMode", VALIDATION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidationConfiguration, T> g) {
        return obj -> g.apply((ValidationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the ruleset to be validated in the profile job. The TargetArn of the
         * selected ruleset should be the same as the Amazon Resource Name (ARN) of the dataset that is associated with
         * the profile job.
         * </p>
         * 
         * @param rulesetArn
         *        The Amazon Resource Name (ARN) for the ruleset to be validated in the profile job. The TargetArn of
         *        the selected ruleset should be the same as the Amazon Resource Name (ARN) of the dataset that is
         *        associated with the profile job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesetArn(String rulesetArn);

        /**
         * <p>
         * Mode of data quality validation. Default mode is “CHECK_ALL” which verifies all rules defined in the selected
         * ruleset.
         * </p>
         * 
         * @param validationMode
         *        Mode of data quality validation. Default mode is “CHECK_ALL” which verifies all rules defined in the
         *        selected ruleset.
         * @see ValidationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationMode
         */
        Builder validationMode(String validationMode);

        /**
         * <p>
         * Mode of data quality validation. Default mode is “CHECK_ALL” which verifies all rules defined in the selected
         * ruleset.
         * </p>
         * 
         * @param validationMode
         *        Mode of data quality validation. Default mode is “CHECK_ALL” which verifies all rules defined in the
         *        selected ruleset.
         * @see ValidationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationMode
         */
        Builder validationMode(ValidationMode validationMode);
    }

    static final class BuilderImpl implements Builder {
        private String rulesetArn;

        private String validationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationConfiguration model) {
            rulesetArn(model.rulesetArn);
            validationMode(model.validationMode);
        }

        public final String getRulesetArn() {
            return rulesetArn;
        }

        public final void setRulesetArn(String rulesetArn) {
            this.rulesetArn = rulesetArn;
        }

        @Override
        public final Builder rulesetArn(String rulesetArn) {
            this.rulesetArn = rulesetArn;
            return this;
        }

        public final String getValidationMode() {
            return validationMode;
        }

        public final void setValidationMode(String validationMode) {
            this.validationMode = validationMode;
        }

        @Override
        public final Builder validationMode(String validationMode) {
            this.validationMode = validationMode;
            return this;
        }

        @Override
        public final Builder validationMode(ValidationMode validationMode) {
            this.validationMode(validationMode == null ? null : validationMode.toString());
            return this;
        }

        @Override
        public ValidationConfiguration build() {
            return new ValidationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
