/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A key-value pair that describes a property of a pipeline object. The value is specified as either a string value (
 * <code>StringValue</code>) or a reference to another object (<code>RefValue</code>) but not as both.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Field implements SdkPojo, Serializable, ToCopyableBuilder<Field.Builder, Field> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Field::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Field::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()).build();

    private static final SdkField<String> REF_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Field::refValue)).setter(setter(Builder::refValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, STRING_VALUE_FIELD,
            REF_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String stringValue;

    private final String refValue;

    private Field(BuilderImpl builder) {
        this.key = builder.key;
        this.stringValue = builder.stringValue;
        this.refValue = builder.refValue;
    }

    /**
     * <p>
     * The field identifier.
     * </p>
     * 
     * @return The field identifier.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The field value, expressed as a String.
     * </p>
     * 
     * @return The field value, expressed as a String.
     */
    public String stringValue() {
        return stringValue;
    }

    /**
     * <p>
     * The field value, expressed as the identifier of another object.
     * </p>
     * 
     * @return The field value, expressed as the identifier of another object.
     */
    public String refValue() {
        return refValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(refValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Field)) {
            return false;
        }
        Field other = (Field) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(stringValue(), other.stringValue())
                && Objects.equals(refValue(), other.refValue());
    }

    @Override
    public String toString() {
        return ToString.builder("Field").add("Key", key()).add("StringValue", stringValue()).add("RefValue", refValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "stringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "refValue":
            return Optional.ofNullable(clazz.cast(refValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Field, T> g) {
        return obj -> g.apply((Field) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Field> {
        /**
         * <p>
         * The field identifier.
         * </p>
         * 
         * @param key
         *        The field identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The field value, expressed as a String.
         * </p>
         * 
         * @param stringValue
         *        The field value, expressed as a String.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * <p>
         * The field value, expressed as the identifier of another object.
         * </p>
         * 
         * @param refValue
         *        The field value, expressed as the identifier of another object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refValue(String refValue);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String stringValue;

        private String refValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Field model) {
            key(model.key);
            stringValue(model.stringValue);
            refValue(model.refValue);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getStringValue() {
            return stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public final String getRefValue() {
            return refValue;
        }

        @Override
        public final Builder refValue(String refValue) {
            this.refValue = refValue;
            return this;
        }

        public final void setRefValue(String refValue) {
            this.refValue = refValue;
        }

        @Override
        public Field build() {
            return new Field(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
