/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of GetPipelineDefinition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPipelineDefinitionResponse extends DataPipelineResponse implements
        ToCopyableBuilder<GetPipelineDefinitionResponse.Builder, GetPipelineDefinitionResponse> {
    private static final SdkField<List<PipelineObject>> PIPELINE_OBJECTS_FIELD = SdkField
            .<List<PipelineObject>> builder(MarshallingType.LIST)
            .getter(getter(GetPipelineDefinitionResponse::pipelineObjects))
            .setter(setter(Builder::pipelineObjects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineObjects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PipelineObject> builder(MarshallingType.SDK_POJO)
                                            .constructor(PipelineObject::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParameterObject>> PARAMETER_OBJECTS_FIELD = SdkField
            .<List<ParameterObject>> builder(MarshallingType.LIST)
            .getter(getter(GetPipelineDefinitionResponse::parameterObjects))
            .setter(setter(Builder::parameterObjects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterObjects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterObject> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterObject::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParameterValue>> PARAMETER_VALUES_FIELD = SdkField
            .<List<ParameterValue>> builder(MarshallingType.LIST)
            .getter(getter(GetPipelineDefinitionResponse::parameterValues))
            .setter(setter(Builder::parameterValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_OBJECTS_FIELD,
            PARAMETER_OBJECTS_FIELD, PARAMETER_VALUES_FIELD));

    private final List<PipelineObject> pipelineObjects;

    private final List<ParameterObject> parameterObjects;

    private final List<ParameterValue> parameterValues;

    private GetPipelineDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineObjects = builder.pipelineObjects;
        this.parameterObjects = builder.parameterObjects;
        this.parameterValues = builder.parameterValues;
    }

    /**
     * <p>
     * The objects defined in the pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The objects defined in the pipeline.
     */
    public List<PipelineObject> pipelineObjects() {
        return pipelineObjects;
    }

    /**
     * <p>
     * The parameter objects used in the pipeline definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The parameter objects used in the pipeline definition.
     */
    public List<ParameterObject> parameterObjects() {
        return parameterObjects;
    }

    /**
     * <p>
     * The parameter values used in the pipeline definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The parameter values used in the pipeline definition.
     */
    public List<ParameterValue> parameterValues() {
        return parameterValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineObjects());
        hashCode = 31 * hashCode + Objects.hashCode(parameterObjects());
        hashCode = 31 * hashCode + Objects.hashCode(parameterValues());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPipelineDefinitionResponse)) {
            return false;
        }
        GetPipelineDefinitionResponse other = (GetPipelineDefinitionResponse) obj;
        return Objects.equals(pipelineObjects(), other.pipelineObjects())
                && Objects.equals(parameterObjects(), other.parameterObjects())
                && Objects.equals(parameterValues(), other.parameterValues());
    }

    @Override
    public String toString() {
        return ToString.builder("GetPipelineDefinitionResponse").add("PipelineObjects", pipelineObjects())
                .add("ParameterObjects", parameterObjects()).add("ParameterValues", parameterValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineObjects":
            return Optional.ofNullable(clazz.cast(pipelineObjects()));
        case "parameterObjects":
            return Optional.ofNullable(clazz.cast(parameterObjects()));
        case "parameterValues":
            return Optional.ofNullable(clazz.cast(parameterValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPipelineDefinitionResponse, T> g) {
        return obj -> g.apply((GetPipelineDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataPipelineResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPipelineDefinitionResponse> {
        /**
         * <p>
         * The objects defined in the pipeline.
         * </p>
         * 
         * @param pipelineObjects
         *        The objects defined in the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineObjects(Collection<PipelineObject> pipelineObjects);

        /**
         * <p>
         * The objects defined in the pipeline.
         * </p>
         * 
         * @param pipelineObjects
         *        The objects defined in the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineObjects(PipelineObject... pipelineObjects);

        /**
         * <p>
         * The objects defined in the pipeline.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PipelineObject>.Builder} avoiding the need
         * to create one manually via {@link List<PipelineObject>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PipelineObject>.Builder#build()} is called immediately and
         * its result is passed to {@link #pipelineObjects(List<PipelineObject>)}.
         * 
         * @param pipelineObjects
         *        a consumer that will call methods on {@link List<PipelineObject>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineObjects(List<PipelineObject>)
         */
        Builder pipelineObjects(Consumer<PipelineObject.Builder>... pipelineObjects);

        /**
         * <p>
         * The parameter objects used in the pipeline definition.
         * </p>
         * 
         * @param parameterObjects
         *        The parameter objects used in the pipeline definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterObjects(Collection<ParameterObject> parameterObjects);

        /**
         * <p>
         * The parameter objects used in the pipeline definition.
         * </p>
         * 
         * @param parameterObjects
         *        The parameter objects used in the pipeline definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterObjects(ParameterObject... parameterObjects);

        /**
         * <p>
         * The parameter objects used in the pipeline definition.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ParameterObject>.Builder} avoiding the need
         * to create one manually via {@link List<ParameterObject>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ParameterObject>.Builder#build()} is called immediately and
         * its result is passed to {@link #parameterObjects(List<ParameterObject>)}.
         * 
         * @param parameterObjects
         *        a consumer that will call methods on {@link List<ParameterObject>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterObjects(List<ParameterObject>)
         */
        Builder parameterObjects(Consumer<ParameterObject.Builder>... parameterObjects);

        /**
         * <p>
         * The parameter values used in the pipeline definition.
         * </p>
         * 
         * @param parameterValues
         *        The parameter values used in the pipeline definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValues(Collection<ParameterValue> parameterValues);

        /**
         * <p>
         * The parameter values used in the pipeline definition.
         * </p>
         * 
         * @param parameterValues
         *        The parameter values used in the pipeline definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValues(ParameterValue... parameterValues);

        /**
         * <p>
         * The parameter values used in the pipeline definition.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ParameterValue>.Builder} avoiding the need
         * to create one manually via {@link List<ParameterValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ParameterValue>.Builder#build()} is called immediately and
         * its result is passed to {@link #parameterValues(List<ParameterValue>)}.
         * 
         * @param parameterValues
         *        a consumer that will call methods on {@link List<ParameterValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterValues(List<ParameterValue>)
         */
        Builder parameterValues(Consumer<ParameterValue.Builder>... parameterValues);
    }

    static final class BuilderImpl extends DataPipelineResponse.BuilderImpl implements Builder {
        private List<PipelineObject> pipelineObjects = DefaultSdkAutoConstructList.getInstance();

        private List<ParameterObject> parameterObjects = DefaultSdkAutoConstructList.getInstance();

        private List<ParameterValue> parameterValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPipelineDefinitionResponse model) {
            super(model);
            pipelineObjects(model.pipelineObjects);
            parameterObjects(model.parameterObjects);
            parameterValues(model.parameterValues);
        }

        public final Collection<PipelineObject.Builder> getPipelineObjects() {
            return pipelineObjects != null ? pipelineObjects.stream().map(PipelineObject::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder pipelineObjects(Collection<PipelineObject> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copy(pipelineObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineObjects(PipelineObject... pipelineObjects) {
            pipelineObjects(Arrays.asList(pipelineObjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineObjects(Consumer<PipelineObject.Builder>... pipelineObjects) {
            pipelineObjects(Stream.of(pipelineObjects).map(c -> PipelineObject.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPipelineObjects(Collection<PipelineObject.BuilderImpl> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copyFromBuilder(pipelineObjects);
        }

        public final Collection<ParameterObject.Builder> getParameterObjects() {
            return parameterObjects != null ? parameterObjects.stream().map(ParameterObject::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterObjects(Collection<ParameterObject> parameterObjects) {
            this.parameterObjects = ParameterObjectListCopier.copy(parameterObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterObjects(ParameterObject... parameterObjects) {
            parameterObjects(Arrays.asList(parameterObjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterObjects(Consumer<ParameterObject.Builder>... parameterObjects) {
            parameterObjects(Stream.of(parameterObjects).map(c -> ParameterObject.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParameterObjects(Collection<ParameterObject.BuilderImpl> parameterObjects) {
            this.parameterObjects = ParameterObjectListCopier.copyFromBuilder(parameterObjects);
        }

        public final Collection<ParameterValue.Builder> getParameterValues() {
            return parameterValues != null ? parameterValues.stream().map(ParameterValue::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder parameterValues(Collection<ParameterValue> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copy(parameterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterValues(ParameterValue... parameterValues) {
            parameterValues(Arrays.asList(parameterValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterValues(Consumer<ParameterValue.Builder>... parameterValues) {
            parameterValues(Stream.of(parameterValues).map(c -> ParameterValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParameterValues(Collection<ParameterValue.BuilderImpl> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copyFromBuilder(parameterValues);
        }

        @Override
        public GetPipelineDefinitionResponse build() {
            return new GetPipelineDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
