/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of PollForTask.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PollForTaskResponse extends DataPipelineResponse implements
        ToCopyableBuilder<PollForTaskResponse.Builder, PollForTaskResponse> {
    private static final SdkField<TaskObject> TASK_OBJECT_FIELD = SdkField.<TaskObject> builder(MarshallingType.SDK_POJO)
            .getter(getter(PollForTaskResponse::taskObject)).setter(setter(Builder::taskObject)).constructor(TaskObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskObject").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_OBJECT_FIELD));

    private final TaskObject taskObject;

    private PollForTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskObject = builder.taskObject;
    }

    /**
     * <p>
     * The information needed to complete the task that is being assigned to the task runner. One of the fields returned
     * in this object is <code>taskId</code>, which contains an identifier for the task being assigned. The calling task
     * runner uses <code>taskId</code> in subsequent calls to <a>ReportTaskProgress</a> and <a>SetTaskStatus</a>.
     * </p>
     * 
     * @return The information needed to complete the task that is being assigned to the task runner. One of the fields
     *         returned in this object is <code>taskId</code>, which contains an identifier for the task being assigned.
     *         The calling task runner uses <code>taskId</code> in subsequent calls to <a>ReportTaskProgress</a> and
     *         <a>SetTaskStatus</a>.
     */
    public TaskObject taskObject() {
        return taskObject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskObject());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForTaskResponse)) {
            return false;
        }
        PollForTaskResponse other = (PollForTaskResponse) obj;
        return Objects.equals(taskObject(), other.taskObject());
    }

    @Override
    public String toString() {
        return ToString.builder("PollForTaskResponse").add("TaskObject", taskObject()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskObject":
            return Optional.ofNullable(clazz.cast(taskObject()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PollForTaskResponse, T> g) {
        return obj -> g.apply((PollForTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataPipelineResponse.Builder, SdkPojo, CopyableBuilder<Builder, PollForTaskResponse> {
        /**
         * <p>
         * The information needed to complete the task that is being assigned to the task runner. One of the fields
         * returned in this object is <code>taskId</code>, which contains an identifier for the task being assigned. The
         * calling task runner uses <code>taskId</code> in subsequent calls to <a>ReportTaskProgress</a> and
         * <a>SetTaskStatus</a>.
         * </p>
         * 
         * @param taskObject
         *        The information needed to complete the task that is being assigned to the task runner. One of the
         *        fields returned in this object is <code>taskId</code>, which contains an identifier for the task being
         *        assigned. The calling task runner uses <code>taskId</code> in subsequent calls to
         *        <a>ReportTaskProgress</a> and <a>SetTaskStatus</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskObject(TaskObject taskObject);

        /**
         * <p>
         * The information needed to complete the task that is being assigned to the task runner. One of the fields
         * returned in this object is <code>taskId</code>, which contains an identifier for the task being assigned. The
         * calling task runner uses <code>taskId</code> in subsequent calls to <a>ReportTaskProgress</a> and
         * <a>SetTaskStatus</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link TaskObject.Builder} avoiding the need to create
         * one manually via {@link TaskObject#builder()}.
         *
         * When the {@link Consumer} completes, {@link TaskObject.Builder#build()} is called immediately and its result
         * is passed to {@link #taskObject(TaskObject)}.
         * 
         * @param taskObject
         *        a consumer that will call methods on {@link TaskObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskObject(TaskObject)
         */
        default Builder taskObject(Consumer<TaskObject.Builder> taskObject) {
            return taskObject(TaskObject.builder().applyMutation(taskObject).build());
        }
    }

    static final class BuilderImpl extends DataPipelineResponse.BuilderImpl implements Builder {
        private TaskObject taskObject;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForTaskResponse model) {
            super(model);
            taskObject(model.taskObject);
        }

        public final TaskObject.Builder getTaskObject() {
            return taskObject != null ? taskObject.toBuilder() : null;
        }

        @Override
        public final Builder taskObject(TaskObject taskObject) {
            this.taskObject = taskObject;
            return this;
        }

        public final void setTaskObject(TaskObject.BuilderImpl taskObject) {
            this.taskObject = taskObject != null ? taskObject.build() : null;
        }

        @Override
        public PollForTaskResponse build() {
            return new PollForTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
