/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of ValidatePipelineDefinition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidatePipelineDefinitionResponse extends DataPipelineResponse implements
        ToCopyableBuilder<ValidatePipelineDefinitionResponse.Builder, ValidatePipelineDefinitionResponse> {
    private static final SdkField<List<ValidationError>> VALIDATION_ERRORS_FIELD = SdkField
            .<List<ValidationError>> builder(MarshallingType.LIST)
            .getter(getter(ValidatePipelineDefinitionResponse::validationErrors))
            .setter(setter(Builder::validationErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidationError> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidationError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ValidationWarning>> VALIDATION_WARNINGS_FIELD = SdkField
            .<List<ValidationWarning>> builder(MarshallingType.LIST)
            .getter(getter(ValidatePipelineDefinitionResponse::validationWarnings))
            .setter(setter(Builder::validationWarnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationWarnings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidationWarning> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidationWarning::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ERRORED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ValidatePipelineDefinitionResponse::errored)).setter(setter(Builder::errored))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errored").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_ERRORS_FIELD,
            VALIDATION_WARNINGS_FIELD, ERRORED_FIELD));

    private final List<ValidationError> validationErrors;

    private final List<ValidationWarning> validationWarnings;

    private final Boolean errored;

    private ValidatePipelineDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.validationErrors = builder.validationErrors;
        this.validationWarnings = builder.validationWarnings;
        this.errored = builder.errored;
    }

    /**
     * <p>
     * Any validation errors that were found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any validation errors that were found.
     */
    public List<ValidationError> validationErrors() {
        return validationErrors;
    }

    /**
     * <p>
     * Any validation warnings that were found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any validation warnings that were found.
     */
    public List<ValidationWarning> validationWarnings() {
        return validationWarnings;
    }

    /**
     * <p>
     * Indicates whether there were validation errors.
     * </p>
     * 
     * @return Indicates whether there were validation errors.
     */
    public Boolean errored() {
        return errored;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(validationErrors());
        hashCode = 31 * hashCode + Objects.hashCode(validationWarnings());
        hashCode = 31 * hashCode + Objects.hashCode(errored());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidatePipelineDefinitionResponse)) {
            return false;
        }
        ValidatePipelineDefinitionResponse other = (ValidatePipelineDefinitionResponse) obj;
        return Objects.equals(validationErrors(), other.validationErrors())
                && Objects.equals(validationWarnings(), other.validationWarnings()) && Objects.equals(errored(), other.errored());
    }

    @Override
    public String toString() {
        return ToString.builder("ValidatePipelineDefinitionResponse").add("ValidationErrors", validationErrors())
                .add("ValidationWarnings", validationWarnings()).add("Errored", errored()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "validationErrors":
            return Optional.ofNullable(clazz.cast(validationErrors()));
        case "validationWarnings":
            return Optional.ofNullable(clazz.cast(validationWarnings()));
        case "errored":
            return Optional.ofNullable(clazz.cast(errored()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidatePipelineDefinitionResponse, T> g) {
        return obj -> g.apply((ValidatePipelineDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataPipelineResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ValidatePipelineDefinitionResponse> {
        /**
         * <p>
         * Any validation errors that were found.
         * </p>
         * 
         * @param validationErrors
         *        Any validation errors that were found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationErrors(Collection<ValidationError> validationErrors);

        /**
         * <p>
         * Any validation errors that were found.
         * </p>
         * 
         * @param validationErrors
         *        Any validation errors that were found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationErrors(ValidationError... validationErrors);

        /**
         * <p>
         * Any validation errors that were found.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ValidationError>.Builder} avoiding the need
         * to create one manually via {@link List<ValidationError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ValidationError>.Builder#build()} is called immediately and
         * its result is passed to {@link #validationErrors(List<ValidationError>)}.
         * 
         * @param validationErrors
         *        a consumer that will call methods on {@link List<ValidationError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationErrors(List<ValidationError>)
         */
        Builder validationErrors(Consumer<ValidationError.Builder>... validationErrors);

        /**
         * <p>
         * Any validation warnings that were found.
         * </p>
         * 
         * @param validationWarnings
         *        Any validation warnings that were found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationWarnings(Collection<ValidationWarning> validationWarnings);

        /**
         * <p>
         * Any validation warnings that were found.
         * </p>
         * 
         * @param validationWarnings
         *        Any validation warnings that were found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationWarnings(ValidationWarning... validationWarnings);

        /**
         * <p>
         * Any validation warnings that were found.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ValidationWarning>.Builder} avoiding the
         * need to create one manually via {@link List<ValidationWarning>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ValidationWarning>.Builder#build()} is called immediately
         * and its result is passed to {@link #validationWarnings(List<ValidationWarning>)}.
         * 
         * @param validationWarnings
         *        a consumer that will call methods on {@link List<ValidationWarning>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationWarnings(List<ValidationWarning>)
         */
        Builder validationWarnings(Consumer<ValidationWarning.Builder>... validationWarnings);

        /**
         * <p>
         * Indicates whether there were validation errors.
         * </p>
         * 
         * @param errored
         *        Indicates whether there were validation errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errored(Boolean errored);
    }

    static final class BuilderImpl extends DataPipelineResponse.BuilderImpl implements Builder {
        private List<ValidationError> validationErrors = DefaultSdkAutoConstructList.getInstance();

        private List<ValidationWarning> validationWarnings = DefaultSdkAutoConstructList.getInstance();

        private Boolean errored;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidatePipelineDefinitionResponse model) {
            super(model);
            validationErrors(model.validationErrors);
            validationWarnings(model.validationWarnings);
            errored(model.errored);
        }

        public final Collection<ValidationError.Builder> getValidationErrors() {
            return validationErrors != null ? validationErrors.stream().map(ValidationError::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationErrors(Collection<ValidationError> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copy(validationErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(ValidationError... validationErrors) {
            validationErrors(Arrays.asList(validationErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(Consumer<ValidationError.Builder>... validationErrors) {
            validationErrors(Stream.of(validationErrors).map(c -> ValidationError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setValidationErrors(Collection<ValidationError.BuilderImpl> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copyFromBuilder(validationErrors);
        }

        public final Collection<ValidationWarning.Builder> getValidationWarnings() {
            return validationWarnings != null ? validationWarnings.stream().map(ValidationWarning::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationWarnings(Collection<ValidationWarning> validationWarnings) {
            this.validationWarnings = ValidationWarningsCopier.copy(validationWarnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationWarnings(ValidationWarning... validationWarnings) {
            validationWarnings(Arrays.asList(validationWarnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationWarnings(Consumer<ValidationWarning.Builder>... validationWarnings) {
            validationWarnings(Stream.of(validationWarnings).map(c -> ValidationWarning.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setValidationWarnings(Collection<ValidationWarning.BuilderImpl> validationWarnings) {
            this.validationWarnings = ValidationWarningsCopier.copyFromBuilder(validationWarnings);
        }

        public final Boolean getErrored() {
            return errored;
        }

        @Override
        public final Builder errored(Boolean errored) {
            this.errored = errored;
            return this;
        }

        public final void setErrored(Boolean errored) {
            this.errored = errored;
        }

        @Override
        public ValidatePipelineDefinitionResponse build() {
            return new ValidatePipelineDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
