/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a validation error. Validation errors prevent pipeline activation. The set of validation errors that can be
 * returned are defined by AWS Data Pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationError implements SdkPojo, Serializable, ToCopyableBuilder<ValidationError.Builder, ValidationError> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ValidationError::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<List<String>> ERRORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ValidationError::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ERRORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final List<String> errors;

    private ValidationError(BuilderImpl builder) {
        this.id = builder.id;
        this.errors = builder.errors;
    }

    /**
     * <p>
     * The identifier of the object that contains the validation error.
     * </p>
     * 
     * @return The identifier of the object that contains the validation error.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * A description of the validation error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A description of the validation error.
     */
    public List<String> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(errors());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationError)) {
            return false;
        }
        ValidationError other = (ValidationError) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(errors(), other.errors());
    }

    @Override
    public String toString() {
        return ToString.builder("ValidationError").add("Id", id()).add("Errors", errors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidationError, T> g) {
        return obj -> g.apply((ValidationError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationError> {
        /**
         * <p>
         * The identifier of the object that contains the validation error.
         * </p>
         * 
         * @param id
         *        The identifier of the object that contains the validation error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A description of the validation error.
         * </p>
         * 
         * @param errors
         *        A description of the validation error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<String> errors);

        /**
         * <p>
         * A description of the validation error.
         * </p>
         * 
         * @param errors
         *        A description of the validation error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(String... errors);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private List<String> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationError model) {
            id(model.id);
            errors(model.errors);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<String> getErrors() {
            return errors;
        }

        @Override
        public final Builder errors(Collection<String> errors) {
            this.errors = _validationMessagesCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(String... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        public final void setErrors(Collection<String> errors) {
            this.errors = _validationMessagesCopier.copy(errors);
        }

        @Override
        public ValidationError build() {
            return new ValidationError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
