/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeObjects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeObjectsRequest extends DataPipelineRequest implements
        ToCopyableBuilder<DescribeObjectsRequest.Builder, DescribeObjectsRequest> {
    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeObjectsRequest::pipelineId)).setter(setter(Builder::pipelineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineId").build()).build();

    private static final SdkField<List<String>> OBJECT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeObjectsRequest::objectIds))
            .setter(setter(Builder::objectIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> EVALUATE_EXPRESSIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DescribeObjectsRequest::evaluateExpressions)).setter(setter(Builder::evaluateExpressions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluateExpressions").build())
            .build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeObjectsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ID_FIELD,
            OBJECT_IDS_FIELD, EVALUATE_EXPRESSIONS_FIELD, MARKER_FIELD));

    private final String pipelineId;

    private final List<String> objectIds;

    private final Boolean evaluateExpressions;

    private final String marker;

    private DescribeObjectsRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineId = builder.pipelineId;
        this.objectIds = builder.objectIds;
        this.evaluateExpressions = builder.evaluateExpressions;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The ID of the pipeline that contains the object definitions.
     * </p>
     * 
     * @return The ID of the pipeline that contains the object definitions.
     */
    public String pipelineId() {
        return pipelineId;
    }

    /**
     * <p>
     * The IDs of the pipeline objects that contain the definitions to be described. You can pass as many as 25
     * identifiers in a single call to <code>DescribeObjects</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the pipeline objects that contain the definitions to be described. You can pass as many as 25
     *         identifiers in a single call to <code>DescribeObjects</code>.
     */
    public List<String> objectIds() {
        return objectIds;
    }

    /**
     * <p>
     * Indicates whether any expressions in the object should be evaluated when the object descriptions are returned.
     * </p>
     * 
     * @return Indicates whether any expressions in the object should be evaluated when the object descriptions are
     *         returned.
     */
    public Boolean evaluateExpressions() {
        return evaluateExpressions;
    }

    /**
     * <p>
     * The starting point for the results to be returned. For the first call, this value should be empty. As long as
     * there are more results, continue to call <code>DescribeObjects</code> with the marker value from the previous
     * call to retrieve the next set of results.
     * </p>
     * 
     * @return The starting point for the results to be returned. For the first call, this value should be empty. As
     *         long as there are more results, continue to call <code>DescribeObjects</code> with the marker value from
     *         the previous call to retrieve the next set of results.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(objectIds());
        hashCode = 31 * hashCode + Objects.hashCode(evaluateExpressions());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeObjectsRequest)) {
            return false;
        }
        DescribeObjectsRequest other = (DescribeObjectsRequest) obj;
        return Objects.equals(pipelineId(), other.pipelineId()) && Objects.equals(objectIds(), other.objectIds())
                && Objects.equals(evaluateExpressions(), other.evaluateExpressions()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeObjectsRequest").add("PipelineId", pipelineId()).add("ObjectIds", objectIds())
                .add("EvaluateExpressions", evaluateExpressions()).add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineId":
            return Optional.ofNullable(clazz.cast(pipelineId()));
        case "objectIds":
            return Optional.ofNullable(clazz.cast(objectIds()));
        case "evaluateExpressions":
            return Optional.ofNullable(clazz.cast(evaluateExpressions()));
        case "marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeObjectsRequest, T> g) {
        return obj -> g.apply((DescribeObjectsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataPipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeObjectsRequest> {
        /**
         * <p>
         * The ID of the pipeline that contains the object definitions.
         * </p>
         * 
         * @param pipelineId
         *        The ID of the pipeline that contains the object definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineId(String pipelineId);

        /**
         * <p>
         * The IDs of the pipeline objects that contain the definitions to be described. You can pass as many as 25
         * identifiers in a single call to <code>DescribeObjects</code>.
         * </p>
         * 
         * @param objectIds
         *        The IDs of the pipeline objects that contain the definitions to be described. You can pass as many as
         *        25 identifiers in a single call to <code>DescribeObjects</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectIds(Collection<String> objectIds);

        /**
         * <p>
         * The IDs of the pipeline objects that contain the definitions to be described. You can pass as many as 25
         * identifiers in a single call to <code>DescribeObjects</code>.
         * </p>
         * 
         * @param objectIds
         *        The IDs of the pipeline objects that contain the definitions to be described. You can pass as many as
         *        25 identifiers in a single call to <code>DescribeObjects</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectIds(String... objectIds);

        /**
         * <p>
         * Indicates whether any expressions in the object should be evaluated when the object descriptions are
         * returned.
         * </p>
         * 
         * @param evaluateExpressions
         *        Indicates whether any expressions in the object should be evaluated when the object descriptions are
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluateExpressions(Boolean evaluateExpressions);

        /**
         * <p>
         * The starting point for the results to be returned. For the first call, this value should be empty. As long as
         * there are more results, continue to call <code>DescribeObjects</code> with the marker value from the previous
         * call to retrieve the next set of results.
         * </p>
         * 
         * @param marker
         *        The starting point for the results to be returned. For the first call, this value should be empty. As
         *        long as there are more results, continue to call <code>DescribeObjects</code> with the marker value
         *        from the previous call to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataPipelineRequest.BuilderImpl implements Builder {
        private String pipelineId;

        private List<String> objectIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean evaluateExpressions;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeObjectsRequest model) {
            super(model);
            pipelineId(model.pipelineId);
            objectIds(model.objectIds);
            evaluateExpressions(model.evaluateExpressions);
            marker(model.marker);
        }

        public final String getPipelineId() {
            return pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final Collection<String> getObjectIds() {
            return objectIds;
        }

        @Override
        public final Builder objectIds(Collection<String> objectIds) {
            this.objectIds = _idListCopier.copy(objectIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectIds(String... objectIds) {
            objectIds(Arrays.asList(objectIds));
            return this;
        }

        public final void setObjectIds(Collection<String> objectIds) {
            this.objectIds = _idListCopier.copy(objectIds);
        }

        public final Boolean getEvaluateExpressions() {
            return evaluateExpressions;
        }

        @Override
        public final Builder evaluateExpressions(Boolean evaluateExpressions) {
            this.evaluateExpressions = evaluateExpressions;
            return this;
        }

        public final void setEvaluateExpressions(Boolean evaluateExpressions) {
            this.evaluateExpressions = evaluateExpressions;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeObjectsRequest build() {
            return new DescribeObjectsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
