/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeObjects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeObjectsResponse extends DataPipelineResponse implements
        ToCopyableBuilder<DescribeObjectsResponse.Builder, DescribeObjectsResponse> {
    private static final SdkField<List<PipelineObject>> PIPELINE_OBJECTS_FIELD = SdkField
            .<List<PipelineObject>> builder(MarshallingType.LIST)
            .memberName("pipelineObjects")
            .getter(getter(DescribeObjectsResponse::pipelineObjects))
            .setter(setter(Builder::pipelineObjects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineObjects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PipelineObject> builder(MarshallingType.SDK_POJO)
                                            .constructor(PipelineObject::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("marker")
            .getter(getter(DescribeObjectsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("marker").build()).build();

    private static final SdkField<Boolean> HAS_MORE_RESULTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("hasMoreResults").getter(getter(DescribeObjectsResponse::hasMoreResults))
            .setter(setter(Builder::hasMoreResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasMoreResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_OBJECTS_FIELD,
            MARKER_FIELD, HAS_MORE_RESULTS_FIELD));

    private final List<PipelineObject> pipelineObjects;

    private final String marker;

    private final Boolean hasMoreResults;

    private DescribeObjectsResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineObjects = builder.pipelineObjects;
        this.marker = builder.marker;
        this.hasMoreResults = builder.hasMoreResults;
    }

    /**
     * Returns true if the PipelineObjects property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPipelineObjects() {
        return pipelineObjects != null && !(pipelineObjects instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of object definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPipelineObjects()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of object definitions.
     */
    public List<PipelineObject> pipelineObjects() {
        return pipelineObjects;
    }

    /**
     * <p>
     * The starting point for the next page of results. To view the next page of results, call
     * <code>DescribeObjects</code> again with this marker value. If the value is null, there are no more results.
     * </p>
     * 
     * @return The starting point for the next page of results. To view the next page of results, call
     *         <code>DescribeObjects</code> again with this marker value. If the value is null, there are no more
     *         results.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * Indicates whether there are more results to return.
     * </p>
     * 
     * @return Indicates whether there are more results to return.
     */
    public Boolean hasMoreResults() {
        return hasMoreResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineObjects());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasMoreResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeObjectsResponse)) {
            return false;
        }
        DescribeObjectsResponse other = (DescribeObjectsResponse) obj;
        return Objects.equals(pipelineObjects(), other.pipelineObjects()) && Objects.equals(marker(), other.marker())
                && Objects.equals(hasMoreResults(), other.hasMoreResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeObjectsResponse").add("PipelineObjects", pipelineObjects()).add("Marker", marker())
                .add("HasMoreResults", hasMoreResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineObjects":
            return Optional.ofNullable(clazz.cast(pipelineObjects()));
        case "marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "hasMoreResults":
            return Optional.ofNullable(clazz.cast(hasMoreResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeObjectsResponse, T> g) {
        return obj -> g.apply((DescribeObjectsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataPipelineResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeObjectsResponse> {
        /**
         * <p>
         * An array of object definitions.
         * </p>
         * 
         * @param pipelineObjects
         *        An array of object definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineObjects(Collection<PipelineObject> pipelineObjects);

        /**
         * <p>
         * An array of object definitions.
         * </p>
         * 
         * @param pipelineObjects
         *        An array of object definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineObjects(PipelineObject... pipelineObjects);

        /**
         * <p>
         * An array of object definitions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PipelineObject>.Builder} avoiding the need
         * to create one manually via {@link List<PipelineObject>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PipelineObject>.Builder#build()} is called immediately and
         * its result is passed to {@link #pipelineObjects(List<PipelineObject>)}.
         * 
         * @param pipelineObjects
         *        a consumer that will call methods on {@link List<PipelineObject>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineObjects(List<PipelineObject>)
         */
        Builder pipelineObjects(Consumer<PipelineObject.Builder>... pipelineObjects);

        /**
         * <p>
         * The starting point for the next page of results. To view the next page of results, call
         * <code>DescribeObjects</code> again with this marker value. If the value is null, there are no more results.
         * </p>
         * 
         * @param marker
         *        The starting point for the next page of results. To view the next page of results, call
         *        <code>DescribeObjects</code> again with this marker value. If the value is null, there are no more
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Indicates whether there are more results to return.
         * </p>
         * 
         * @param hasMoreResults
         *        Indicates whether there are more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasMoreResults(Boolean hasMoreResults);
    }

    static final class BuilderImpl extends DataPipelineResponse.BuilderImpl implements Builder {
        private List<PipelineObject> pipelineObjects = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private Boolean hasMoreResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeObjectsResponse model) {
            super(model);
            pipelineObjects(model.pipelineObjects);
            marker(model.marker);
            hasMoreResults(model.hasMoreResults);
        }

        public final Collection<PipelineObject.Builder> getPipelineObjects() {
            return pipelineObjects != null ? pipelineObjects.stream().map(PipelineObject::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder pipelineObjects(Collection<PipelineObject> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copy(pipelineObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineObjects(PipelineObject... pipelineObjects) {
            pipelineObjects(Arrays.asList(pipelineObjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineObjects(Consumer<PipelineObject.Builder>... pipelineObjects) {
            pipelineObjects(Stream.of(pipelineObjects).map(c -> PipelineObject.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPipelineObjects(Collection<PipelineObject.BuilderImpl> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copyFromBuilder(pipelineObjects);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getHasMoreResults() {
            return hasMoreResults;
        }

        @Override
        public final Builder hasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
            return this;
        }

        public final void setHasMoreResults(Boolean hasMoreResults) {
            this.hasMoreResults = hasMoreResults;
        }

        @Override
        public DescribeObjectsResponse build() {
            return new DescribeObjectsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
