/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribePipelines.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePipelinesResponse extends DataPipelineResponse implements
        ToCopyableBuilder<DescribePipelinesResponse.Builder, DescribePipelinesResponse> {
    private static final SdkField<List<PipelineDescription>> PIPELINE_DESCRIPTION_LIST_FIELD = SdkField
            .<List<PipelineDescription>> builder(MarshallingType.LIST)
            .memberName("pipelineDescriptionList")
            .getter(getter(DescribePipelinesResponse::pipelineDescriptionList))
            .setter(setter(Builder::pipelineDescriptionList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineDescriptionList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PipelineDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(PipelineDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PIPELINE_DESCRIPTION_LIST_FIELD));

    private final List<PipelineDescription> pipelineDescriptionList;

    private DescribePipelinesResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineDescriptionList = builder.pipelineDescriptionList;
    }

    /**
     * Returns true if the PipelineDescriptionList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPipelineDescriptionList() {
        return pipelineDescriptionList != null && !(pipelineDescriptionList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of descriptions for the specified pipelines.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPipelineDescriptionList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of descriptions for the specified pipelines.
     */
    public List<PipelineDescription> pipelineDescriptionList() {
        return pipelineDescriptionList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineDescriptionList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePipelinesResponse)) {
            return false;
        }
        DescribePipelinesResponse other = (DescribePipelinesResponse) obj;
        return Objects.equals(pipelineDescriptionList(), other.pipelineDescriptionList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribePipelinesResponse").add("PipelineDescriptionList", pipelineDescriptionList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineDescriptionList":
            return Optional.ofNullable(clazz.cast(pipelineDescriptionList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePipelinesResponse, T> g) {
        return obj -> g.apply((DescribePipelinesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataPipelineResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePipelinesResponse> {
        /**
         * <p>
         * An array of descriptions for the specified pipelines.
         * </p>
         * 
         * @param pipelineDescriptionList
         *        An array of descriptions for the specified pipelines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDescriptionList(Collection<PipelineDescription> pipelineDescriptionList);

        /**
         * <p>
         * An array of descriptions for the specified pipelines.
         * </p>
         * 
         * @param pipelineDescriptionList
         *        An array of descriptions for the specified pipelines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDescriptionList(PipelineDescription... pipelineDescriptionList);

        /**
         * <p>
         * An array of descriptions for the specified pipelines.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PipelineDescription>.Builder} avoiding the
         * need to create one manually via {@link List<PipelineDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PipelineDescription>.Builder#build()} is called immediately
         * and its result is passed to {@link #pipelineDescriptionList(List<PipelineDescription>)}.
         * 
         * @param pipelineDescriptionList
         *        a consumer that will call methods on {@link List<PipelineDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineDescriptionList(List<PipelineDescription>)
         */
        Builder pipelineDescriptionList(Consumer<PipelineDescription.Builder>... pipelineDescriptionList);
    }

    static final class BuilderImpl extends DataPipelineResponse.BuilderImpl implements Builder {
        private List<PipelineDescription> pipelineDescriptionList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePipelinesResponse model) {
            super(model);
            pipelineDescriptionList(model.pipelineDescriptionList);
        }

        public final Collection<PipelineDescription.Builder> getPipelineDescriptionList() {
            return pipelineDescriptionList != null ? pipelineDescriptionList.stream().map(PipelineDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pipelineDescriptionList(Collection<PipelineDescription> pipelineDescriptionList) {
            this.pipelineDescriptionList = PipelineDescriptionListCopier.copy(pipelineDescriptionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineDescriptionList(PipelineDescription... pipelineDescriptionList) {
            pipelineDescriptionList(Arrays.asList(pipelineDescriptionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineDescriptionList(Consumer<PipelineDescription.Builder>... pipelineDescriptionList) {
            pipelineDescriptionList(Stream.of(pipelineDescriptionList)
                    .map(c -> PipelineDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPipelineDescriptionList(Collection<PipelineDescription.BuilderImpl> pipelineDescriptionList) {
            this.pipelineDescriptionList = PipelineDescriptionListCopier.copyFromBuilder(pipelineDescriptionList);
        }

        @Override
        public DescribePipelinesResponse build() {
            return new DescribePipelinesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
