/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DeactivatePipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeactivatePipelineRequest extends DataPipelineRequest implements
        ToCopyableBuilder<DeactivatePipelineRequest.Builder, DeactivatePipelineRequest> {
    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineId").getter(getter(DeactivatePipelineRequest::pipelineId)).setter(setter(Builder::pipelineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineId").build()).build();

    private static final SdkField<Boolean> CANCEL_ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("cancelActive").getter(getter(DeactivatePipelineRequest::cancelActive))
            .setter(setter(Builder::cancelActive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cancelActive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ID_FIELD,
            CANCEL_ACTIVE_FIELD));

    private final String pipelineId;

    private final Boolean cancelActive;

    private DeactivatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineId = builder.pipelineId;
        this.cancelActive = builder.cancelActive;
    }

    /**
     * <p>
     * The ID of the pipeline.
     * </p>
     * 
     * @return The ID of the pipeline.
     */
    public String pipelineId() {
        return pipelineId;
    }

    /**
     * <p>
     * Indicates whether to cancel any running objects. The default is true, which sets the state of any running objects
     * to <code>CANCELED</code>. If this value is false, the pipeline is deactivated after all running objects finish.
     * </p>
     * 
     * @return Indicates whether to cancel any running objects. The default is true, which sets the state of any running
     *         objects to <code>CANCELED</code>. If this value is false, the pipeline is deactivated after all running
     *         objects finish.
     */
    public Boolean cancelActive() {
        return cancelActive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(cancelActive());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeactivatePipelineRequest)) {
            return false;
        }
        DeactivatePipelineRequest other = (DeactivatePipelineRequest) obj;
        return Objects.equals(pipelineId(), other.pipelineId()) && Objects.equals(cancelActive(), other.cancelActive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeactivatePipelineRequest").add("PipelineId", pipelineId()).add("CancelActive", cancelActive())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineId":
            return Optional.ofNullable(clazz.cast(pipelineId()));
        case "cancelActive":
            return Optional.ofNullable(clazz.cast(cancelActive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeactivatePipelineRequest, T> g) {
        return obj -> g.apply((DeactivatePipelineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataPipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeactivatePipelineRequest> {
        /**
         * <p>
         * The ID of the pipeline.
         * </p>
         * 
         * @param pipelineId
         *        The ID of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineId(String pipelineId);

        /**
         * <p>
         * Indicates whether to cancel any running objects. The default is true, which sets the state of any running
         * objects to <code>CANCELED</code>. If this value is false, the pipeline is deactivated after all running
         * objects finish.
         * </p>
         * 
         * @param cancelActive
         *        Indicates whether to cancel any running objects. The default is true, which sets the state of any
         *        running objects to <code>CANCELED</code>. If this value is false, the pipeline is deactivated after
         *        all running objects finish.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelActive(Boolean cancelActive);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataPipelineRequest.BuilderImpl implements Builder {
        private String pipelineId;

        private Boolean cancelActive;

        private BuilderImpl() {
        }

        private BuilderImpl(DeactivatePipelineRequest model) {
            super(model);
            pipelineId(model.pipelineId);
            cancelActive(model.cancelActive);
        }

        public final String getPipelineId() {
            return pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final Boolean getCancelActive() {
            return cancelActive;
        }

        @Override
        public final Builder cancelActive(Boolean cancelActive) {
            this.cancelActive = cancelActive;
            return this;
        }

        public final void setCancelActive(Boolean cancelActive) {
            this.cancelActive = cancelActive;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeactivatePipelineRequest build() {
            return new DeactivatePipelineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
