/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for SetStatus.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetStatusRequest extends DataPipelineRequest implements
        ToCopyableBuilder<SetStatusRequest.Builder, SetStatusRequest> {
    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineId").getter(getter(SetStatusRequest::pipelineId)).setter(setter(Builder::pipelineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineId").build()).build();

    private static final SdkField<List<String>> OBJECT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("objectIds")
            .getter(getter(SetStatusRequest::objectIds))
            .setter(setter(Builder::objectIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SetStatusRequest::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ID_FIELD,
            OBJECT_IDS_FIELD, STATUS_FIELD));

    private final String pipelineId;

    private final List<String> objectIds;

    private final String status;

    private SetStatusRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineId = builder.pipelineId;
        this.objectIds = builder.objectIds;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the pipeline that contains the objects.
     * </p>
     * 
     * @return The ID of the pipeline that contains the objects.
     */
    public String pipelineId() {
        return pipelineId;
    }

    /**
     * Returns true if the ObjectIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasObjectIds() {
        return objectIds != null && !(objectIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the objects. The corresponding objects can be either physical or components, but not a mix of both
     * types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasObjectIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the objects. The corresponding objects can be either physical or components, but not a mix of
     *         both types.
     */
    public List<String> objectIds() {
        return objectIds;
    }

    /**
     * <p>
     * The status to be set on all the objects specified in <code>objectIds</code>. For components, use
     * <code>PAUSE</code> or <code>RESUME</code>. For instances, use <code>TRY_CANCEL</code>, <code>RERUN</code>, or
     * <code>MARK_FINISHED</code>.
     * </p>
     * 
     * @return The status to be set on all the objects specified in <code>objectIds</code>. For components, use
     *         <code>PAUSE</code> or <code>RESUME</code>. For instances, use <code>TRY_CANCEL</code>, <code>RERUN</code>
     *         , or <code>MARK_FINISHED</code>.
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(hasObjectIds() ? objectIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetStatusRequest)) {
            return false;
        }
        SetStatusRequest other = (SetStatusRequest) obj;
        return Objects.equals(pipelineId(), other.pipelineId()) && hasObjectIds() == other.hasObjectIds()
                && Objects.equals(objectIds(), other.objectIds()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SetStatusRequest").add("PipelineId", pipelineId())
                .add("ObjectIds", hasObjectIds() ? objectIds() : null).add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineId":
            return Optional.ofNullable(clazz.cast(pipelineId()));
        case "objectIds":
            return Optional.ofNullable(clazz.cast(objectIds()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetStatusRequest, T> g) {
        return obj -> g.apply((SetStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataPipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetStatusRequest> {
        /**
         * <p>
         * The ID of the pipeline that contains the objects.
         * </p>
         * 
         * @param pipelineId
         *        The ID of the pipeline that contains the objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineId(String pipelineId);

        /**
         * <p>
         * The IDs of the objects. The corresponding objects can be either physical or components, but not a mix of both
         * types.
         * </p>
         * 
         * @param objectIds
         *        The IDs of the objects. The corresponding objects can be either physical or components, but not a mix
         *        of both types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectIds(Collection<String> objectIds);

        /**
         * <p>
         * The IDs of the objects. The corresponding objects can be either physical or components, but not a mix of both
         * types.
         * </p>
         * 
         * @param objectIds
         *        The IDs of the objects. The corresponding objects can be either physical or components, but not a mix
         *        of both types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectIds(String... objectIds);

        /**
         * <p>
         * The status to be set on all the objects specified in <code>objectIds</code>. For components, use
         * <code>PAUSE</code> or <code>RESUME</code>. For instances, use <code>TRY_CANCEL</code>, <code>RERUN</code>, or
         * <code>MARK_FINISHED</code>.
         * </p>
         * 
         * @param status
         *        The status to be set on all the objects specified in <code>objectIds</code>. For components, use
         *        <code>PAUSE</code> or <code>RESUME</code>. For instances, use <code>TRY_CANCEL</code>,
         *        <code>RERUN</code>, or <code>MARK_FINISHED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataPipelineRequest.BuilderImpl implements Builder {
        private String pipelineId;

        private List<String> objectIds = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SetStatusRequest model) {
            super(model);
            pipelineId(model.pipelineId);
            objectIds(model.objectIds);
            status(model.status);
        }

        public final String getPipelineId() {
            return pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final Collection<String> getObjectIds() {
            if (objectIds instanceof SdkAutoConstructList) {
                return null;
            }
            return objectIds;
        }

        @Override
        public final Builder objectIds(Collection<String> objectIds) {
            this.objectIds = _idListCopier.copy(objectIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectIds(String... objectIds) {
            objectIds(Arrays.asList(objectIds));
            return this;
        }

        public final void setObjectIds(Collection<String> objectIds) {
            this.objectIds = _idListCopier.copy(objectIds);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetStatusRequest build() {
            return new SetStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
