/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for PutPipelineDefinition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutPipelineDefinitionRequest extends DataPipelineRequest implements
        ToCopyableBuilder<PutPipelineDefinitionRequest.Builder, PutPipelineDefinitionRequest> {
    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineId").getter(getter(PutPipelineDefinitionRequest::pipelineId))
            .setter(setter(Builder::pipelineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineId").build()).build();

    private static final SdkField<List<PipelineObject>> PIPELINE_OBJECTS_FIELD = SdkField
            .<List<PipelineObject>> builder(MarshallingType.LIST)
            .memberName("pipelineObjects")
            .getter(getter(PutPipelineDefinitionRequest::pipelineObjects))
            .setter(setter(Builder::pipelineObjects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineObjects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PipelineObject> builder(MarshallingType.SDK_POJO)
                                            .constructor(PipelineObject::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParameterObject>> PARAMETER_OBJECTS_FIELD = SdkField
            .<List<ParameterObject>> builder(MarshallingType.LIST)
            .memberName("parameterObjects")
            .getter(getter(PutPipelineDefinitionRequest::parameterObjects))
            .setter(setter(Builder::parameterObjects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterObjects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterObject> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterObject::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParameterValue>> PARAMETER_VALUES_FIELD = SdkField
            .<List<ParameterValue>> builder(MarshallingType.LIST)
            .memberName("parameterValues")
            .getter(getter(PutPipelineDefinitionRequest::parameterValues))
            .setter(setter(Builder::parameterValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ID_FIELD,
            PIPELINE_OBJECTS_FIELD, PARAMETER_OBJECTS_FIELD, PARAMETER_VALUES_FIELD));

    private final String pipelineId;

    private final List<PipelineObject> pipelineObjects;

    private final List<ParameterObject> parameterObjects;

    private final List<ParameterValue> parameterValues;

    private PutPipelineDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineId = builder.pipelineId;
        this.pipelineObjects = builder.pipelineObjects;
        this.parameterObjects = builder.parameterObjects;
        this.parameterValues = builder.parameterValues;
    }

    /**
     * <p>
     * The ID of the pipeline.
     * </p>
     * 
     * @return The ID of the pipeline.
     */
    public String pipelineId() {
        return pipelineId;
    }

    /**
     * Returns true if the PipelineObjects property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPipelineObjects() {
        return pipelineObjects != null && !(pipelineObjects instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The objects that define the pipeline. These objects overwrite the existing pipeline definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPipelineObjects()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The objects that define the pipeline. These objects overwrite the existing pipeline definition.
     */
    public List<PipelineObject> pipelineObjects() {
        return pipelineObjects;
    }

    /**
     * Returns true if the ParameterObjects property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasParameterObjects() {
        return parameterObjects != null && !(parameterObjects instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameter objects used with the pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameterObjects()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The parameter objects used with the pipeline.
     */
    public List<ParameterObject> parameterObjects() {
        return parameterObjects;
    }

    /**
     * Returns true if the ParameterValues property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasParameterValues() {
        return parameterValues != null && !(parameterValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameter values used with the pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameterValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The parameter values used with the pipeline.
     */
    public List<ParameterValue> parameterValues() {
        return parameterValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPipelineObjects() ? pipelineObjects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterObjects() ? parameterObjects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterValues() ? parameterValues() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPipelineDefinitionRequest)) {
            return false;
        }
        PutPipelineDefinitionRequest other = (PutPipelineDefinitionRequest) obj;
        return Objects.equals(pipelineId(), other.pipelineId()) && hasPipelineObjects() == other.hasPipelineObjects()
                && Objects.equals(pipelineObjects(), other.pipelineObjects())
                && hasParameterObjects() == other.hasParameterObjects()
                && Objects.equals(parameterObjects(), other.parameterObjects())
                && hasParameterValues() == other.hasParameterValues()
                && Objects.equals(parameterValues(), other.parameterValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutPipelineDefinitionRequest").add("PipelineId", pipelineId())
                .add("PipelineObjects", hasPipelineObjects() ? pipelineObjects() : null)
                .add("ParameterObjects", hasParameterObjects() ? parameterObjects() : null)
                .add("ParameterValues", hasParameterValues() ? parameterValues() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineId":
            return Optional.ofNullable(clazz.cast(pipelineId()));
        case "pipelineObjects":
            return Optional.ofNullable(clazz.cast(pipelineObjects()));
        case "parameterObjects":
            return Optional.ofNullable(clazz.cast(parameterObjects()));
        case "parameterValues":
            return Optional.ofNullable(clazz.cast(parameterValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutPipelineDefinitionRequest, T> g) {
        return obj -> g.apply((PutPipelineDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataPipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutPipelineDefinitionRequest> {
        /**
         * <p>
         * The ID of the pipeline.
         * </p>
         * 
         * @param pipelineId
         *        The ID of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineId(String pipelineId);

        /**
         * <p>
         * The objects that define the pipeline. These objects overwrite the existing pipeline definition.
         * </p>
         * 
         * @param pipelineObjects
         *        The objects that define the pipeline. These objects overwrite the existing pipeline definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineObjects(Collection<PipelineObject> pipelineObjects);

        /**
         * <p>
         * The objects that define the pipeline. These objects overwrite the existing pipeline definition.
         * </p>
         * 
         * @param pipelineObjects
         *        The objects that define the pipeline. These objects overwrite the existing pipeline definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineObjects(PipelineObject... pipelineObjects);

        /**
         * <p>
         * The objects that define the pipeline. These objects overwrite the existing pipeline definition.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PipelineObject>.Builder} avoiding the need
         * to create one manually via {@link List<PipelineObject>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PipelineObject>.Builder#build()} is called immediately and
         * its result is passed to {@link #pipelineObjects(List<PipelineObject>)}.
         * 
         * @param pipelineObjects
         *        a consumer that will call methods on {@link List<PipelineObject>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineObjects(List<PipelineObject>)
         */
        Builder pipelineObjects(Consumer<PipelineObject.Builder>... pipelineObjects);

        /**
         * <p>
         * The parameter objects used with the pipeline.
         * </p>
         * 
         * @param parameterObjects
         *        The parameter objects used with the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterObjects(Collection<ParameterObject> parameterObjects);

        /**
         * <p>
         * The parameter objects used with the pipeline.
         * </p>
         * 
         * @param parameterObjects
         *        The parameter objects used with the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterObjects(ParameterObject... parameterObjects);

        /**
         * <p>
         * The parameter objects used with the pipeline.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ParameterObject>.Builder} avoiding the need
         * to create one manually via {@link List<ParameterObject>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ParameterObject>.Builder#build()} is called immediately and
         * its result is passed to {@link #parameterObjects(List<ParameterObject>)}.
         * 
         * @param parameterObjects
         *        a consumer that will call methods on {@link List<ParameterObject>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterObjects(List<ParameterObject>)
         */
        Builder parameterObjects(Consumer<ParameterObject.Builder>... parameterObjects);

        /**
         * <p>
         * The parameter values used with the pipeline.
         * </p>
         * 
         * @param parameterValues
         *        The parameter values used with the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValues(Collection<ParameterValue> parameterValues);

        /**
         * <p>
         * The parameter values used with the pipeline.
         * </p>
         * 
         * @param parameterValues
         *        The parameter values used with the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValues(ParameterValue... parameterValues);

        /**
         * <p>
         * The parameter values used with the pipeline.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ParameterValue>.Builder} avoiding the need
         * to create one manually via {@link List<ParameterValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ParameterValue>.Builder#build()} is called immediately and
         * its result is passed to {@link #parameterValues(List<ParameterValue>)}.
         * 
         * @param parameterValues
         *        a consumer that will call methods on {@link List<ParameterValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterValues(List<ParameterValue>)
         */
        Builder parameterValues(Consumer<ParameterValue.Builder>... parameterValues);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataPipelineRequest.BuilderImpl implements Builder {
        private String pipelineId;

        private List<PipelineObject> pipelineObjects = DefaultSdkAutoConstructList.getInstance();

        private List<ParameterObject> parameterObjects = DefaultSdkAutoConstructList.getInstance();

        private List<ParameterValue> parameterValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutPipelineDefinitionRequest model) {
            super(model);
            pipelineId(model.pipelineId);
            pipelineObjects(model.pipelineObjects);
            parameterObjects(model.parameterObjects);
            parameterValues(model.parameterValues);
        }

        public final String getPipelineId() {
            return pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final Collection<PipelineObject.Builder> getPipelineObjects() {
            if (pipelineObjects instanceof SdkAutoConstructList) {
                return null;
            }
            return pipelineObjects != null ? pipelineObjects.stream().map(PipelineObject::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder pipelineObjects(Collection<PipelineObject> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copy(pipelineObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineObjects(PipelineObject... pipelineObjects) {
            pipelineObjects(Arrays.asList(pipelineObjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineObjects(Consumer<PipelineObject.Builder>... pipelineObjects) {
            pipelineObjects(Stream.of(pipelineObjects).map(c -> PipelineObject.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPipelineObjects(Collection<PipelineObject.BuilderImpl> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copyFromBuilder(pipelineObjects);
        }

        public final Collection<ParameterObject.Builder> getParameterObjects() {
            if (parameterObjects instanceof SdkAutoConstructList) {
                return null;
            }
            return parameterObjects != null ? parameterObjects.stream().map(ParameterObject::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterObjects(Collection<ParameterObject> parameterObjects) {
            this.parameterObjects = ParameterObjectListCopier.copy(parameterObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterObjects(ParameterObject... parameterObjects) {
            parameterObjects(Arrays.asList(parameterObjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterObjects(Consumer<ParameterObject.Builder>... parameterObjects) {
            parameterObjects(Stream.of(parameterObjects).map(c -> ParameterObject.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParameterObjects(Collection<ParameterObject.BuilderImpl> parameterObjects) {
            this.parameterObjects = ParameterObjectListCopier.copyFromBuilder(parameterObjects);
        }

        public final Collection<ParameterValue.Builder> getParameterValues() {
            if (parameterValues instanceof SdkAutoConstructList) {
                return null;
            }
            return parameterValues != null ? parameterValues.stream().map(ParameterValue::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder parameterValues(Collection<ParameterValue> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copy(parameterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterValues(ParameterValue... parameterValues) {
            parameterValues(Arrays.asList(parameterValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterValues(Consumer<ParameterValue.Builder>... parameterValues) {
            parameterValues(Stream.of(parameterValues).map(c -> ParameterValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParameterValues(Collection<ParameterValue.BuilderImpl> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copyFromBuilder(parameterValues);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutPipelineDefinitionRequest build() {
            return new PutPipelineDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
