/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a logical operation for comparing the value of a field with a specified value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Operator implements SdkPojo, Serializable, ToCopyableBuilder<Operator.Builder, Operator> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Operator::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(Operator::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final List<String> values;

    private Operator(BuilderImpl builder) {
        this.type = builder.type;
        this.values = builder.values;
    }

    /**
     * <p>
     * The logical operation to be performed: equal (<code>EQ</code>), equal reference (<code>REF_EQ</code>), less than
     * or equal (<code>LE</code>), greater than or equal (<code>GE</code>), or between (<code>BETWEEN</code>). Equal
     * reference (<code>REF_EQ</code>) can be used only with reference fields. The other comparison types can be used
     * only with String fields. The comparison types you can use apply only to certain object fields, as detailed below.
     * </p>
     * <p>
     * The comparison operators EQ and REF_EQ act on the following fields:
     * </p>
     * <ul>
     * <li>name</li>
     * <li>@sphere</li>
     * <li>parent</li>
     * <li>@componentParent</li>
     * <li>@instanceParent</li>
     * <li>@status</li>
     * <li>@scheduledStartTime</li>
     * <li>@scheduledEndTime</li>
     * <li>@actualStartTime</li>
     * <li>@actualEndTime</li>
     * </ul>
     * <p>
     * The comparison operators <code>GE</code>, <code>LE</code>, and <code>BETWEEN</code> act on the following fields:
     * </p>
     * <ul>
     * <li>@scheduledStartTime</li>
     * <li>@scheduledEndTime</li>
     * <li>@actualStartTime</li>
     * <li>@actualEndTime</li>
     * </ul>
     * <p>
     * Note that fields beginning with the at sign (@) are read-only and set by the web service. When you name fields,
     * you should choose names containing only alpha-numeric values, as symbols may be reserved by AWS Data Pipeline.
     * User-defined fields that you add to a pipeline should prefix their name with the string "my".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The logical operation to be performed: equal (<code>EQ</code>), equal reference (<code>REF_EQ</code>),
     *         less than or equal (<code>LE</code>), greater than or equal (<code>GE</code>), or between (
     *         <code>BETWEEN</code>). Equal reference (<code>REF_EQ</code>) can be used only with reference fields. The
     *         other comparison types can be used only with String fields. The comparison types you can use apply only
     *         to certain object fields, as detailed below. </p>
     *         <p>
     *         The comparison operators EQ and REF_EQ act on the following fields:
     *         </p>
     *         <ul>
     *         <li>name</li>
     *         <li>@sphere</li>
     *         <li>parent</li>
     *         <li>@componentParent</li>
     *         <li>@instanceParent</li>
     *         <li>@status</li>
     *         <li>@scheduledStartTime</li>
     *         <li>@scheduledEndTime</li>
     *         <li>@actualStartTime</li>
     *         <li>@actualEndTime</li>
     *         </ul>
     *         <p>
     *         The comparison operators <code>GE</code>, <code>LE</code>, and <code>BETWEEN</code> act on the following
     *         fields:
     *         </p>
     *         <ul>
     *         <li>@scheduledStartTime</li>
     *         <li>@scheduledEndTime</li>
     *         <li>@actualStartTime</li>
     *         <li>@actualEndTime</li>
     *         </ul>
     *         <p>
     *         Note that fields beginning with the at sign (@) are read-only and set by the web service. When you name
     *         fields, you should choose names containing only alpha-numeric values, as symbols may be reserved by AWS
     *         Data Pipeline. User-defined fields that you add to a pipeline should prefix their name with the string
     *         "my".
     * @see OperatorType
     */
    public final OperatorType type() {
        return OperatorType.fromValue(type);
    }

    /**
     * <p>
     * The logical operation to be performed: equal (<code>EQ</code>), equal reference (<code>REF_EQ</code>), less than
     * or equal (<code>LE</code>), greater than or equal (<code>GE</code>), or between (<code>BETWEEN</code>). Equal
     * reference (<code>REF_EQ</code>) can be used only with reference fields. The other comparison types can be used
     * only with String fields. The comparison types you can use apply only to certain object fields, as detailed below.
     * </p>
     * <p>
     * The comparison operators EQ and REF_EQ act on the following fields:
     * </p>
     * <ul>
     * <li>name</li>
     * <li>@sphere</li>
     * <li>parent</li>
     * <li>@componentParent</li>
     * <li>@instanceParent</li>
     * <li>@status</li>
     * <li>@scheduledStartTime</li>
     * <li>@scheduledEndTime</li>
     * <li>@actualStartTime</li>
     * <li>@actualEndTime</li>
     * </ul>
     * <p>
     * The comparison operators <code>GE</code>, <code>LE</code>, and <code>BETWEEN</code> act on the following fields:
     * </p>
     * <ul>
     * <li>@scheduledStartTime</li>
     * <li>@scheduledEndTime</li>
     * <li>@actualStartTime</li>
     * <li>@actualEndTime</li>
     * </ul>
     * <p>
     * Note that fields beginning with the at sign (@) are read-only and set by the web service. When you name fields,
     * you should choose names containing only alpha-numeric values, as symbols may be reserved by AWS Data Pipeline.
     * User-defined fields that you add to a pipeline should prefix their name with the string "my".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The logical operation to be performed: equal (<code>EQ</code>), equal reference (<code>REF_EQ</code>),
     *         less than or equal (<code>LE</code>), greater than or equal (<code>GE</code>), or between (
     *         <code>BETWEEN</code>). Equal reference (<code>REF_EQ</code>) can be used only with reference fields. The
     *         other comparison types can be used only with String fields. The comparison types you can use apply only
     *         to certain object fields, as detailed below. </p>
     *         <p>
     *         The comparison operators EQ and REF_EQ act on the following fields:
     *         </p>
     *         <ul>
     *         <li>name</li>
     *         <li>@sphere</li>
     *         <li>parent</li>
     *         <li>@componentParent</li>
     *         <li>@instanceParent</li>
     *         <li>@status</li>
     *         <li>@scheduledStartTime</li>
     *         <li>@scheduledEndTime</li>
     *         <li>@actualStartTime</li>
     *         <li>@actualEndTime</li>
     *         </ul>
     *         <p>
     *         The comparison operators <code>GE</code>, <code>LE</code>, and <code>BETWEEN</code> act on the following
     *         fields:
     *         </p>
     *         <ul>
     *         <li>@scheduledStartTime</li>
     *         <li>@scheduledEndTime</li>
     *         <li>@actualStartTime</li>
     *         <li>@actualEndTime</li>
     *         </ul>
     *         <p>
     *         Note that fields beginning with the at sign (@) are read-only and set by the web service. When you name
     *         fields, you should choose names containing only alpha-numeric values, as symbols may be reserved by AWS
     *         Data Pipeline. User-defined fields that you add to a pipeline should prefix their name with the string
     *         "my".
     * @see OperatorType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value that the actual field value will be compared with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The value that the actual field value will be compared with.
     */
    public final List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Operator)) {
            return false;
        }
        Operator other = (Operator) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Operator").add("Type", typeAsString()).add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Operator, T> g) {
        return obj -> g.apply((Operator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Operator> {
        /**
         * <p>
         * The logical operation to be performed: equal (<code>EQ</code>), equal reference (<code>REF_EQ</code>), less
         * than or equal (<code>LE</code>), greater than or equal (<code>GE</code>), or between (<code>BETWEEN</code>).
         * Equal reference (<code>REF_EQ</code>) can be used only with reference fields. The other comparison types can
         * be used only with String fields. The comparison types you can use apply only to certain object fields, as
         * detailed below.
         * </p>
         * <p>
         * The comparison operators EQ and REF_EQ act on the following fields:
         * </p>
         * <ul>
         * <li>name</li>
         * <li>@sphere</li>
         * <li>parent</li>
         * <li>@componentParent</li>
         * <li>@instanceParent</li>
         * <li>@status</li>
         * <li>@scheduledStartTime</li>
         * <li>@scheduledEndTime</li>
         * <li>@actualStartTime</li>
         * <li>@actualEndTime</li>
         * </ul>
         * <p>
         * The comparison operators <code>GE</code>, <code>LE</code>, and <code>BETWEEN</code> act on the following
         * fields:
         * </p>
         * <ul>
         * <li>@scheduledStartTime</li>
         * <li>@scheduledEndTime</li>
         * <li>@actualStartTime</li>
         * <li>@actualEndTime</li>
         * </ul>
         * <p>
         * Note that fields beginning with the at sign (@) are read-only and set by the web service. When you name
         * fields, you should choose names containing only alpha-numeric values, as symbols may be reserved by AWS Data
         * Pipeline. User-defined fields that you add to a pipeline should prefix their name with the string "my".
         * </p>
         * 
         * @param type
         *        The logical operation to be performed: equal (<code>EQ</code>), equal reference (<code>REF_EQ</code>),
         *        less than or equal (<code>LE</code>), greater than or equal (<code>GE</code>), or between (
         *        <code>BETWEEN</code>). Equal reference (<code>REF_EQ</code>) can be used only with reference fields.
         *        The other comparison types can be used only with String fields. The comparison types you can use apply
         *        only to certain object fields, as detailed below. </p>
         *        <p>
         *        The comparison operators EQ and REF_EQ act on the following fields:
         *        </p>
         *        <ul>
         *        <li>name</li>
         *        <li>@sphere</li>
         *        <li>parent</li>
         *        <li>@componentParent</li>
         *        <li>@instanceParent</li>
         *        <li>@status</li>
         *        <li>@scheduledStartTime</li>
         *        <li>@scheduledEndTime</li>
         *        <li>@actualStartTime</li>
         *        <li>@actualEndTime</li>
         *        </ul>
         *        <p>
         *        The comparison operators <code>GE</code>, <code>LE</code>, and <code>BETWEEN</code> act on the
         *        following fields:
         *        </p>
         *        <ul>
         *        <li>@scheduledStartTime</li>
         *        <li>@scheduledEndTime</li>
         *        <li>@actualStartTime</li>
         *        <li>@actualEndTime</li>
         *        </ul>
         *        <p>
         *        Note that fields beginning with the at sign (@) are read-only and set by the web service. When you
         *        name fields, you should choose names containing only alpha-numeric values, as symbols may be reserved
         *        by AWS Data Pipeline. User-defined fields that you add to a pipeline should prefix their name with the
         *        string "my".
         * @see OperatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatorType
         */
        Builder type(String type);

        /**
         * <p>
         * The logical operation to be performed: equal (<code>EQ</code>), equal reference (<code>REF_EQ</code>), less
         * than or equal (<code>LE</code>), greater than or equal (<code>GE</code>), or between (<code>BETWEEN</code>).
         * Equal reference (<code>REF_EQ</code>) can be used only with reference fields. The other comparison types can
         * be used only with String fields. The comparison types you can use apply only to certain object fields, as
         * detailed below.
         * </p>
         * <p>
         * The comparison operators EQ and REF_EQ act on the following fields:
         * </p>
         * <ul>
         * <li>name</li>
         * <li>@sphere</li>
         * <li>parent</li>
         * <li>@componentParent</li>
         * <li>@instanceParent</li>
         * <li>@status</li>
         * <li>@scheduledStartTime</li>
         * <li>@scheduledEndTime</li>
         * <li>@actualStartTime</li>
         * <li>@actualEndTime</li>
         * </ul>
         * <p>
         * The comparison operators <code>GE</code>, <code>LE</code>, and <code>BETWEEN</code> act on the following
         * fields:
         * </p>
         * <ul>
         * <li>@scheduledStartTime</li>
         * <li>@scheduledEndTime</li>
         * <li>@actualStartTime</li>
         * <li>@actualEndTime</li>
         * </ul>
         * <p>
         * Note that fields beginning with the at sign (@) are read-only and set by the web service. When you name
         * fields, you should choose names containing only alpha-numeric values, as symbols may be reserved by AWS Data
         * Pipeline. User-defined fields that you add to a pipeline should prefix their name with the string "my".
         * </p>
         * 
         * @param type
         *        The logical operation to be performed: equal (<code>EQ</code>), equal reference (<code>REF_EQ</code>),
         *        less than or equal (<code>LE</code>), greater than or equal (<code>GE</code>), or between (
         *        <code>BETWEEN</code>). Equal reference (<code>REF_EQ</code>) can be used only with reference fields.
         *        The other comparison types can be used only with String fields. The comparison types you can use apply
         *        only to certain object fields, as detailed below. </p>
         *        <p>
         *        The comparison operators EQ and REF_EQ act on the following fields:
         *        </p>
         *        <ul>
         *        <li>name</li>
         *        <li>@sphere</li>
         *        <li>parent</li>
         *        <li>@componentParent</li>
         *        <li>@instanceParent</li>
         *        <li>@status</li>
         *        <li>@scheduledStartTime</li>
         *        <li>@scheduledEndTime</li>
         *        <li>@actualStartTime</li>
         *        <li>@actualEndTime</li>
         *        </ul>
         *        <p>
         *        The comparison operators <code>GE</code>, <code>LE</code>, and <code>BETWEEN</code> act on the
         *        following fields:
         *        </p>
         *        <ul>
         *        <li>@scheduledStartTime</li>
         *        <li>@scheduledEndTime</li>
         *        <li>@actualStartTime</li>
         *        <li>@actualEndTime</li>
         *        </ul>
         *        <p>
         *        Note that fields beginning with the at sign (@) are read-only and set by the web service. When you
         *        name fields, you should choose names containing only alpha-numeric values, as symbols may be reserved
         *        by AWS Data Pipeline. User-defined fields that you add to a pipeline should prefix their name with the
         *        string "my".
         * @see OperatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatorType
         */
        Builder type(OperatorType type);

        /**
         * <p>
         * The value that the actual field value will be compared with.
         * </p>
         * 
         * @param values
         *        The value that the actual field value will be compared with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The value that the actual field value will be compared with.
         * </p>
         * 
         * @param values
         *        The value that the actual field value will be compared with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Operator model) {
            type(model.type);
            values(model.values);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(OperatorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<String> values) {
            this.values = _stringListCopier.copy(values);
        }

        @Override
        @Transient
        public final Builder values(Collection<String> values) {
            this.values = _stringListCopier.copy(values);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        public Operator build() {
            return new Operator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
