/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.ParameterValue;
import software.amazon.awssdk.services.datapipeline.model.ParameterValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActivatePipelineRequest
extends DataPipelineRequest
implements ToCopyableBuilder<Builder, ActivatePipelineRequest> {
    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineId").getter(ActivatePipelineRequest.getter(ActivatePipelineRequest::pipelineId)).setter(ActivatePipelineRequest.setter(Builder::pipelineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineId").build()}).build();
    private static final SdkField<List<ParameterValue>> PARAMETER_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parameterValues").getter(ActivatePipelineRequest.getter(ActivatePipelineRequest::parameterValues)).setter(ActivatePipelineRequest.setter(Builder::parameterValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTimestamp").getter(ActivatePipelineRequest.getter(ActivatePipelineRequest::startTimestamp)).setter(ActivatePipelineRequest.setter(Builder::startTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ID_FIELD, PARAMETER_VALUES_FIELD, START_TIMESTAMP_FIELD));
    private final String pipelineId;
    private final List<ParameterValue> parameterValues;
    private final Instant startTimestamp;

    private ActivatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineId = builder.pipelineId;
        this.parameterValues = builder.parameterValues;
        this.startTimestamp = builder.startTimestamp;
    }

    public final String pipelineId() {
        return this.pipelineId;
    }

    public final boolean hasParameterValues() {
        return this.parameterValues != null && !(this.parameterValues instanceof SdkAutoConstructList);
    }

    public final List<ParameterValue> parameterValues() {
        return this.parameterValues;
    }

    public final Instant startTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterValues() ? this.parameterValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivatePipelineRequest)) {
            return false;
        }
        ActivatePipelineRequest other = (ActivatePipelineRequest)((Object)obj);
        return Objects.equals(this.pipelineId(), other.pipelineId()) && this.hasParameterValues() == other.hasParameterValues() && Objects.equals(this.parameterValues(), other.parameterValues()) && Objects.equals(this.startTimestamp(), other.startTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"ActivatePipelineRequest").add("PipelineId", (Object)this.pipelineId()).add("ParameterValues", this.hasParameterValues() ? this.parameterValues() : null).add("StartTimestamp", (Object)this.startTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineId": {
                return Optional.ofNullable(clazz.cast(this.pipelineId()));
            }
            case "parameterValues": {
                return Optional.ofNullable(clazz.cast(this.parameterValues()));
            }
            case "startTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivatePipelineRequest, T> g) {
        return obj -> g.apply((ActivatePipelineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataPipelineRequest.BuilderImpl
    implements Builder {
        private String pipelineId;
        private List<ParameterValue> parameterValues = DefaultSdkAutoConstructList.getInstance();
        private Instant startTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivatePipelineRequest model) {
            super(model);
            this.pipelineId(model.pipelineId);
            this.parameterValues(model.parameterValues);
            this.startTimestamp(model.startTimestamp);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        @Override
        @Transient
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final List<ParameterValue.Builder> getParameterValues() {
            List<ParameterValue.Builder> result = ParameterValueListCopier.copyToBuilder(this.parameterValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterValues(Collection<ParameterValue.BuilderImpl> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copyFromBuilder(parameterValues);
        }

        @Override
        @Transient
        public final Builder parameterValues(Collection<ParameterValue> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copy(parameterValues);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parameterValues(ParameterValue ... parameterValues) {
            this.parameterValues(Arrays.asList(parameterValues));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parameterValues(Consumer<ParameterValue.Builder> ... parameterValues) {
            this.parameterValues(Stream.of(parameterValues).map(c -> (ParameterValue)((ParameterValue.Builder)ParameterValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        @Transient
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ActivatePipelineRequest build() {
            return new ActivatePipelineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataPipelineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ActivatePipelineRequest> {
        public Builder pipelineId(String var1);

        public Builder parameterValues(Collection<ParameterValue> var1);

        public Builder parameterValues(ParameterValue ... var1);

        public Builder parameterValues(Consumer<ParameterValue.Builder> ... var1);

        public Builder startTimestamp(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

