/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ParameterAttributeListCopier {
    static List<ParameterAttribute> copy(Collection<? extends ParameterAttribute> parameterAttributeListParam) {
        List<ParameterAttribute> list;
        if (parameterAttributeListParam == null || parameterAttributeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ParameterAttribute> modifiableList = new ArrayList<>();
            parameterAttributeListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ParameterAttribute> copyFromBuilder(Collection<? extends ParameterAttribute.Builder> parameterAttributeListParam) {
        List<ParameterAttribute> list;
        if (parameterAttributeListParam == null || parameterAttributeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ParameterAttribute> modifiableList = new ArrayList<>();
            parameterAttributeListParam.forEach(entry -> {
                ParameterAttribute member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ParameterAttribute.Builder> copyToBuilder(Collection<? extends ParameterAttribute> parameterAttributeListParam) {
        List<ParameterAttribute.Builder> list;
        if (parameterAttributeListParam == null || parameterAttributeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ParameterAttribute.Builder> modifiableList = new ArrayList<>();
            parameterAttributeListParam.forEach(entry -> {
                ParameterAttribute.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
