/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.datapipeline.DataPipelineAsyncClient;
import software.amazon.awssdk.services.datapipeline.DataPipelineAsyncClientBuilder;
import software.amazon.awssdk.services.datapipeline.DataPipelineServiceClientConfiguration;
import software.amazon.awssdk.services.datapipeline.DefaultDataPipelineAsyncClient;
import software.amazon.awssdk.services.datapipeline.DefaultDataPipelineBaseClientBuilder;
import software.amazon.awssdk.services.datapipeline.endpoints.DataPipelineEndpointProvider;

@SdkInternalApi
final class DefaultDataPipelineAsyncClientBuilder
extends DefaultDataPipelineBaseClientBuilder<DataPipelineAsyncClientBuilder, DataPipelineAsyncClient>
implements DataPipelineAsyncClientBuilder {
    DefaultDataPipelineAsyncClientBuilder() {
    }

    @Override
    public DefaultDataPipelineAsyncClientBuilder endpointProvider(DataPipelineEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DataPipelineAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultDataPipelineAsyncClientBuilder.validateClientOptions(clientConfiguration);
        DataPipelineServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDataPipelineAsyncClient client = new DefaultDataPipelineAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DataPipelineServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DataPipelineServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

