/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.datapipeline.DataPipelineClient;
import software.amazon.awssdk.services.datapipeline.DataPipelineClientBuilder;
import software.amazon.awssdk.services.datapipeline.DataPipelineServiceClientConfiguration;
import software.amazon.awssdk.services.datapipeline.DefaultDataPipelineBaseClientBuilder;
import software.amazon.awssdk.services.datapipeline.DefaultDataPipelineClient;
import software.amazon.awssdk.services.datapipeline.endpoints.DataPipelineEndpointProvider;

@SdkInternalApi
final class DefaultDataPipelineClientBuilder
extends DefaultDataPipelineBaseClientBuilder<DataPipelineClientBuilder, DataPipelineClient>
implements DataPipelineClientBuilder {
    DefaultDataPipelineClientBuilder() {
    }

    @Override
    public DefaultDataPipelineClientBuilder endpointProvider(DataPipelineEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DataPipelineClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDataPipelineClientBuilder.validateClientOptions(clientConfiguration);
        DataPipelineServiceClientConfiguration serviceClientConfiguration = DataPipelineServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultDataPipelineClient(serviceClientConfiguration, clientConfiguration);
    }
}

